package com.bxm.localnews.news.model.vo;

import com.bxm.localnews.common.vo.INewsIdSharding;
import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel("新闻评论实体")
public class AdminNewsReply implements IUserIdSharding, INewsIdSharding {

    @ApiModelProperty("评论ID")
    private Long id;

    @ApiModelProperty("新闻ID")
    private Long newsId;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date addTime;

    @ApiModelProperty("删除标记 0：未删除  1：已删除")
    private Byte deleteFlag = 0;

    @ApiModelProperty("回复的根id 直接评论新闻则是0，回复新闻下的评论则显示新闻评论id")
    private Long rootId;

    @ApiModelProperty("回复层次 0:直接评论新闻 1:回复新闻下的评论 2:回复新闻下评论的回复")
    private Byte level;

    @ApiModelProperty("回复点赞数")
    private Integer likeCount;

    @ApiModelProperty("类型：1.新闻  2.小视频  3.社区")
    private Byte type;

    @ApiModelProperty("状态 0:待展示  1:已展示")
    private Byte status;

    @ApiModelProperty("互动值")
    private Integer interactiveCount;

    @ApiModelProperty("评论上级id，0为第一级,即新闻下的直接评论")
    private Long parentId;

    @ApiModelProperty("被评论用户id")
    private Long parentUserId;

    @ApiModelProperty(value = "被评论用户是否是马甲号用户")
    private Byte isVirtualParentUser = 0;

    @ApiModelProperty("被评论用户昵称")
    private String parentUserNickname;

    @ApiModelProperty("被评论用户头像地址")
    private String parentHeadImg;

    @ApiModelProperty(value = "评论内容", required = true)
    private String replyContent;

    @ApiModelProperty(value = "评论人用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "评论用户是否是马甲号用户")
    private Byte isVirtualUser = 0;

    @ApiModelProperty("评论人昵称")
    private String userNickname;

    @ApiModelProperty("评论人头像地址")
    private String headImg;

    @ApiModelProperty("是否用户删除,0运营删除,1用户删除")
    private Byte isUserDelete;

    @ApiModelProperty("马甲号互动,0未互动,1已互动")
    private Byte vestInteract;

    @ApiModelProperty("app端添加的用户id")
    private Long addAppUserId;

    @ApiModelProperty("评论的用户类型0:普通用户 1:马甲用户")
    private Byte replyUserType;

    public Byte getReplyUserType() {
        return replyUserType;
    }

    public void setReplyUserType(Byte replyUserType) {
        this.replyUserType = replyUserType;
    }

    public Long getAddAppUserId() {
        return addAppUserId;
    }

    public void setAddAppUserId(Long addAppUserId) {
        this.addAppUserId = addAppUserId;
    }

    public Long getId() {
        return id;
    }

    public AdminNewsReply setId(Long id) {
        this.id = id;
        return this;
    }

    @Override
    public Long getNewsId() {
        return newsId;
    }

    public AdminNewsReply setNewsId(Long newsId) {
        this.newsId = newsId;
        return this;
    }

    public Date getAddTime() {
        return addTime;
    }

    public AdminNewsReply setAddTime(Date addTime) {
        this.addTime = addTime;
        return this;
    }

    public Byte getDeleteFlag() {
        return deleteFlag;
    }

    public AdminNewsReply setDeleteFlag(Byte deleteFlag) {
        this.deleteFlag = deleteFlag;
        return this;
    }

    public Long getRootId() {
        return rootId;
    }

    public AdminNewsReply setRootId(Long rootId) {
        this.rootId = rootId;
        return this;
    }

    public Byte getLevel() {
        return level;
    }

    public AdminNewsReply setLevel(Byte level) {
        this.level = level;
        return this;
    }

    public Integer getLikeCount() {
        return likeCount;
    }

    public AdminNewsReply setLikeCount(Integer likeCount) {
        this.likeCount = likeCount;
        return this;
    }

    public Byte getType() {
        return type;
    }

    public AdminNewsReply setType(Byte type) {
        this.type = type;
        return this;
    }

    public Byte getStatus() {
        return status;
    }

    public AdminNewsReply setStatus(Byte status) {
        this.status = status;
        return this;
    }

    public Integer getInteractiveCount() {
        return interactiveCount;
    }

    public AdminNewsReply setInteractiveCount(Integer interactiveCount) {
        this.interactiveCount = interactiveCount;
        return this;
    }

    public Long getParentId() {
        return parentId;
    }

    public AdminNewsReply setParentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    public Long getParentUserId() {
        return parentUserId;
    }

    public AdminNewsReply setParentUserId(Long parentUserId) {
        this.parentUserId = parentUserId;
        return this;
    }

    public String getParentUserNickname() {
        return parentUserNickname;
    }

    public AdminNewsReply setParentUserNickname(String parentUserNickname) {
        this.parentUserNickname = parentUserNickname;
        return this;
    }

    public String getParentHeadImg() {
        return parentHeadImg;
    }

    public AdminNewsReply setParentHeadImg(String parentHeadImg) {
        this.parentHeadImg = parentHeadImg;
        return this;
    }

    public String getReplyContent() {
        return replyContent;
    }

    public AdminNewsReply setReplyContent(String replyContent) {
        this.replyContent = replyContent;
        return this;
    }

    @Override
    public Long getUserId() {
        return userId;
    }

    public AdminNewsReply setUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public String getUserNickname() {
        return userNickname;
    }

    public AdminNewsReply setUserNickname(String userNickname) {
        this.userNickname = userNickname;
        return this;
    }

    public String getHeadImg() {
        return headImg;
    }

    public AdminNewsReply setHeadImg(String headImg) {
        this.headImg = headImg;
        return this;
    }

    public Byte getIsVirtualParentUser() {
        return isVirtualParentUser;
    }

    public AdminNewsReply setIsVirtualParentUser(Byte isVirtualParentUser) {
        this.isVirtualParentUser = isVirtualParentUser;
        return this;
    }

    public Byte getIsVirtualUser() {
        return isVirtualUser;
    }

    public AdminNewsReply setIsVirtualUser(Byte isVirtualUser) {
        this.isVirtualUser = isVirtualUser;
        return this;
    }

    public Byte getIsUserDelete() {
        return isUserDelete;
    }

    public AdminNewsReply setIsUserDelete(Byte isUserDelete) {
        this.isUserDelete = isUserDelete;
        return this;
    }

    public Byte getVestInteract() {
        return vestInteract;
    }

    public AdminNewsReply setVestInteract(Byte vestInteract) {
        this.vestInteract = vestInteract;
        return this;
    }
}
