package com.bxm.localnews.news.model.vo;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@ApiModel(description = "话题")
@Data
public class AdminTopic {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("图片")
    private String img;

    @ApiModelProperty("排序权重")
    private Integer order;

    @ApiModelProperty("是否启用：0禁用 1启用")
    private Byte enable;

    @ApiModelProperty("是否投放全国：0否 1是")
    private Byte isGlobal;

    @ApiModelProperty("地区编码数组")
    private List<String> areaCodes;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("地区数组")
    private List<Location> areas;

    @ApiModelProperty("引导发帖文案")
    private String leadPostContent;

    @ApiModelProperty("头条/本地圈推荐语")
    private String recommendContent;

    @ApiModelProperty("参与者代号")
    private String joinCode;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("用户发帖选择该话题时的引导性质文案")
    private String forumPostGuide;
}
