package com.bxm.localnews.news.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * t_video
 *
 * @author
 */
@ApiModel(description = "视频")
public class AdminVideo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @ApiModelProperty("id")
    private Long id;

    /**
     * 第三方导入的ID
     */
    @ApiModelProperty("第三方导入id")
    private Long tid;

    /**
     * 视频描述
     */
    @ApiModelProperty("描述")
    private String description;

    /**
     * 视频标题
     */
    @ApiModelProperty("标题")
    private String title;

    /**
     * 视频图片
     */
    @ApiModelProperty("图片")
    private String videoImg;

    /**
     * 视频播放地址
     */
    @ApiModelProperty("播放地址")
    private String videoUrl;

    /**
     * 作者ID
     */
    @ApiModelProperty("作者id")
    private Long authorId;

    /**
     * 作者头像
     */
    @ApiModelProperty("作者头像")
    private String authorImg;

    /**
     * 作者名称
     */
    @ApiModelProperty("作者名称")
    private String authorName;

    /**
     * 视频创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;

    /**
     * 爬取时间
     */
    @ApiModelProperty("爬取时间")
    private Date issueTime;

    /**
     * 视频状态（0：无效，1：有效）
     */
    @ApiModelProperty("视频状态：0无效 1有效")
    private Byte status;

    /**
     * 评论次数
     */
    @ApiModelProperty("评论数")
    private Long commentCount;

    /**
     * 分享次数
     */
    @ApiModelProperty("分享次数")
    private Long shareCount;

    /**
     * 点赞次数
     */
    @ApiModelProperty("点赞数")
    private Long likeCount;

    /**
     * 点击播放次数
     */
    @ApiModelProperty("播放量")
    private Long clickCount;

    @ApiModelProperty("是否是热门")
    private Byte hot;

    @ApiModelProperty("热门过期时间")
    private Date hotExpireTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTid() {
        return tid;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVideoImg() {
        return videoImg;
    }

    public void setVideoImg(String videoImg) {
        this.videoImg = videoImg;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public Long getAuthorId() {
        return authorId;
    }

    public void setAuthorId(Long authorId) {
        this.authorId = authorId;
    }

    public String getAuthorImg() {
        return authorImg;
    }

    public void setAuthorImg(String authorImg) {
        this.authorImg = authorImg;
    }

    public String getAuthorName() {
        return authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getIssueTime() {
        return issueTime;
    }

    public void setIssueTime(Date issueTime) {
        this.issueTime = issueTime;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Long getCommentCount() {
        return commentCount;
    }

    public void setCommentCount(Long commentCount) {
        this.commentCount = commentCount;
    }

    public Long getShareCount() {
        return shareCount;
    }

    public void setShareCount(Long shareCount) {
        this.shareCount = shareCount;
    }

    public Long getLikeCount() {
        return likeCount;
    }

    public void setLikeCount(Long likeCount) {
        this.likeCount = likeCount;
    }

    public Long getClickCount() {
        return clickCount;
    }

    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public Byte getHot() {
        return hot;
    }

    public void setHot(Byte hot) {
        this.hot = hot;
    }

    public Date getHotExpireTime() {
        return hotExpireTime;
    }

    public void setHotExpireTime(Date hotExpireTime) {
        this.hotExpireTime = hotExpireTime;
    }
}