/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.model.dto;

import com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class ContentContext {
    private String content;
    private Document document;
    private int model = 1;
    private Map<ForumContentPlaceHolderEnum, Supplier<?>> replaceMap = Maps.newHashMap();

    public ContentContext(String content) {
        this.content = content;
        this.switchContentToDocumentModel();
    }

    public ContentContext addReplaceType(ForumContentPlaceHolderEnum holderType, Supplier<?> value) {
        if (Objects.nonNull((Object)holderType) && Objects.nonNull(value)) {
            this.replaceMap.put(holderType, value);
        }
        return this;
    }

    public <T> Supplier<T> getReplaceValue(ForumContentPlaceHolderEnum holderType) {
        return this.replaceMap.get((Object)holderType);
    }

    public void switchDocumentToContentModel() {
        if (this.model != 1) {
            this.content = this.document.body().html().replace("\n", "");
            this.model = 1;
        }
    }

    public void switchContentToDocumentModel() {
        if (this.model != 0) {
            this.document = Jsoup.parse((String)this.content);
            this.document.outputSettings().prettyPrint(true).indentAmount(1);
            this.model = 0;
        }
    }

    public String getContent() {
        return this.model == 0 ? this.document.body().html().replace("\n", "") : this.content;
    }

    public void setContent(String content) {
        if (this.model == 1) {
            this.content = content;
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public Map<ForumContentPlaceHolderEnum, Supplier<?>> getReplaceMap() {
        return this.replaceMap;
    }
}

