/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.model.param;

public class Keyword
implements Comparable<Keyword> {
    private double tfidfvalue;
    private String name;

    public Keyword() {
    }

    public Keyword(String name, double tfidfvalue) {
        this.name = name;
        this.tfidfvalue = (double)Math.round(tfidfvalue * 10000.0) / 10000.0;
    }

    public double getTfidfvalue() {
        return this.tfidfvalue;
    }

    public void setTfidfvalue(double tfidfvalue) {
        this.tfidfvalue = tfidfvalue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(Keyword o) {
        return this.tfidfvalue == o.tfidfvalue ? 0 : (this.tfidfvalue - o.tfidfvalue > 0.0 ? -1 : 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        long temp = Double.doubleToLongBits(this.tfidfvalue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Keyword other = (Keyword)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "Keyword{tfidfvalue=" + this.tfidfvalue + ", name='" + this.name + '\'' + '}';
    }
}

