package com.bxm.localnews.news.convert;

import com.bxm.localnews.dto.MixRecommendDTO;
import com.bxm.localnews.news.dto.ForumPostDTO;
import com.bxm.localnews.news.vo.ForumPostVo;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ForumPostConvert {

    /**
     * 将forumPostVo转换成forumPostDTO
     *
     * @param forumPostVo
     * @return
     */
    public static ForumPostDTO convertForumPost2DTO(ForumPostVo forumPostVo) {
        ForumPostDTO forumPostDTO = new ForumPostDTO();
        forumPostDTO.setClickCount(forumPostVo.getClickCount());
        forumPostDTO.setCommentCount(forumPostVo.getCommentCount());
        if (null == forumPostVo.getDisplayTag()) {
            forumPostDTO.setHot((byte) 1);
        } else {
            forumPostDTO.setHot((byte) (forumPostVo.getDisplayTag() == 1 ? 2 : 3));
        }
        forumPostDTO.setId(forumPostVo.getId());
        forumPostDTO.setIsBrilliant(forumPostVo.getIsBrilliant());
        forumPostDTO.setUserId(forumPostVo.getUserId());
        forumPostDTO.setUserImg(forumPostVo.getUserImg());
        forumPostDTO.setUserName(forumPostVo.getUserName());
        forumPostDTO.setLikeCount(forumPostVo.getLikeCount());
        forumPostDTO.setLiked(forumPostVo.getLiked());
        forumPostDTO.setShareCount(forumPostVo.getShareCount());
        forumPostDTO.setTitle(forumPostVo.getTitle());
        forumPostDTO.setStatus(forumPostVo.getStatus());
        forumPostDTO.setDisplayTime(forumPostVo.getDisplayDateTime());
        forumPostDTO.setTop((byte) 1);
        forumPostDTO.setCollect(0);
        forumPostDTO.setForum(forumPostVo.getForum());
        forumPostDTO.setPostImgList(forumPostVo.getPostImgList());
        return forumPostDTO;
    }

    /**
     * 将相关推荐返回id进行识别（是否为帖子是否为新闻）
     *
     * @param ids
     * @return
     */
    public static List<MixRecommendDTO> convertIds2MixRecommendDTO(List<Long> ids) {
        return ids.stream().filter(e->(Objects.nonNull(e) && e !=0 )).map(x -> {
            MixRecommendDTO mixRecommendDTO = new MixRecommendDTO();
            mixRecommendDTO.setId(x);
            String idStr = String.valueOf(x);
            if (idStr.startsWith("4") && idStr.length() == 16) {
                mixRecommendDTO.setOrigin("1");
            } else {
                mixRecommendDTO.setOrigin("2");
            }
            return mixRecommendDTO;
        }).collect(Collectors.toList());
    }

}
