package com.bxm.localnews.news.service;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.param.NewsParam;
import com.bxm.localnews.news.vo.*;

import java.util.List;

/**
 * Created by hsq 10:31 2018/2/8
 */
public interface NewsService {

    /**
     * 获取新闻详情页跳转地址
     * @param id
     * @param userId
     * @param type   1：详情地址  2：分享地址 3：搜索文章查看详情地址 4:广告分享链接（newsId为广告id）
     * @return
     */
    Json<NewsUrlVo> getUrl(Long id, Long userId, Byte type);

    /**
     * 新闻视频推荐
     * @param newsId
     * @return
     */
    Json<List<News4Client>> queryRecommendNews(Long newsId, Long userId,Integer size);

    /**
     * 组图推荐
     * @param newsId
     * @return
     */
    Json<List<News4Client>> queryRecommendNews4ImgNews(Long newsId);


    /**
     * 新闻详情
     * @param newsParam
     * @return
     */
    Json<NewsDetailVO> execGetSyDetail(NewsParam newsParam);

    /**
     * 阅读文章返回时调用
     * @param newsId
     * @param userId
     * @param viewTime   阅读时间
     * @param tabType    是否读取到文章末尾 1：否   2：是
     * @param advertShow 广告位是否展示出来 1：否  2：是
     * @return
     */
    Json getBack(Long newsId, Long userId, Integer viewTime, String tabType, String advertShow);

    /**
     * 获取热门搜索标题
     * @return
     */
    Json<List<NewsSearchWord>> searchHotTitle();

    /**
     * 视频分类
     * @return
     */
    Json<List<NewsKind>> searchKinds();

    /**
     * 无效视频重新抓取
     * @param newsId
     * @return
     */
    Json<FailVideo> getFailVideo(Long newsId);

    /**
     * 点击次数+1
     * @param newsId
     * @return
     */
    Json addClick(Long newsId);

    void delNewsTag();

    /**
     * 构建新闻详情访问路径
     * @param newsId 新闻ID
     * @param userId 用户ID
     * @return 新闻最终的落地页路径
     */
    String buildNewsDetailUrl(Long newsId, Long userId);

    /**
     * 构建分享的新闻路径
     * @param newsId 新闻ID
     * @param userId 用户ID
     * @return 新闻最终的分享落地页路径
     */
    String buildNewsShareUrl(Long newsId, Long userId);

    /**
     * 填充新闻的额外参数
     * @param userId 当前推荐用户
     * @param result 推荐结果
     */
    void fillExtInfo(Long userId, List<News> result);

    /**
     * 根据新闻id获取详情,由客户端调用
     * @param
     * @return
     */
    Json<NewsDetailVO> getNewsDetailById(NewsParam newsParam);
}
