package com.bxm.localnews.news.service;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.MixRecommendDTO;
import com.bxm.localnews.news.param.HomeRecommendParam;
import com.bxm.localnews.news.vo.News4Client;
import com.bxm.localnews.news.vo.NewsMeta;
import com.bxm.localnews.news.vo.NewsRecommendParam;
import com.bxm.localnews.news.vo.NewsTopListParam;

import java.util.List;

/**
 * 用户新闻推荐接口
 */
public interface RecommendService {

    /**
     * 给用户推荐信息
     * 1.首先去缓存池找有无数据
     * 2.如果有缓存则走直接获取数据
     * 3.如果没有缓存，则去mysql通用推荐表中取得相应数据进行计算得到推荐数据，并触发线程执行录入缓存
     * 4.通用数据库中建立新表存储推荐数据，数据量保持一定5000-10000，定时任务用来更新数据的时效
     * @param param 推荐参数
     * @return 推荐结果
     */
    Json<NewsMeta> execRecommend(NewsRecommendParam param);


    /**
     * 获取置顶的新闻
     * @param param
     * @return
     */
    Json<NewsMeta> getTopNewsList(NewsTopListParam param);


    /**
     * 首页推荐（混合推荐）
     * 如果首页频道，且开通了社区，那么就走新2.1.0推荐器
     * 如果是别的频道，那么就走旧推荐器
     * @param param
     * @param basicParam 基础参数
     * @return
     */
    Json<NewsMeta> listMixRecommend(HomeRecommendParam param, BasicParam basicParam);


    /**
     * 获取置顶的新闻和帖子
     * @param param
     * @return
     */
    Json<NewsMeta> listTopMixRecommend(NewsTopListParam param);

    /**
     * 根据混合推荐id列表获取帖子和新闻的列表
     * @param mixRecommendDTOList
     * @param userId
     * @param areaCode
     * @return
     */
    List<News4Client> listNews4Client(List<MixRecommendDTO> mixRecommendDTOList, Long userId, String areaCode);
}
