package com.bxm.localnews.news.service.impl;
import com.bxm.localnews.integration.NewsSearchIntegrationService;
import com.bxm.localnews.news.constant.NewsTemplateConst;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.service.AssemblyService;
import com.bxm.localnews.news.vo.NewsVO;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Objects;

@Slf4j
@Service
public class AssemblyServiceImpl implements AssemblyService {
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private ForumPostMapper forumPostMapper;
    @Autowired
    private NewsSearchIntegrationService newsSearchIntegrationService;
    @Autowired
    private AliyunOSSService aliyunOSSService;

    @Override
    public String getUrlContentByUrl(String urlString) {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream in =null;
        InputStreamReader isr = null;
        BufferedReader bufr = null;
        try {
            URL url = new URL(urlString);
            in =url.openStream();
            isr = new InputStreamReader(in);
            bufr = new BufferedReader(isr);
            String str;
            while ((str = bufr.readLine()) != null) {
                stringBuilder.append(str);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            try {
                if (Objects.nonNull(bufr)){
                    bufr.close();
                }
                if (Objects.nonNull(isr)){
                    isr.close();
                }
                if (Objects.nonNull(in)){
                    in.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }


        }
        return stringBuilder.toString();

    }

    @Override
    public String assemblyContent(String target) {
        String newsTemplate = NewsTemplateConst.getNewsTemplate();
        if (StringUtils.isBlank(newsTemplate)){
            newsTemplate = aliyunOSSService.getOssContentByPath("news/detail.html");
            NewsTemplateConst.setNewsTemplate(newsTemplate);
        }
        if (StringUtils.isNotBlank(target)){
            String replace = newsTemplate.replace( "{body}",target);
            return replace;
        }
        return newsTemplate;
    }


}
