package com.bxm.localnews.news.service.impl;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.dto.MixRecommendDTO;
import com.bxm.localnews.dto.User;
import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.facade.QuartzIntegrationService;
import com.bxm.localnews.integration.*;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.constant.AppConst;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.convert.ForumPostConvert;
import com.bxm.localnews.news.domain.*;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.dto.PostTopicDTO;
import com.bxm.localnews.news.dto.ReplenishmentDTO;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.param.ForumPostInformParam;
import com.bxm.localnews.news.param.ForumPostListQueryParam;
import com.bxm.localnews.news.param.ForumPostListUserQueryParam;
import com.bxm.localnews.news.param.UserTopPostBuildParam;
import com.bxm.localnews.news.service.*;
import com.bxm.localnews.news.vo.*;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.localnews.param.ForumParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class ForumServiceImpl extends BaseService implements ForumService {

    @Resource
    private ForumMapper forumMapper;

    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private SensitiveWordService sensitiveWordService;

    @Resource
    private ForumPostShareMapper forumPostShareMapper;

    @Resource
    private ForumPostInformMapper forumPostInformMapper;

    @Resource
    private ForumPostCollectMapper forumPostCollectMapper;

    @Resource
    private ForumPostLikeMapper forumPostLikeMapper;

    @Resource
    private ForumPostMapper forumPostMapper;

    @Resource
    private UserIntegrationService userIntegrationService;

    @Resource
    private NewsRecommendIntegrationService newsRecommendIntegrationService;

    @Resource
    private BizLogIntegrationService bizLogIntegrationService;

    @Resource
    private AssemblyService assemblyService;

    @Resource
    private NewsReadRewardService newsReadRewardService;

    @Resource
    private MixedRecommendPoolMapper mixedRecommendPoolMapper;

    @Resource
    private NewsMapper newsMapper;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;

    @Resource
    private ForumPostRecordMapper forumPostRecordMapper;

    @Resource
    private BizConfigProperties bizConfigProperties;

    @Resource
    private QuartzIntegrationService quartzIntegrationService;

    @Resource
    private RedisListAdapter redisListAdapter;

    @Resource
    private LocationIntegrationService locationIntegrationService;

    @Resource
    private MessageIntegrationService messageIntegrationService;

    @Resource
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;

    @Override
    public List<ForumVo> getForumList(String areaCode, Integer enable) {
        return forumMapper.getForumList(areaCode, enable);
    }

    @Override
    public ForumVo selectForumById(Long id) {
        return forumMapper.selectForumById(id);
    }

    @Override
    public List<TopicVo> getTopicList(String areaCode, Integer enable) {
        return forumMapper.getTopicList(areaCode, enable);
    }

    @Override
    public TopicVo selectTopicById(Long id) {
        return forumMapper.selectTopicById(id);
    }

    @Override
    public PageWarper<ForumPostVo> getPostPage(ForumPostListQueryParam param) {
        if (null == param) {
            return null;
        }

        PageWarper<ForumPostVo> forumPostPage = new PageWarper<>();
        List<ForumPostVo> postList = new ArrayList<>();
        int operationId = 2;

        if (0 == param.getType()) {
            operationId = 4;
        } else if (1 == param.getType()) {
            operationId = 6;
        } else if (2 == param.getType()) {
            if (null != param.getForumId()) {
                operationId = 5;
            } else {
                operationId = 3;
            }
        }

        ForumParam forumParam = new ForumParam();
        forumParam.setForumId(param.getForumId());
        forumParam.setTopicId(param.getTopicId());
        forumParam.setUserId(param.getUserId());
        forumParam.setActionType(param.getRecommendType());
        forumParam.setAreaCode(param.getAreaCode());
        forumParam.setOperationId(operationId);
        forumParam.setPageNum(param.getPageNum());
        forumParam.setPageSize(param.getPageSize());
        List<Long> postIdList = newsRecommendIntegrationService.recommendList(forumParam);

        if (CollectionUtils.isNotEmpty(postIdList)) {
            for (Long postId : postIdList) {
                ForumPostVo postVo = forumMapper.getPostDetailById(postId);
                if (null != postVo) {
                    postList.add(postVo);
                }
            }
            forumPostPage.setList(postList);
            forumPostPage.setPageNum(param.getPageNum());
            forumPostPage.setPageSize(param.getPageSize());
            completePostListInfo(forumPostPage.getList(), param.getUserId());
        }

        if (CollectionUtils.isEmpty(postIdList) || postIdList.size() < param.getPageSize()) {
            forumPostPage.setIsLastPage(true);
            forumPostPage.setHasNextPage(false);
        } else {
            forumPostPage.setHasNextPage(true);
        }

        return forumPostPage;
    }

    @Override
    public PageWarper<ForumPostVo> getPostPageByUser(ForumPostListUserQueryParam param) {
        PageWarper<ForumPostVo> forumPostList = new PageWarper<>();

        if (null == param || null == param.getType()) {
            return null;
        }
        if (1 == param.getType()) {
            forumPostList = new PageWarper<>(forumMapper.getPostList(param));
        } else if (2 == param.getType()) {
            forumPostList = new PageWarper<>(forumMapper.getCollectPostList(param));
        }
        completePostListInfo(forumPostList.getList(), param.getUserId());

        return forumPostList;
    }

    @Override
    public ForumPostVo getPostDetailById(Long id, Long userId, String deviceId) {
        ForumPostVo forumPostVo = forumMapper.getPostDetailById(id);
        completePostInfo(forumPostVo, userId);

        if (null != forumPostVo) {
            if ("1".equals(deviceId)) {
                if (forumPostVo.getStatus() != null && (3 == forumPostVo.getStatus() || 4 == forumPostVo.getStatus())) {
                    return null;
                }
            } else {
                String content = assemblyService.assemblyContent(forumPostVo.getContent());
                forumPostVo.setContent(content);
            }
        }
        this.generateRecord(userId, id);

        return forumPostVo;
    }

    @Override
    public int createOrUpdatePost(ForumBasicVo forumBasicVo) {
        ForumPostVo forumPostVo = new ForumPostVo();
        BeanUtils.copyProperties(forumBasicVo, forumPostVo);

        if (sensitiveWordService.contains(forumPostVo.getTextField())) {
            return -1;
        }

        Long id = forumPostVo.getId();
        forumPostVo.setStatus(2);

        if (StringUtils.isNotBlank(forumPostVo.getAreaCode()) && forumPostVo.getAreaCode().length() < 12) {
            String areaCode = forumPostVo.getAreaCode() + "000000000000".substring(forumPostVo.getAreaCode().length());
            forumPostVo.setAreaCode(areaCode);
        }

        //组装content
        StringBuilder content = new StringBuilder("<p>");
        if (StringUtils.isNotBlank(forumPostVo.getTextField())) {
            content.append(forumPostVo.getTextField().replaceAll("\\n", "</p><p>"));
        }
        content.append("</p>");
        if (CollectionUtils.isNotEmpty(forumPostVo.getPostImgList())) {
            forumPostVo.setImgList(JSON.toJSONString(forumPostVo.getPostImgList()));
            for (PostImgVo postImgVo : forumPostVo.getPostImgList()) {
                content.append("<img style=\"margin-top:20px\" src=\"");
                content.append(postImgVo.getImgUrl());
                content.append("\"></img>");
            }
        }
        forumPostVo.setContent(content.toString());

        int update;
        if (null == id) {
            id = getPostId();
            forumPostVo.setId(id);
            UserBean user = userIntegrationService.selectUserFromCache(forumPostVo.getUserId());
            if (null != user) {
                forumPostVo.setUserImg(user.getHeadImg());
                forumPostVo.setUserName(user.getNickname());
            }
            forumPostVo.setCreateTime(new Date());
            forumPostVo.setDisplayDateTime(new Date());
            forumPostVo.setPublishTime(new Date());

            update = this.forumMapper.insertSelective(forumPostVo);

            asyncCallService(forumPostVo);
            this.asyncCreatePostUserTopTaskJob(forumPostVo);
        } else {
            update = this.forumMapper.updateByPrimaryKeySelective(forumPostVo);
            this.forumPostMapper.deleteMixRecommandPoolById(id);
        }

        if (CollectionUtils.isNotEmpty(forumPostVo.getTopicIdList())) {
            List<PostTopicDTO> list = new ArrayList<>();
            for (Long topicId : forumPostVo.getTopicIdList()) {
                PostTopicDTO postTopicDTO = new PostTopicDTO();
                postTopicDTO.setId(sequenceCreater.nextLongId());
                postTopicDTO.setPostId(forumPostVo.getId());
                postTopicDTO.setTopicId(topicId);
                list.add(postTopicDTO);
            }
            this.forumMapper.batchDeleteTopic(forumPostVo.getId());
            this.forumMapper.batchInsertTopic(list);
        }

        return update;
    }

    @Async
    public void asyncCallService(ForumPostVo forumPostVo) {
        try {
            userIntegrationService.addPostReplyNum(forumPostVo.getUserId(), 1);
            bizLogIntegrationService.forumSuccessed(forumPostVo.getUserId(), forumPostVo.getAreaCode());
        } catch (Exception e) {
            logger.debug("新增帖子调用服务失败：", e);
        }
    }

    private void asyncCreatePostUserTopTaskJob(ForumPostVo forumPostVo) {
        ForumService forumService = SpringContextHolder.getBean(ForumService.class);
        forumService.createPostUserTopTaskJob(forumPostVo);
    }

    @Async
    @Override
    public void createPostUserTopTaskJob(ForumPostVo forumPostVo) {
        ForumTopPost forumTopPost = new ForumTopPost();
        forumTopPost.setAddTime(forumPostVo.getCreateTime());
        forumTopPost.setAreaCode(forumPostVo.getAreaCode());
        forumTopPost.setId(forumPostVo.getId());
        forumTopPost.setDisplayTime(forumPostVo.getDisplayDateTime());
        logger.debug("[createPostUserTopTaskJob]用户发帖完毕，开始处理用户置顶帖子:{}", JSONObject.toJSONString(forumTopPost));
        KeyGenerator postUserTop = RedisConfig.FORUM_RECOMMENDED.copy().appendKey(forumPostVo.getUserId()).appendKey("top");
        Long size = redisListAdapter.size(postUserTop);
        List<ForumTopPost> result = new ArrayList<>();
        if (size == 0) {
            result.add(forumTopPost);
        } else {
            List<ForumTopPost> forumTopPostList = redisListAdapter.leftIndex(postUserTop, size - 1, ForumTopPost.class);
            forumTopPostList.add(forumTopPost);
            result = forumTopPostList.stream().sorted(Comparator.comparing(ForumTopPost::getId).reversed()).collect(Collectors.toList());
        }
        logger.debug("[createPostUserTopTaskJob]将用户帖子置顶存入redis中:{}", JSONObject.toJSONString(result));
        redisListAdapter.remove(postUserTop);
        redisListAdapter.rightPush(postUserTop, result.toArray(new ForumTopPost[0]));

        UserTopPostBuildParam param = new UserTopPostBuildParam();
        param.setPostId(forumPostVo.getId());
        param.setUserId(forumPostVo.getUserId());
        param.setAddTime(forumPostVo.getCreateTime());
        logger.debug("创建发布帖子置顶:{}", JSON.toJSONString(param));
        quartzIntegrationService.removePostUserTopTask(param);
    }

    private Long getPostId() {
        KeyGenerator postKeyGenerator = RedisConfig.SEQ_POST_ID.copy();
        return redisStringAdapter.incrementWithDefault(postKeyGenerator, 4000000000000000L, 1);
    }

    @Override
    public Boolean delete(Long id) {
        logger.debug("开始删除帖子，id：" + id);
        ForumPostVo forumPostVo = this.forumMapper.getPostDetailById(id);
        if (forumPostVo == null) {
            return false;
        }
        forumPostVo.setStatus(4);
        this.forumMapper.updateByPrimaryKeySelective(forumPostVo);
        this.forumPostMapper.deleteMixRecommandPoolById(id);

        //this.forumMapper.deletePostTag(id);

        logger.debug("开始回收金币，id：" + id);
        Integer goldNum = userAccountIntegrationService.countGoldByPostId(id, forumPostVo.getUserId());
        if (null != goldNum && goldNum > 0) {
            AccountGoldParam param = new AccountGoldParam();
            param.setUserId(forumPostVo.getUserId());
            param.setGold(-goldNum);
            param.setGoldType("USABLE_GOLD");
            param.setGoldFlowType("TASK_POST_DELETE");
            param.setAddTotal(false);
            param.setRelationId(id);
            userAccountIntegrationService.addGold(param);
        }

        newsRecommendIntegrationService.cleanUserTop(forumPostVo.getUserId(),forumPostVo.getId());

        userIntegrationService.addPostReplyNum(forumPostVo.getUserId(), 2);
        logger.debug("帖子删除完成，id：" + id);
        return true;
    }

    @Override
    public void completePostListInfo(List<ForumPostVo> forumPostList, Long userId) {
        if (!CollectionUtils.isEmpty(forumPostList)) {
            for (ForumPostVo forumPostVo : forumPostList) {
                completePostInfo(forumPostVo, userId);
            }
        }
    }

    private void generateRecord(Long userId, Long postId) {
        ForumPostRecord pRecord = this.forumPostRecordMapper.selectByIds(postId, userId, null);
        Date d = new Date();
        if (pRecord != null) {
            pRecord.setUpdateTime(d);
            this.forumPostRecordMapper.updateByPrimaryKeySelective(pRecord);
        } else {
            ForumPostRecord nr = new ForumPostRecord();
            nr.setId(nextSequence());
            nr.setPostId(postId);
            nr.setUserId(userId);
            nr.setUpdateTime(d);
            nr.setCheckTime(0);
            nr.setGetGold(AppConst.UN_GOLD);
            nr.setAddTime(d);
            nr.setLastLocation("1");
            nr.setAdViewType((byte) 1);
            this.forumPostRecordMapper.insertSelective(nr);
        }

        doConsumeClickCount(postId, userId);

    }

    private void completePostInfo(ForumPostVo forumPostVo, Long userId) {
        if (forumPostVo != null) {
            if (null != forumPostVo.getForumId()) {
                forumPostVo.setForum(forumMapper.selectForumById(forumPostVo.getForumId()));
            }
            forumPostVo.setTopicList(forumMapper.getTopicListByPostId(forumPostVo.getId()));

            if (null != userId) {
                Integer like = this.forumMapper.getUserPostLike(forumPostVo.getId(), userId);
                if (null != like && 1 == like) {
                    forumPostVo.setLiked(1);
                } else {
                    forumPostVo.setLiked(0);
                }

                Integer count = this.forumMapper.countUserPostCollect(forumPostVo.getId(), userId);
                if (null != count && count > 0) {
                    forumPostVo.setCollected(1);
                } else {
                    forumPostVo.setCollected(0);
                }
            }

            if (StringUtils.isBlank(forumPostVo.getLocation()) && StringUtils.isNotBlank(forumPostVo.getAreaCode())) {
                LocationDTO location = locationIntegrationService.getLocationByGeocode(forumPostVo.getAreaCode());
                if (null != location) {
                    forumPostVo.setLocation(location.getName());
                }
            }

            if (StringUtils.isNotBlank(forumPostVo.getTextField())) {
                forumPostVo.setTextField(StringEscapeUtils.unescapeHtml(forumPostVo.getTextField()));
            }

            if (StringUtils.isNotBlank(forumPostVo.getContent())) {
                forumPostVo.setContent(StringEscapeUtils.unescapeHtml(forumPostVo.getContent()));
            }

            if (StringUtils.isNotBlank(forumPostVo.getImgList())) {
                forumPostVo.setPostImgList(JSON.parseArray(forumPostVo.getImgList(), PostImgVo.class));
            }

            if (null != forumPostVo.getDisplayDateTime()) {
                forumPostVo.setDisplayTime(changeTime(forumPostVo.getDisplayDateTime()));
            }

            forumPostVo.setShareUrl(bizConfigProperties.getH5ServerHost() + "/shareInvitationDetail.html?userId="
                    + userId + "&id=" + forumPostVo.getId());
        }
    }

    @Override
    public NewsCompleTaskDTO doShare(Long userId, Long postId, String areaCode) {
        NewsCompleTaskDTO compleTaskDTO = new NewsCompleTaskDTO();

        bizLogIntegrationService.shareForumSuccessed(userId, postId, areaCode);
        Json<NewsCompleTaskDTO> result = newsReadRewardService.saveShareForums(postId, userId);
        if (null != result) {
            compleTaskDTO = result.getResult();
        }

        return compleTaskDTO;
    }

    @Override
    public void doLike(Long userId, Long postId, int type, String areaCode) {
        ForumPostLike forumPostLike = new ForumPostLike();
        forumPostLike.setId(nextId());
        forumPostLike.setType((byte) type);
        forumPostLike.setAddTime(new Date());
        forumPostLike.setUserId(userId);
        forumPostLike.setPostId(postId);

        int num = 1;
        if (type == 0) {
            num = -1;
        }

        //插入点赞表
        forumPostLikeMapper.insertSelective(forumPostLike);

        //更新点赞数量
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setLikeCount(num);
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);

        if (1 == type) {
            User userEntity = userIntegrationService.getUserById(userId);
            ForumPostVo forumPostVo = forumMapper.getPostDetailById(postId);
            if (null != userEntity && null != forumPostVo && !userId.equals(forumPostVo.getUserId())) {
                String title = userEntity.getNickname() + "点赞了你的帖子";
                PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.BELONG_POST_LIKE);
                Long msgId = nextId();
                info.setMsgId(msgId);
                //添加用户图标
                info.addExtend("msgId", msgId);
                info.addExtend("postId", postId);
                info.addExtend("title", title);
                info.addExtend("icon", userEntity.getHeadImg());
                info.addExtend("nickname", userEntity.getNickname());
                info.addExtend("action", "点赞了你的帖子");
                info.addExtend("type", ReplyTypeEnum.POST_REPLY.getCode());

                PushMessage message = PushMessage.build();
                message.setTitle(title);
                message.setContent(forumPostVo.getTitle());
                message.setType(TemplateTypeEnum.NOTIFCTION);
                message.setPushReceiveScope(PushReceiveScope.pushSignle(forumPostVo.getUserId()));
                message.setPayloadInfo(info);
//                messageIntegrationService.addMessage(message, forumPostVo.getUserId());
                pushMsgSupplyFeignService.pushMsg(message);
            }
            bizLogIntegrationService.forumLikeSuccessed(userId, postId, areaCode);
        }
    }

    @Override
    public Message doInform(ForumPostInformParam param) {
        ForumPostInform forumPostInformParam = new ForumPostInform();
        forumPostInformParam.setPostId(param.getPostId());
        forumPostInformParam.setUserId(param.getUserId());
        List<ForumPostInform> informList = this.forumPostInformMapper.selectByModel(forumPostInformParam);
        if (CollectionUtils.isNotEmpty(informList)) {
            return Message.build(false, "您已举报过");
        }
        ForumPostInform forumPostInform = new ForumPostInform();
        BeanUtils.copyProperties(param, forumPostInform);
        forumPostInform.setId(nextSequence());
        this.forumPostInformMapper.insertSelective(forumPostInform);
        return Message.build(true);
    }

    @Override
    public void doCollect(Long userId, Long postId) {
        ForumPostCollect forumPostCollect = forumPostCollectMapper.selectUserCollect(new ForumPostCollect(userId, postId));

        int num;
        //插入收藏表
        if (!ObjectUtils.isEmpty(forumPostCollect)) {
            this.forumPostCollectMapper.deleteByPrimaryKey(forumPostCollect.getId());
            num = -1;
        } else {
            ForumPostCollect newForumPostCollect = new ForumPostCollect();
            newForumPostCollect.setAddTime(new Date());
            newForumPostCollect.setId(nextSequence());
            newForumPostCollect.setPostId(postId);
            newForumPostCollect.setUserId(userId);
            forumPostCollectMapper.insertSelective(newForumPostCollect);
            num = 1;
        }

        //更新收藏数量
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setCollectCount(num);
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public void doConsumeRecommendedCount(List<Long> ids, Long userId) {
        List<ForumPostStatistic> forumPostStatisticList =
                ids.stream().map(id -> ForumPostStatistic.buildRecommend(id, 1)).collect(Collectors.toList());
        MybatisBatchBuilder.create(ForumPostMapper.class, forumPostStatisticList).run(ForumPostMapper::updateStatisticByPrimaryKeySelective);
    }

    @Override
    public void doConsumeClickCount(Long postId, Long userId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setClickCount(1);
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public void doConsumeActiveViewCount(Long postId, Long userId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setReviewCount(1);
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Async
    @Override
    public void triggerUpdateInfo(Long userId, String nickname, String headImg) {
       List<ForumPostVo> forumPostVoList = forumMapper.selectForumPostByUser(userId);
        for (ForumPostVo forumPostVo:forumPostVoList) {
            forumPostMapper.updateUserInfo(forumPostVo.getId(),userId,headImg,nickname);
        }
    }

    @Override
    public void calcParticipantsNum() {
        logger.info("calculate participants num start. ");

        //计算版块参与人数
        List<ForumVo> forumVoList = forumMapper.getForumList(null, 1);
        if (CollectionUtils.isNotEmpty(forumVoList)) {
            for (ForumVo forumVo : forumVoList) {
                Integer participantsNum = forumMapper.calcPostNum(forumVo.getId(), null);
                if (null == participantsNum) {
                    participantsNum = 0;
                }

                List<Long> postIdList = forumMapper.getPostIdList(forumVo.getId(), null);
                if (CollectionUtils.isNotEmpty(postIdList)) {
                    for (Long postId : postIdList) {
                        Integer replyNum = forumMapper.calcReplyNum(postId);
                        if (replyNum != null) {
                            participantsNum += replyNum;
                        }
                    }
                }
                forumMapper.updateForum(forumVo.getId(), participantsNum);
            }
        }

        //计算话题参与人数
        List<TopicVo> topicVoList = forumMapper.getTopicList(null, 1);
        if (CollectionUtils.isNotEmpty(topicVoList)) {
            for (TopicVo topicVo : topicVoList) {
                Integer participantsNum = forumMapper.calcPostNum(null, topicVo.getId());
                if (null == participantsNum) {
                    participantsNum = 0;
                }

                List<Long> postIdList = forumMapper.getPostIdList(null, topicVo.getId());
                if (CollectionUtils.isNotEmpty(postIdList)) {
                    for (Long postId : postIdList) {
                        Integer replyNum = forumMapper.calcReplyNum(postId);
                        if (replyNum != null) {
                            participantsNum += replyNum;
                        }
                    }
                }
                forumMapper.updateTopic(topicVo.getId(), participantsNum);
            }
        }

        logger.info("calculate participants num end. ");
    }

    @Override
    public List<News4Client> listPostDetailRecommend(Long postId, Long userId, Integer size, String areaCode) {
        if (null == size) {
            size = 5;
        }
        ForumParam forumParam = new ForumParam();
        forumParam.setOperationId(7);
        forumParam.setPostId(postId);
        forumParam.setUserId(userId);
        forumParam.setAreaCode(areaCode);
        if (size == 5) {
            forumParam.setPostNum(3);
            forumParam.setNewsNum(2);
        } else if (size == 15) {
            forumParam.setPostNum(10);
            forumParam.setNewsNum(5);
        }

        List<Long> idList = newsRecommendIntegrationService.recommendList(forumParam);
        logger.debug("[listPostDetailRecommend]新闻详情推荐：{}",JSONObject.toJSONString(idList));
        List<MixRecommendDTO> mixRecommendDTOList = ForumPostConvert.convertIds2MixRecommendDTO(idList);
        RecommendService recommendService = SpringContextHolder.getBean(RecommendService.class);

        return recommendService.listNews4Client(mixRecommendDTOList, userId, areaCode);
    }

    @Override
    public ReplenishmentDTO getHotPostOrNews(Long userId, String areaCode) {
        ReplenishmentDTO replenishmentDTO = new ReplenishmentDTO();
        MixedRecommendPool mixedRecommendPool = mixedRecommendPoolMapper.selectHotRecommend(areaCode);
        logger.info("[getHotPostOrNews]得到权重最高的帖子或者新闻，推荐库中权重最高:{}",JSONObject.toJSONString(mixedRecommendPool));
        if (null == mixedRecommendPool) {
            return replenishmentDTO;
        }
        replenishmentDTO.setId(mixedRecommendPool.getId());
        replenishmentDTO.setOrigin(mixedRecommendPool.getOrigin());
        replenishmentDTO.setTitle(mixedRecommendPool.getTitle());

        if ("1".equals(mixedRecommendPool.getOrigin())) {
            ForumPostVo postVo = forumMapper.getPostDetailById(mixedRecommendPool.getId());
            if (postVo != null) {
                if (StringUtils.isNotEmpty(postVo.getImgList())) {
                    List<PostImgVo> postImgList = JSON.parseArray(postVo.getImgList(), PostImgVo.class);
                    if (CollectionUtils.isNotEmpty(postImgList)) {
                        List<String> imgList = postImgList.stream().map(PostImgVo::getImgUrl).collect(Collectors.toList());
                        String[] imgStr = new String[imgList.size()];
                        replenishmentDTO.setImgList(imgList.toArray(imgStr));
                    }
                }
            }

        } else if ("2".equals(mixedRecommendPool.getOrigin()) || "3".equals(mixedRecommendPool.getOrigin())) {
            News news = newsMapper.selectByPrimaryKey(mixedRecommendPool.getId());
            if (news != null) {
                if (StringUtils.isNotEmpty(news.getImgUrl())) {
                    JSONArray imgArray = JSON.parseArray(news.getImgUrl());
                    List<String> imgList = new ArrayList<>();
                    for (Object jsonpObject : imgArray) {
                        imgList.add((String) jsonpObject);
                    }
                    String[] imgStr = new String[imgList.size()];
                    replenishmentDTO.setImgList(imgList.toArray(imgStr));
                }
            }
        }
        logger.info("[getHotPostOrNews]得到权重最高的帖子或者新闻,结果:{}",JSONObject.toJSONString(replenishmentDTO));
        return replenishmentDTO;
    }

    /**
     * 变更时间
     *
     * @param time
     * @return
     */
    private String changeTime(Date time) {
        Date today = new Date();
        String changeTime = DateUtils.formatAtWill(time, DateUtils.DATE_FORMAT);

        if (org.apache.commons.lang3.time.DateUtils.isSameDay(time, today)) {
            return "今天" + DateUtils.PATTERN_HOUR_MINUTE_FORMAT.get().format(time);
        }

        if (org.apache.commons.lang3.time.DateUtils.isSameDay(DateUtils.addField(time, Calendar.DATE, 1), today)) {
            return "昨天";
        }

        int todayYear = today.getYear() + 1900;
        if (!StringUtils.split(changeTime, "-")[0].equals(String.valueOf(todayYear))) {
            return changeTime.replaceAll("-", "/");
        }

        if (StringUtils.split(changeTime, "-")[0].equals(String.valueOf(todayYear))) {
            return StringUtils.split(changeTime, "-")[1] + "/" +
                    StringUtils.split(changeTime, "-")[2];
        }

        return null;
    }


}
