package com.bxm.localnews.news.service.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import javax.annotation.Resource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.dto.User;
import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.integration.BizLogIntegrationService;
import com.bxm.localnews.integration.MessageIntegrationService;
import com.bxm.localnews.integration.NewsStatisticIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.*;
import com.bxm.localnews.news.dto.*;
import com.bxm.localnews.news.enums.NewsConstant;
import com.bxm.localnews.news.enums.ReplyStatusEnum;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.param.NewsReplyAddParam;
import com.bxm.localnews.news.param.NewsReplyLikeParam;
import com.bxm.localnews.news.param.NewsReplyParam;
import com.bxm.localnews.news.param.UserReplyParam;
import com.bxm.localnews.news.service.NewNewsReplyService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.service.VideoRecommendService;
import com.bxm.localnews.news.vo.*;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by Administrator on 2018/2/23 0023.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class NewNewsReplyServiceImpl extends BaseService implements NewNewsReplyService {

    @Resource
    private NewsReplyMapper newsReplyMapper;

    @Resource
    private NewsReplyLikeMapper newsReplyLikeMapper;

    @Resource
    private RedisListAdapter redisListAdapter;

    @Resource
    private UserReplyMapper userReplyMapper;

    @Resource
    private VideoMapper videoMapper;

    @Resource
    private NewsMapper newsMapper;

    @Resource
    private NewsCollectMapper newsCollectMapper;

    @Resource
    private VideoLikeMapper videoLikeMapper;

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;

    @Autowired
    private VideoRecommendService videoRecommendService;

    @Autowired
    private NewsStatisticIntegrationService newsStatisticIntegrationService;

    @Autowired
    private NewsService newsService;

    @Autowired
    private NewsTotalMapper newsTotalMapper;

    @Autowired
    private ForumPostMapper forumPostMapper;

    @Autowired
    private BizLogIntegrationService bizLogIntegrationService;

    @Autowired
    private ForumMapper forumMapper;

    @Resource
    private MessageIntegrationService messageIntegrationService;

    @Override
    public PageWarper<NewsReplyDTO> queryReplyList(NewsReplyParam newsReplyParam) {
        //分页查找level为0的评论
        PageWarper<NewsReplyDTO> newsReplyDTOPageWarper = new PageWarper<>(this.newsReplyMapper.queryByPageSize(newsReplyParam));

        if (CollectionUtils.isNotEmpty(newsReplyDTOPageWarper.getList())) {
            for (NewsReplyDTO vo : newsReplyDTOPageWarper.getList()) {

                //用户是否点赞
                vo.setIsLike(checkIsLike(newsReplyParam.getUserId(), vo.getId()));

                if (vo.getDeleteFlag() == 1) {
                    vo.setReplyContent("该评论已删除！");
                }

                vo.setReplyTime(timeConvertString(vo.getAddTime()));

                List<NewsReplyMirrorDTO> replies = this.newsReplyMapper.selectSubReplyList(vo.getId(), newsReplyParam.getNewsId());
                if (CollectionUtils.isNotEmpty(replies)) {
                    replies.forEach(replay -> {

                        //用户是否点赞
                        replay.setIsLike(checkIsLike(newsReplyParam.getUserId(), replay.getId()));

                        //评论已经删除将replyContent赋值为"该评论已删除!"
                        if (replay.getDeleteFlag() == 1) {
                            replay.setReplyContent("该评论已删除！");
                        }

                        //隐藏父级回复，详细需求问强哥
                        if (replay.getLevel().equals(NewsConstant.REPLY_LEVEL_1)) {
                            replay.setParentHeadImg(null);
                            replay.setParentUserId(null);
                            replay.setParentUserNickname(null);
                        }

                        replay.setReplyTime(timeConvertString(replay.getAddTime()));

                    });
                    vo.setList(replies);
                }
            }
        }
        return newsReplyDTOPageWarper;
    }

    private int checkIsLike(Long userId, Long replyId) {
        return isLike(userId, replyId) ? 1 : 0;
    }

    /**
     * 判断当前用户是否对此回复点赞
     *
     * @param userId
     * @param replyId
     * @return
     */
    private boolean isLike(Long userId, Long replyId) {
        NewsReplayLike newsReplayLike = newsReplyLikeMapper.selectByModel(new NewsReplayLike(replyId, userId));
        return null != newsReplayLike;
    }

    @Override
    public NewsReply doReply(NewsReplyAddParam newsReplyAddParam) {
        logger.debug("[doReply]发表评论，参数:[{}]",JSONObject.toJSONString(newsReplyAddParam));
        NewsReply newsReply = new NewsReply();
        BeanUtils.copyProperties(newsReplyAddParam, newsReply);

        newsReply.setStatus(ReplyStatusEnum.IS_SHOW.getCode());
        newsReply.setLikeCount(0);
        newsReply.setRootId(0L);
        newsReply.setLevel((byte) 0);
        newsReply.setAddTime(new Date());
        newsReply.setInteractiveCount(0);
        newsReply.setId(nextSequence());

        //得到用户的头像昵称
        if (null != newsReplyAddParam.getUserId()) {
            UserBean userBean = userIntegrationService.selectUserFromCache(newsReplyAddParam.getUserId());
            newsReply.setHeadImg(userBean.getHeadImg());
            newsReply.setUserNickname(userBean.getNickname());
        }

        //如果不传type默认是新闻类型
        if (newsReplyAddParam.getType() == null) {
            newsReply.setType(ReplyTypeEnum.NEWS_REPLY.getCode());
        }

        //判断id来自于新闻、小视频、还是帖子，真是操了
        String idStr = newsReplyAddParam.getNewsId().toString();
        if (idStr.startsWith("4") && idStr.length() == 16) {
            newsReply.setType(ReplyTypeEnum.POST_REPLY.getCode());
        } else if (videoMapper.exists(newsReplyAddParam.getNewsId()) > 0) {
            newsReply.setType(ReplyTypeEnum.VIDEO_REPLY.getCode());
        } else {
            newsReply.setType(ReplyTypeEnum.NEWS_REPLY.getCode());
        }

        //如果是对新闻的直接评论则设置父评论信息为null
        if (newsReply.getParentId() == null || newsReply.getParentId() == 0) {
            newsReply.setRootId(0L);
            newsReply.setParentId(0L);
            newsReply.setLevel(NewsConstant.REPLY_LEVEL_0);
        } else {
            NewsReply newsReplyDb = newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getParentId(), newsReplyAddParam.getNewsId());
            if (newsReplyDb != null) {
                newsReply.setRootId(newsReplyDb.getRootId());
                Byte level = newsReplyDb.getLevel();
                if (level == 0) {
                    newsReply.setLevel(NewsConstant.REPLY_LEVEL_1);
                    newsReply.setRootId(newsReplyDb.getId());
                } else {
                    newsReply.setLevel(NewsConstant.REPLY_LEVEL_2);
                    newsReply.setRootId(newsReplyDb.getRootId());
                }
            }
        }

        this.newsReplyMapper.insertSelective(newsReply);
        //保存至用户评论中
        UserReply userReply = new UserReply();
        BeanUtils.copyProperties(newsReply, userReply);
        this.userReplyMapper.insertSelective(userReply);

        //兼容评论时间
        newsReply.setReplyTime(timeConvertString(newsReply.getAddTime()));

        //异步执行
        NewsReply param = new NewsReply();
        BeanUtils.copyProperties(newsReply, param);
        NewNewsReplyService newNewsReplyService = SpringContextHolder.getBean(this.getClass());
        newNewsReplyService.processWhenReply(param, newsReplyAddParam);

        if (newsReply.getLevel().equals(NewsConstant.REPLY_LEVEL_1)) {
            newsReply.setParentUserId(null);
            newsReply.setParentUserNickname(null);
        }
        return newsReply;

    }

    @Async
    @Override
    public void processWhenReply(NewsReply newsReply, NewsReplyAddParam newsReplyAddParam) {


        //1.新闻不是根级评论时将根级评论互动值+3
        if (Objects.nonNull(newsReply.getRootId()) && newsReply.getRootId() != 0) {
            NewsReply rootReply = newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsReply.getNewsId());
            Integer interactiveCount = rootReply.getInteractiveCount();
            interactiveCount = (Objects.isNull(interactiveCount) || interactiveCount == 0) ? 3 : interactiveCount + 3;
            rootReply.setInteractiveCount(interactiveCount);
            newsReplyMapper.updateByPrimaryKeySelective(rootReply);
            UserReply userRootReply = new UserReply();
            BeanUtils.copyProperties(rootReply, userRootReply);
            userReplyMapper.updateinteractiveCountById(userRootReply);
        }

        //2.增加评论数
        if (0 == newsReply.getRootId()) {
            if (ReplyTypeEnum.NEWS_REPLY.getCode() == newsReply.getType()) {
                newsTotalMapper.updateNewsTotalComments(newsReply.getNewsId());
                newsStatisticIntegrationService.pushCommentData(newsReplyAddParam.getUserId(), newsReplyAddParam.getNewsId());
            } else if (ReplyTypeEnum.VIDEO_REPLY.getCode() == newsReply.getType()) {
                Video video = new Video();
                video.setId(newsReply.getNewsId());
                video.setCommentCount(1L);
                videoMapper.updateStatisticByPrimaryKeySelective(video);
            } else if (ReplyTypeEnum.POST_REPLY.getCode() == newsReply.getType()) {
                ForumPostStatistic forumPostStatistic = ForumPostStatistic.buildComments(newsReplyAddParam.getNewsId(), 1);
                forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
            }

            userIntegrationService.addPostReplyNum(newsReplyAddParam.getUserId(), 3);
        }

        //3.推送消息，自己给自己评论不推送信息
        logger.info("用户[{}]评论了用户[{}]的消息，给用户[{}]发送推送,推送类型为[{}]， \n推送的数据：[{}]", newsReplyAddParam.getUserId(),
                newsReplyAddParam.getParentUserId(), newsReplyAddParam.getParentUserId(), newsReplyAddParam.getType(),
                JSON.toJSONString(newsReplyAddParam));
        if (Objects.nonNull(newsReplyAddParam.getParentUserId()) &&
                !(newsReplyAddParam.getParentUserId().equals(newsReply.getUserId()))) {
            logger.debug("封装的消息格式为：[{}]", JSON.toJSONString(newsReply));
            if (newsReply.getType() == ReplyTypeEnum.NEWS_REPLY.getCode() || newsReply.getType() == ReplyTypeEnum.VIDEO_REPLY.getCode()) {
                pushNewReplyMessage(newsReply, PushMessageEnum.NEWS_REPLY);
            } else if (newsReply.getType() == ReplyTypeEnum.POST_REPLY.getCode()) {
                pushNewReplyMessage(newsReply, PushMessageEnum.POST_REPLY);
            }
        }

        //4.回复帖子的推送
        if (null == newsReplyAddParam.getParentUserId() && newsReply.getType() == ReplyTypeEnum.POST_REPLY.getCode()) {
            User userEntity = userIntegrationService.getUserById(newsReply.getUserId());
            ForumPostVo forumPostVo = forumMapper.getPostDetailById(newsReplyAddParam.getNewsId());
            if (null != userEntity && null != forumPostVo && !newsReply.getUserId().equals(forumPostVo.getUserId())) {
                String title = userEntity.getNickname() + "回复了你的帖子";
                PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.BELONG_POST_REPLY);
                Long msgId = nextId();
                info.setMsgId(msgId);
                //添加用户图标
                info.addExtend("msgId", msgId);
                info.addExtend("postId", newsReplyAddParam.getNewsId());
                info.addExtend("title", title);
                info.addExtend("icon", userEntity.getHeadImg());
                info.addExtend("nickname", userEntity.getNickname());
                info.addExtend("action", "回复了你的帖子");
                info.addExtend("type", newsReply.getType());

                PushMessage message = PushMessage.build();
                message.setTitle(title);
                message.setContent(forumPostVo.getTitle());
                message.setType(TemplateTypeEnum.NOTIFCTION);
                message.setPushReceiveScope(PushReceiveScope.pushSignle(forumPostVo.getUserId()));
                message.setPayloadInfo(info);
//                messageIntegrationService.addMessage(message, forumPostVo.getUserId());
                pushMsgSupplyFeignService.pushMsg(message);
            }
        }

        //5.记录事件埋点
        if (StringUtils.isNotBlank(newsReplyAddParam.getAreaCode())){
            bizLogIntegrationService.replySuccessed(newsReplyAddParam.getUserId(), newsReplyAddParam.getNewsId(),
                new Integer(newsReplyAddParam.getType()), newsReplyAddParam.getAreaCode());
        }
    }


    @Override
    public void pushNewReplyMessage(NewsReply newsReply, PushMessageEnum pushMessageEnum) {
        if (newsReply.getParentId() != 0 && Objects.nonNull(newsReply.getParentUserId()) && newsReply.getParentUserId() != 0) {
            User userEntity = userIntegrationService.getUserById(newsReply.getParentUserId());
            if (Objects.nonNull(userEntity)) {
                String title = newsReply.getUserNickname() + "回复了你的评论";
                PushPayloadInfo info = PushPayloadInfo.build(pushMessageEnum);
                Long msgId = nextId();
                info.setMsgId(msgId);
                //添加用户图标
                info.addExtend("msgId", msgId);
                info.addExtend("icon", newsReply.getHeadImg());
                info.addExtend("replyId", newsReply.getId());
                info.addExtend("title", title);
                info.addExtend("newsId", newsReply.getNewsId());
                info.addExtend("type", newsReply.getType());
                info.addExtend("nickname", newsReply.getUserNickname());
                info.addExtend("action", "回复了你的评论");
                PushMessage message = PushMessage.build();
                message.setTitle(title);
                if (newsReply.getDeleteFlag() == 0) {
                    message.setContent(newsReply.getReplyContent());
                } else {
                    message.setContent("该评论已删除！");
                }
                message.setType(TemplateTypeEnum.NOTIFCTION);
                message.setPushReceiveScope(PushReceiveScope.pushSignle(newsReply.getParentUserId()));
                message.setPayloadInfo(info);
                logger.info("推送的message:{}", JSONObject.toJSONString(message));
                this.pushMsgSupplyFeignService.pushMsg(message);
            }
        }

    }

    @Override
    public void pushNewLikeMessage(NewsReplyLikeParam newsReplyLikeParam, PushMessageEnum pushMessageEnum) {
        if (newsReplyLikeParam.getUserId() != 0) {
            User userEntity = userIntegrationService.getUserById(newsReplyLikeParam.getUserId());
            if (Objects.nonNull(userEntity)) {
                User user = userEntity;
                String title = user.getNickname() + "点赞了你的评论";
                PushPayloadInfo info = PushPayloadInfo.build(pushMessageEnum);
                Long msgId = nextId();
                info.setMsgId(msgId);
                //添加用户图标
                info.addExtend("msgId", msgId);
                info.addExtend("icon", user.getHeadImg());
                info.addExtend("replyId", newsReplyLikeParam.getReplyId());
                info.addExtend("title", title);

                NewsReply newsReply;
                if (null != newsReplyLikeParam.getNewsId()) {
                    info.addExtend("newsId", newsReplyLikeParam.getNewsId());
                    newsReply = newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReplyLikeParam.getReplyId(), newsReplyLikeParam.getNewsId());
                } else {
                    newsReply = newsReplyMapper.selectByPrimaryKey(newsReplyLikeParam.getReplyId());
                }
                // 需要添加新闻类型
                info.addExtend("type", newsReply.getType());
                info.addExtend("nickname", user.getNickname());
                info.addExtend("action", "点赞了你的评论");

                PushMessage message = PushMessage.build();
                message.setTitle(title);
                if (newsReply.getDeleteFlag() == 0) {
                    message.setContent(newsReply.getReplyContent());
                } else {
                    message.setContent("该评论已删除!");
                }
                message.setType(TemplateTypeEnum.NOTIFCTION);
                message.setPushReceiveScope(PushReceiveScope.pushSignle(newsReply.getUserId()));
                message.setPayloadInfo(info);
                logger.info("推送的message:{}", JSONObject.toJSONString(message));

                this.pushMsgSupplyFeignService.pushMsg(message);
            }
        }
    }


    @Override
    public PageWarper<MyReplysVO> selectMyReplys(UserReplyParam newsReplyParam) {
        PageWarper<MyReplysVO> myReplysVOPageWarper = new PageWarper<>(this.userReplyMapper.selectMyReplys(newsReplyParam));
        List<MyReplysVO> myReplysVOList = myReplysVOPageWarper.getList();
        for (MyReplysVO myReplysVO : myReplysVOList) {

            Date addTime = myReplysVO.getAddTime();
            String replyTime = timeConvertString(addTime);
            myReplysVO.setReplyTime(replyTime);
            Byte type = myReplysVO.getType();
            if (type == ReplyTypeEnum.NEWS_REPLY.getCode()) {
                News news = newsMapper.selectByPrimaryKey(myReplysVO.getNewsId());

                if (null != news) {
                    NewsCollect newsCollect = newsCollectMapper.selectUserCollect(news.getId(), newsReplyParam.getUserId(), (byte) 1);

                    ReplyNewsDTO replyNewsDTO = getNewsDto(news, newsReplyParam.getUserId());
                    if (null != newsCollect) {
                        replyNewsDTO.setCollect(1);
                    } else {
                        replyNewsDTO.setCollect(0);
                    }
                    myReplysVO.setReplyNewsDto(replyNewsDTO);
                    myReplysVO.setTitle(news.getTitle());
                    myReplysVO.setNewsImgUrl(news.getImgUrl());
                }
            } else if (type == ReplyTypeEnum.VIDEO_REPLY.getCode()) {
                Video video = videoMapper.selectByPrimaryKey(myReplysVO.getNewsId());

                if (null != video) {
                    ReplyVideoDTO replyVideoDTO = getVideoDto(video, newsReplyParam.getUserId());
                    replyVideoDTO.setVideoImg("[\"" + video.getVideoImg() + "\"]");

                    myReplysVO.setReplyVideoDto(replyVideoDTO);
                    myReplysVO.setTitle(video.getTitle());
                    myReplysVO.setNewsImgUrl("[\"" + video.getVideoImg() + "\"]");
                }
            } else if (type == ReplyTypeEnum.POST_REPLY.getCode()) {
                ForumPostVo forumPostVo = forumMapper.getPostDetailById(myReplysVO.getNewsId());
                if (null != forumPostVo) {
                    ReplyPostDTO replyPostDTO = getForumPostReplyDto(forumPostVo);
                    myReplysVO.setReplyPostDto(replyPostDTO);
                    myReplysVO.setTitle(forumPostVo.getTitle());
                }
            }
        }
        return myReplysVOPageWarper;
    }

    @Override
    public NewsReplyDTO delMyReply(Long replyId, Long userId, Long newsId) {
        NewsReply newsReply = null;
        if (null != newsId && 0 != newsId) {
            newsReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(replyId, newsId);
        }
        if (Objects.isNull(newsReply)) {
            newsReply = this.newsReplyMapper.selectByPrimaryKey(replyId);
        }

        this.newsReplyMapper.deleteByPrimaryKey(replyId, newsReply.getNewsId());
        this.userReplyMapper.deleteByPrimaryKey(replyId, newsReply.getUserId());

        NewsReplyDTO newsReplyDTO = new NewsReplyDTO();
        BeanUtils.copyProperties(newsReply, newsReplyDTO);

        newsReplyDTO.setDeleteFlag((byte) 1);
        newsReplyDTO.setReplyTime(timeConvertString(newsReplyDTO.getAddTime()));

        newsReplyDTO.setReplyContent("该评论已删除！");

        newsReplyDTO.setIsLike(isLike(userId, replyId) ? 1 : 0);
        if (newsReply.getRootId() == 0) {
            List<NewsReplyMirrorDTO> replyMirrorDTOS = newsReplyMapper.selectSubReplyList(replyId, newsReply.getNewsId());
            long parentId = newsReply.getId();
            replyMirrorDTOS.forEach(e -> {
                if (e.getParentId().longValue() == parentId) {
                    e.setParentHeadImg(null);
                    e.setParentUserId(null);
                    e.setParentUserNickname(null);
                    if (e.getDeleteFlag() == 1) {
                        e.setReplyContent("该评论已删除！");
                    }
                }
                e.setReplyTime(timeConvertString(e.getAddTime()));
                e.setIsLike(isLike(userId, e.getId()) ? 1 : 0);

            });
            newsReplyDTO.setList(replyMirrorDTOS);
        }

        if (newsReply.getLevel() == 1) {
            newsReplyDTO.setParentUserId(null);
            newsReplyDTO.setParentUserNickname(null);
        }

        userIntegrationService.addPostReplyNum(userId, 4);

        return newsReplyDTO;
    }

    @Override
    public List<MyReceiveReplysVO> myReceiveReplys(Long userId, MPage page) {
        List<MyReceiveReplysVO> result = this.newsReplyMapper.myReceiveReplys(userId, page);

        if (!CollectionUtils.isEmpty(result)) {
            result.forEach(reply -> {
                if (reply.getDeleteFlag() == 1) {
                    reply.setReplyContent(null);
                }
            });
        }

        return result;
    }

    @Async
    @Override
    public void triggerUpdateInfo(Long userId, String nickname, String headImg) {
        //更新自己的评论
         List<NewsReply>  newsReplyList = newsReplyMapper.selectByUser(userId);
        for (NewsReply newsReply : newsReplyList) {
            NewsReply newsReplyUp = new NewsReply();
            newsReplyUp.setId(newsReply.getId());
            newsReplyUp.setUserId(userId);
            newsReplyUp.setNewsId(newsReply.getNewsId());
            newsReplyUp.setUserNickname(nickname);
            newsReplyUp.setHeadImg(headImg);

            UserReply userReply = new UserReply();
            BeanUtils.copyProperties(newsReplyUp,userReply);

            newsReplyMapper.updateUserInfo(newsReplyUp);
            userReplyMapper.updateUserInfo(userReply);
        }
        //更新父级的评论
        List<NewsReply>  parentNewsReplyList = newsReplyMapper.selectByParentUser(userId);
        for (NewsReply newsReply : parentNewsReplyList) {
            NewsReply newsReplyUp = new NewsReply();
            newsReplyUp.setId(newsReply.getId());
            newsReplyUp.setUserId(userId);
            newsReplyUp.setNewsId(newsReply.getNewsId());
            newsReplyUp.setParentUserNickname(nickname);
            newsReplyUp.setParentHeadImg(headImg);

            UserReply userReply = new UserReply();
            BeanUtils.copyProperties(newsReplyUp,userReply);

            newsReplyMapper.updateParentUserInfo(newsReplyUp);
            userReplyMapper.updateParentUserInfo(userReply);
        }

    }

    @Override
    public Message doProduceNewsReplyLike(NewsReplyLikeParam newsReplyLikeParam) {
        if (!checkLikeParam(newsReplyLikeParam)) {
            return Message.build(false, "参数验证错误");
        }
        logger.info("点赞的参数是:{}", JSONObject.toJSONString(newsReplyLikeParam));
        KeyGenerator keyGenerator = RedisConfig.NEWS_QUEUE.copy().setKey("newsReplyLikeQueue");

        redisListAdapter.leftPush(keyGenerator, newsReplyLikeParam);
        this.callAsyncConsume();
        return Message.build(true);
    }

    private void callAsyncConsume() {
        NewNewsReplyService newsReplyService = SpringContextHolder.getBean(NewNewsReplyService.class);
        newsReplyService.doNewsReplyLikeConsume();
    }

    @Async
    @Override
    public void doNewsReplyLikeConsume() {
        KeyGenerator keyGenerator = RedisConfig.NEWS_QUEUE.copy().setKey("newsReplyLikeQueue");

        NewsReplyLikeParam newsReplyLikeWarper = redisListAdapter.rightPop(keyGenerator, NewsReplyLikeParam.class);
        if (null != newsReplyLikeWarper) {
            logger.info("新闻回复点赞开始消费...");
            int type = newsReplyLikeWarper.getType();
            NewsReply newsReply;
            if (null != newsReplyLikeWarper.getNewsId() && 0 != newsReplyLikeWarper.getNewsId()) {
                newsReply = newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReplyLikeWarper.getReplyId(), newsReplyLikeWarper.getNewsId());
            } else {
                newsReply = newsReplyMapper.selectByPrimaryKey(newsReplyLikeWarper.getReplyId());
            }
            if (newsReply != null) {
                int count = saveReplyLiKeRecord(newsReply.getId(), newsReplyLikeWarper.getUserId(), type);
                if (count > 0) {
                    //1.增加评论点赞记录
                    logger.debug("评论实体:{}", JSONObject.toJSON(newsReply));
                    int likeCount = generatorLikeCount(type, newsReply.getLikeCount());
                    logger.debug("点赞数:{}", likeCount);
                    NewsReply newsReplyUp = new NewsReply();
                    newsReplyUp.setId(newsReplyLikeWarper.getReplyId());
                    newsReplyUp.setLikeCount(likeCount);
                    newsReplyUp.setUserId(newsReply.getUserId());
                    newsReplyUp.setNewsId(newsReply.getNewsId());
                    //根评论才计算互动值
                    if (newsReply.getRootId() == 0) {
                        if (type == 1) {
                            newsReplyUp.setInteractiveCount(newsReply.getInteractiveCount() + 1);
                        } else {
                            if (newsReply.getInteractiveCount() > 0) {
                                newsReplyUp.setInteractiveCount(newsReply.getInteractiveCount() - 1);
                            }
                        }
                    }
                    newsReplyMapper.updateByPrimaryKeySelective(newsReplyUp);
                    UserReply userReply = new UserReply();
                    BeanUtils.copyProperties(newsReplyUp, userReply);
                    userReplyMapper.updateinteractiveCountById(userReply);
                }

                //2.评论点赞推送
                if ((!newsReplyLikeWarper.getUserId().equals(newsReply.getUserId())) && newsReplyLikeWarper.getType() == 1) {
                    if (newsReply.getType() == 1 || newsReply.getType() == 2) {
                        pushNewLikeMessage(newsReplyLikeWarper, PushMessageEnum.NEWS_LIKE);
                    } else if (newsReply.getType() == 3) {
                        pushNewLikeMessage(newsReplyLikeWarper, PushMessageEnum.POST_LIKE);
                    }
                }
            }
            doNewsReplyLikeConsume();
        }
    }

    @Override
    public NewsReplyDetailDTO getNewsReplyDetailDTO(Long replyId, Long userId, Long newsId) {
        NewsReply newsReply;
        if (null != newsId && 0 != newsId) {
            newsReply = newsReplyMapper.selectByPrimaryKeyAndNewsId(replyId, newsId);
        } else {
            newsReply = newsReplyMapper.selectByPrimaryKey(replyId);
        }
        if (null == newsReply) {
            return null;
        }

        if (newsReply.getRootId() == null) {
            return null;
        }

        if (newsReply.getRootId() != 0) {
            if (null != newsId) {
                newsReply = newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsId);
            } else {
                newsReply = newsReplyMapper.selectByPrimaryKey(newsReply.getRootId());
            }
        }
        NewsReplyDetailDTO newsReplyDetailDTO = new NewsReplyDetailDTO();
        BeanUtils.copyProperties(newsReply, newsReplyDetailDTO);
        if (isLike(userId, newsReplyDetailDTO.getId())) {
            newsReplyDetailDTO.setIsLike(1);
        }

        if (newsReplyDetailDTO.getDeleteFlag() == 1) {
            newsReplyDetailDTO.setReplyContent("该评论已删除!");
        }
        newsReplyDetailDTO.setReplyTime(timeConvertString(newsReplyDetailDTO.getAddTime()));

        Byte type = newsReply.getType();

        if (type == ReplyTypeEnum.NEWS_REPLY.getCode()) {
            News news = newsMapper.selectByPrimaryKey(newsReply.getNewsId());
            if (null != news) {
                ReplyNewsDTO replyNewsDTO = getNewsDto(news, userId);
                newsReplyDetailDTO.setReplyNewsDto(replyNewsDTO);
                newsReplyDetailDTO.setTitle(news.getTitle());
            }
        } else if (type == ReplyTypeEnum.VIDEO_REPLY.getCode()) {
            Video video = videoMapper.selectByPrimaryKey(newsReply.getNewsId());
            if (null != video) {
                ReplyVideoDTO replyVideoDTO = getVideoDto(video, userId);
                newsReplyDetailDTO.setReplyVideoDto(replyVideoDTO);
                newsReplyDetailDTO.setTitle(video.getTitle());
            }
        } else if (type == ReplyTypeEnum.POST_REPLY.getCode()) {
            ForumPostVo forumPostVo = forumMapper.getPostDetailById(newsReply.getNewsId());
            if (null != forumPostVo) {
                ReplyPostDTO replyPostDTO = getForumPostReplyDto(forumPostVo);
                newsReplyDetailDTO.setReplyPostDto(replyPostDTO);
                newsReplyDetailDTO.setTitle(forumPostVo.getTitle());
            }
        }

        //查询该评论下的回复
        List<NewsReplyMirrorDTO> replies = this.newsReplyMapper.
                selectSubReplyList(newsReply.getId(), newsReply.getNewsId());
        if (CollectionUtils.isNotEmpty(replies)) {
            replies.forEach(replay -> {

                replay.setReplyTime(timeConvertString(replay.getAddTime()));

                if (isLike(userId, replay.getId())) {
                    replay.setIsLike(1);
                }
                //评论删除时,将评论内容置为 该评论已删除!
                if (replay.getDeleteFlag() == 1) {
                    replay.setReplyContent("该评论已删除!");
                }
                //如果直接回复新闻下的一级评论，隐藏父级回复，详细需求问强哥
                if (replay.getLevel() == 1) {
                    replay.setParentHeadImg(null);
                    replay.setParentUserId(null);
                    replay.setParentUserNickname(null);
                }
            });
        }
        newsReplyDetailDTO.setList(replies);

        return newsReplyDetailDTO;
    }

    private ReplyPostDTO getForumPostReplyDto(ForumPostVo forumPostVo) {
        ReplyPostDTO replyPostDTO = new ReplyPostDTO();
        replyPostDTO.setId(forumPostVo.getId());
        replyPostDTO.setStatus((byte) forumPostVo.getStatus().intValue());
        replyPostDTO.setTitle(forumPostVo.getTitle());
        if (StringUtils.isNotBlank(forumPostVo.getImgList())) {
            replyPostDTO.setPostImgList(JSON.parseArray(forumPostVo.getImgList(), PostImgVo.class));
        }
        return replyPostDTO;
    }

    private ReplyNewsDTO getNewsDto(News news, Long userId) {
        ReplyNewsDTO replyNewsDTO = new ReplyNewsDTO();
        replyNewsDTO.setId(news.getId());
        replyNewsDTO.setImgUrl(news.getImgUrl());
        replyNewsDTO.setLinkUrl(newsService.buildNewsDetailUrl(news.getId(), userId));
        replyNewsDTO.setShareUrl(newsService.buildNewsShareUrl(news.getId(), userId));
        replyNewsDTO.setComments(news.getComments());
        replyNewsDTO.setStatus(news.getStatus());
        return replyNewsDTO;
    }

    private ReplyVideoDTO getVideoDto(Video video, Long userId) {
        ReplyVideoDTO replyVideoDTO = new ReplyVideoDTO();
        replyVideoDTO.setAuthorImg(video.getAuthorImg());
        replyVideoDTO.setAuthor(video.getAuthorName());
        replyVideoDTO.setId(video.getId());

        VideoLike videoLike = videoLikeMapper.selectByModel(new VideoLike(video.getId(), userId));
        if (null != videoLike) {
            replyVideoDTO.setPraise(true);
        } else {
            replyVideoDTO.setPraise(false);
        }

        replyVideoDTO.setLikeCount(Math.toIntExact(video.getLikeCount()));
        replyVideoDTO.setVideoUrl(videoRecommendService.videoAdressConversion(video.getVideoUrl()));
        replyVideoDTO.setVideoImg(video.getVideoImg());
        replyVideoDTO.setCommentCount(Math.toIntExact(video.getCommentCount()));
        replyVideoDTO.setStatus(video.getStatus());
        return replyVideoDTO;
    }

    /**
     * 得到更新之后的点赞数
     *
     * @param type
     * @param likeCount
     * @return
     */
    private int generatorLikeCount(int type, int likeCount) {
        if (0 == type) {
            if (likeCount > 0) {
                likeCount -= 1;
            }
        } else {
            likeCount += 1;
        }
        return likeCount;
    }

    private int saveReplyLiKeRecord(Long replyId, Long userId, int type) {
        int count = 0;
        NewsReplayLike newsReplayLike = newsReplyLikeMapper.selectByModel(new NewsReplayLike(replyId, userId));
        if (type == 1) {
            if (null == newsReplayLike) {
                NewsReplayLike newsReplayLikeNew = new NewsReplayLike();
                newsReplayLikeNew.setAddTime(new Date());
                newsReplayLikeNew.setId(nextSequence());
                newsReplayLikeNew.setReplyId(replyId);
                newsReplayLikeNew.setUserId(userId);
                count = newsReplyLikeMapper.insert(newsReplayLikeNew);
            }
        } else {
            if (null != newsReplayLike) {
                count = newsReplyLikeMapper.deleteByPrimaryKey(newsReplayLike.getId());
            }
        }
        return count;
    }


    /**
     * 评论点赞时验证参数
     *
     * @param newsReplyLikeParam
     * @return
     */
    private boolean checkLikeParam(NewsReplyLikeParam newsReplyLikeParam) {
        return null != newsReplyLikeParam.getReplyId() && null != newsReplyLikeParam.getUserId();
    }


    @Override
    public String timeConvertString(Date date) {
        if (Objects.isNull(date)) {
            date = new Date();
        }
        Calendar addtime = Calendar.getInstance();
        addtime.setTime(date);
        String result;
        Calendar instance = Calendar.getInstance();
        if (addtime.get(Calendar.YEAR) == instance.get(Calendar.YEAR)) {
            int curentDay = instance.get(Calendar.DAY_OF_YEAR);
            int addDay = addtime.get(Calendar.DAY_OF_YEAR);
            if (curentDay == addDay) {
                result = "今天 " + DateFormatUtils.format(date, "HH:mm");
            } else if ((curentDay - addDay) == 1) {
                result = "昨天";
            } else {
                result = DateFormatUtils.format(date, "MM/dd");
            }
        } else {
            result = DateFormatUtils.format(date, "yyyy/MM/dd");
        }
        return result;

    }


}
