package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.domain.NewsInformMapper;
import com.bxm.localnews.news.service.NewsInformService;
import com.bxm.localnews.news.vo.NewsInform;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by Administrator on 2018/2/23 0023.
 */
@Service
public class NewsInformServiceImpl implements NewsInformService {

    @Resource
    private NewsInformMapper newsInformMapper;

    @Override
    public Json informNews(NewsInform newsInform) {
        NewsInform newsInformParam = new NewsInform();
        newsInformParam.setNewsId(newsInform.getNewsId());
        newsInformParam.setUserId(newsInform.getUserId());
        List<NewsInform> informList = this.newsInformMapper.selectByModel(newsInformParam);
        if (CollectionUtils.isNotEmpty(informList)) {
            return ResultUtil.genFailedResult("您已举报过");
        }
        this.newsInformMapper.insertSelective(newsInform);
        return ResultUtil.genSuccessResult();
    }

}
