package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.domain.*;
import com.bxm.localnews.news.dto.OldNewsReplyDto;
import com.bxm.localnews.news.service.NewsReplyService;
import com.bxm.localnews.news.vo.*;
import com.bxm.newidea.component.service.BaseService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2018/2/23 0023.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class NewsReplyServiceImpl extends BaseService implements NewsReplyService  {

    @Resource
    private OldNewsReplyMapper oldNewsReplyMapper;

    @Autowired
    private UserReplyMapper userReplyMapper;

    @Autowired
    private NewsReplyMapper newsReplyMapper;

    @Autowired
    private NewsTotalMapper newsTotalMapper;

    @Override
    public List<OldNewsReplyDto> queryReplyList(Long newsId, MPage page) {
        List<OldNewsReplyDto> list = this.oldNewsReplyMapper.queryParentList(newsId, page);
        if (CollectionUtils.isNotEmpty(list)) {
            for (OldNewsReplyDto vo : list) {
                if (vo.getDeleteFlag() == 1) {
                    vo.setReplyContent(null);
                }

                List<OldNewsReply> replies = this.oldNewsReplyMapper.selectReplyList(newsId, vo.getId());
                if (CollectionUtils.isNotEmpty(replies)) {
                    replies.forEach(replay -> {
                        if (replay.getDeleteFlag() == 1) {
                            replay.setReplyContent(null);
                        }
                    });
                    vo.setList(replies);
                }
            }
        }
        return list;
    }

    @Override
    public Json reply(OldNewsReply newsReply) {
        newsReply.setStatus((byte) 1);
        newsReply.setLikeCount(0);
        newsReply.setRootId(0L);
        newsReply.setLevel((byte) 0);
        newsReply.setAddTime(new Date());
        newsReply.setInteractiveCount(0);
        newsReply.setRootId(0L);
        newsReply.setLevel((byte)0);
        //文章评论
        newsReply.setType((byte)1);
        Long id = nextSequence();
        newsReply.setId(id);

        this.oldNewsReplyMapper.insertSelective(newsReply);
        UserReply userReply = new UserReply();
        BeanUtils.copyProperties(newsReply,userReply);
        //数据同步到t_user_reply表中
        this.userReplyMapper.insertSelective(userReply);

        newsTotalMapper.updateNewsTotalComments(newsReply.getNewsId());

        return ResultUtil.genSuccessResult();
    }

    @Override
    public List<OldMyReplysVO> selectMyReplys(Long userId, MPage page) {
        return this.oldNewsReplyMapper.selectMyReplys(userId, page);
    }

    @Override
    public Json delMyReply(Long replyId) {
        NewsReply newsReply =newsReplyMapper.selectByPrimaryKey(replyId);
        if (null != newsReply) {
            this.newsReplyMapper.deleteByPrimaryKey(replyId,newsReply.getNewsId());
            this.userReplyMapper.deleteByPrimaryKey(replyId,newsReply.getUserId());
        }
        return ResultUtil.genSuccessResult();
    }

    @Override
    public List<MyReceiveReplysVO> myReceiveReplys(Long userId, MPage page) {
//        List<MyReceiveReplysVO> result = this.oldNewsReplyMapper.myReceiveReplys(userId, page);
//
//        if (!CollectionUtils.isEmpty(result)) {
//            result.forEach(doReply -> {
//                if (doReply.getDeleteFlag() == 1) {
//                    doReply.setReplyContent(null);
//                }
//            });
//        }
//
//        return result;

        return null;
    }


}
