package com.bxm.localnews.news.service.impl;

import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.news.domain.UserTagMapper;
import com.bxm.localnews.news.service.UserTagService;
import com.bxm.localnews.news.vo.UserTag;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class UserTagServiceImpl extends BaseService implements UserTagService {

    private UserTagMapper userTagMapper;

    public UserTagServiceImpl(UserTagMapper userTagMapper) {
        this.userTagMapper = userTagMapper;
    }

    @Override
    public int doCopyTags(Long fromUid, Long toUid, Date time) {
        List<UserTag> userTags = userTagMapper.getUserTag(fromUid);
        Date current = new Date();
        new BatchHelper<UserTagMapper, UserTag>(UserTagMapper.class, userTags) {

            @Override
            protected int invoke(UserTag element) {
                element.setId(nextId());
                element.setUserId(toUid);
                element.setUpdateTime(current);
                return mapper.insert(element);
            }
        };
        return 1;
    }

}
