package com.bxm.localnews.news.strategy;

import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.constant.AppConst;
import com.bxm.localnews.news.domain.NewsRecordMapper;
import com.bxm.localnews.news.domain.NewsStatisticsMapper;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import com.bxm.localnews.news.param.ExecGoldParam;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import com.bxm.localnews.news.vo.NewsRecord;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.StringUtils;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Date;

import static com.bxm.localnews.news.constant.AppConst.NN_GOLD;
import static com.bxm.localnews.news.constant.RedisConfig.RECOMMEND_NEWS_READ;


/**
 * 文章阅读奖励策略抽象类，主要放一些公用方法与变量
 */
public abstract class AbstractGoldenStrategy extends BaseService implements GoldenStrategy {

    public boolean viewTimeFlag = true;

    public boolean advertShowFlag = true;

    public boolean tabTYpeFlag = true;

    @Resource
    public NewsRecordMapper newsRecordMapper;

    @Resource
    public UserIntegrationService userIntegrationService;

    @Resource
    public NewsStatisticsMapper newsStatisticsMapper;

    @Resource
    public RedisStringAdapter redisStringAdapter;

    @Resource
    public MissionIntegrationService missionIntegrationService;

    public Integer randomInterval;

    public String configTabType;

    public String configAdvertShow;

    public Integer configViewTime;

    @Resource
    private NewsProperties newsProperties;

    @PostConstruct
    public void init() {
        this.randomInterval = RandomUtils.getRandomTime(this.newsProperties.getAwardTimeLag());
        this.configTabType = this.newsProperties.getTabType();
        this.configAdvertShow = this.newsProperties.getShowAdvert();
        this.configViewTime = this.newsProperties.getViewTime();
    }


    @Override
    public void commonJudgment(ExecGoldCalParam execGoldParam) {
        Long newsId = execGoldParam.getNewsId();
        Long userId = execGoldParam.getUserId();
        Integer viewTime = execGoldParam.getViewTime();
        String advertShow = execGoldParam.getAdvertShow();
        String isRecommendNews = execGoldParam.getIsRecommendNews();

        NewsGoldMeta newsGoldMeta = execGoldParam.getNewsGoldMeta();

        UserBean userBean = userIntegrationService.selectUserFromCache(userId);

        this.newsStatisticsMapper.addActiveViews(newsId);
        Date today = new Date();
        //游客用户，不赠送金币
        if (isGuestUser(userBean)) {
            newsGoldMeta.setGoldType(AppConst.UN_GOLD);
        } else {
            //判断新闻阅读是否有效
            NewsRecord nRecord = this.newsRecordMapper.getByIds(newsId, userId, null);

            //存在阅读记录并且该用户对于该新闻已获得奖励
            if (nRecord != null && nRecord.getGetGold() == NN_GOLD) {
                doUpdateRecord(newsGoldMeta, viewTime, nRecord);
                //其他情况->///
            } else {
                //存在阅读记录并且该用户对于该新闻未获得奖励
                if (nRecord != null && nRecord.getActiveView() != NN_GOLD) {
                    doUpdateRecord(newsGoldMeta, viewTime, nRecord);
                    //不存在阅读记录
                } else if (nRecord == null) {
                    nRecord = generatorNewsRecord(execGoldParam);
                    this.newsRecordMapper.insertSelective(nRecord);
                }

                nRecord.setUpdateTime(today);
                nRecord.setCheckTime(viewTime);
                nRecord.setAdViewType(Byte.valueOf(advertShow));

                //查看最近新闻浏览间隔
                boolean suspendFlag = isSuspend(userId);

                //初始化包装类为【未获取金币】
                newsGoldMeta.setGoldType(AppConst.UN_GOLD);

                //转换包装类
                execGoldParam.setNewsGoldMeta(newsGoldMeta);
                execGoldParam.setnRecord(nRecord);
                execGoldParam.setSuspendFlag(suspendFlag);

                calculator(execGoldParam);
            }

        }

    }

    /**
     * 判断获取金币的间隔时间是否满足条件
     * @param userId
     * @return
     */
    protected boolean isSuspend(Long userId) {
        NewsRecord record = this.newsRecordMapper.getOneByUserId(userId, NN_GOLD);
        if (record != null) {
            Long time = record.getGetGoldTime().getTime() + record.getIntervalNum() * 1000;
            Long time2 = System.currentTimeMillis();
            return time <= time2;
        }
        return true;
    }


    /**
     * 生成阅读记录
     * @param execGoldParam
     * @return
     */
    NewsRecord generatorNewsRecord(ExecGoldParam execGoldParam) {
        Date today = new Date();
        NewsRecord nRecord = new NewsRecord();
        nRecord.setId(nextSequence());
        nRecord.setNewsId(execGoldParam.getNewsId());
        nRecord.setUserId(execGoldParam.getUserId());
        nRecord.setUpdateTime(today);
        nRecord.setCheckTime(execGoldParam.getViewTime());
        nRecord.setGetGold(AppConst.UN_GOLD);
        nRecord.setAddTime(today);
        nRecord.setLastLocation(execGoldParam.getTabType());
        nRecord.setAdViewType(Byte.valueOf(execGoldParam.getAdvertShow()));
        nRecord.setActiveView((byte) 2);
        return nRecord;
    }

    /**
     * 是否是游客用户
     * @param user
     * @return
     */
    private boolean isGuestUser(UserBean user) {
        return user == null || user.getState() == 3;
    }

    /**
     * 更新阅读记录表
     * @param newsGoldMeta
     * @param viewTime
     * @param nRecord
     */
    private void doUpdateRecord(NewsGoldMeta newsGoldMeta, Integer viewTime, NewsRecord nRecord) {
        newsGoldMeta.setGoldType(AppConst.UN_GOLD);
        nRecord.setUpdateTime(new Date());
        if (viewTime > nRecord.getCheckTime()) {
            nRecord.setCheckTime(viewTime);
        }

        this.newsRecordMapper.updateByPrimaryKeySelective(nRecord);

    }

    /**
     * 得到新闻剩余阅读数量的key
     * @param userId
     * @return
     */
    private KeyGenerator getReadNewsCacheKey(Long userId) {
        KeyGenerator key = RECOMMEND_NEWS_READ.copy();
        key.setKey(userId + DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
        return key;
    }

    /**
     * 检查是否有效阅读
     * @param configViewTime
     * @param viewTime
     * @return
     */
    boolean checkViewTimeFlag(Integer configViewTime, Integer viewTime) {
        return viewTime > configViewTime;
    }

    /**
     * 检查是否有广告位被展示出来
     * @param configAdvertShow
     * @param advertShow
     * @return
     */
    boolean checkAdvertShowFlag(String configAdvertShow, String advertShow) {
        if (AppConst.NN_ADVERT_SHOW.equals(configAdvertShow)) {
            if (!AppConst.NN_ADVERT_SHOW.equals(advertShow)) {
                return false;
            }
        }
        return true;
    }

    /**
     * 检查是否被滑到底部
     * @param configTabType
     * @param tabType
     * @return
     */
    boolean checkTabTYpeFlag(String configTabType, String tabType) {
        if (AppConst.NN_TAB_TYPE.equals(configTabType)) {
            if (!AppConst.NN_TAB_TYPE.equals(tabType)) {
                return false;
            }
        }
        return true;
    }

    /**
     * 初始化用户当天的剩余阅读奖励次数
     * @param key
     */
    protected Integer initReadNum(KeyGenerator key) {
        Integer number = this.newsProperties.getReadNumAwardCount();
        this.redisStringAdapter.set(key, number, DateUtils.getCurSeconds());
        return number;
    }

    /**
     * 判断用户是否存在阅读奖励次数
     * @param number
     * @return
     */
    protected boolean isNumberNotExsit(String number) {
        return StringUtils.isEmpty(number);
    }

    /**
     * 判断用户是否剩余阅读奖励次数
     * @param number
     * @return
     */
    protected boolean isNumberRemained(Integer number) {
        return null != number && number > 0;
    }

}
