package com.bxm.localnews.news.service;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.vo.NewsMeta;
import com.bxm.localnews.news.vo.NewsRecommendParam;
import com.bxm.localnews.news.vo.NewsTopListParam;

/**
 * 用户新闻推荐接口
 */
public interface RecommendService {

    /**
     * 给用户推荐信息 1.首先去缓存池找有无数据 2.如果有缓存则走直接获取数据 3.如果没有缓存，则去mysql通用推荐表中取得相应数据进行计算得到推荐数据，并触发线程执行录入缓存
     * 4.通用数据库中建立新表存储推荐数据，数据量保持一定5000-10000，定时任务用来更新数据的时效
     * @param param 推荐参数
     * @return 推荐结果
     */

    Json<NewsMeta> execRecommend(NewsRecommendParam param);

    /**
     * @param param
     * @return
     * @Description 方法描述：查询置顶新闻列表
     * @author Administrator 2019年1月15日 下午3:31:18
     * @CopyRight 杭州微财网络科技有限公司
     */
    Json<NewsMeta> getTopNewsList(NewsTopListParam param);
}
