package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.activity.dto.NewShareGoldDTO;
import com.bxm.localnews.activity.service.MissionService;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.*;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.integration.feign.NewsRecommendFeignService;
import com.bxm.localnews.integration.feign.NewsSearchFeignService;
import com.bxm.localnews.integration.feign.PushMsgSupplyFeignService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.news.domain.*;
import com.bxm.localnews.news.dto.ESNewsContentDTO;
import com.bxm.localnews.news.enums.NewsCollectEnum;
import com.bxm.localnews.news.enums.NewsConstant;
import com.bxm.localnews.news.enums.NewsIsHotEnum;
import com.bxm.localnews.news.enums.NewsSharEnum;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import com.bxm.localnews.news.param.ExecGoldParam;
import com.bxm.localnews.news.param.NewsParam;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.strategy.GoldenStrategyContext;
import com.bxm.localnews.news.vo.*;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.vo.Advert;
import com.bxm.localnews.user.service.PayFlowService;
import com.bxm.localnews.user.service.UserAmountService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.PayFlow;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static com.bxm.localnews.common.constant.AppConst.*;
import static com.bxm.localnews.common.constant.RedisConfig.TASK_SHARE_NEWS_NUM;
import static com.bxm.localnews.common.constant.RedisConfig.USER_SHARE_NEWS_RECORD;
import static com.bxm.localnews.common.constant.TaskEnum.TASK_NEWS_SHARE;

/**
 * Created by hsq 10:33 2018/2/8
 */
@Service("newsService")
public class NewsServiceImpl implements NewsService {

    private final static Logger logger = LoggerFactory.getLogger(NewsServiceImpl.class);

    @Resource
    private NewsMapper newsMapper;

    @Resource
    private NewsRecordMapper newsRecordMapper;

    @Resource
    private UserService userService;

    @Resource
    private PayFlowService payFlowService;

    @Resource
    private NewsStatisticsMapper newsStatisticsMapper;

    @Resource
    private NewsCollectMapper newsCollectMapper;

    @Resource
    private NewsRecommendedMapper newsRecommendedMapper;

    @Resource
    private AdvertService advertService;

    @Resource
    private NewsShareMapper newsShareMapper;

    @Resource
    private NewsSearchWordMapper newsSearchWordMapper;

    @Resource
    private NewsKindMapper newsKindMapper;

    @Resource
    private NewsProperties newsProperties;

    @Resource
    private UserSearchRecordMapper userSearchRecordMapper;

    @Resource
    private NewsTagMapper newsTagMapper;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Resource
    private MissionService missionService;

    @Resource
    private GoldenStrategyContext goldenStrategyContext;

    @Resource
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;

    @Resource
    private AppVersionSupplyService appVersionSupplyService;

    @Resource
    private UserAmountService userAmountService;

    @Resource
    private NewsRecommendFeignService newsRecommendFeignService;

    @Resource
    private NewsSearchFeignService newsSearchFeignService;


    @Override
    public Json<NewsUrlVo> getUrl(Long newsId, Long userId, Byte type) {
        //判断是否是新闻
        if (isNews(type, newsId)) {
            News news = this.newsMapper.selectByPrimaryKey(newsId);
            if (null != news) {
                String url = getNewsUrlBegin(type, news.getType()) + "newsId=" + newsId + "&userId=" + userId + "&type=" + type;
                NewsUrlVo newsUrlVo = new NewsUrlVo(url);
                return ResultUtil.genSuccessResult(newsUrlVo);
            }
        }

        //判断是否是广告
        if (isAdvert(type)) {
            Advert advert = this.advertService.selectByPrimaryKey(newsId);
            String url = getAdvertBegin(advert) + "userId=" + userId + "&type=" + type;
            NewsUrlVo newsUrlVo = new NewsUrlVo(url);
            return ResultUtil.genSuccessResult(newsUrlVo);
        }
        logger.error("获得详情地址时新闻不存在-newsId:{},userId:{},type:{}", newsId, userId, type);
        return ResultUtil.genFailedResult(ErrorCode.PARAM_ERR, "获得详情地址时新闻不存在");
    }

    private boolean isEssayShare(Byte type, Byte newsType) {
        return type == 2 && newsType == AppConst.NEWS.ESSAY;
    }

    private boolean isIconEssayShare(Byte type, Byte newsType) {
        return type == 2 && newsType == AppConst.NEWS.ICON_ESSAY;
    }

    private boolean isVideoShare(Byte type, Byte newsType) {
        return type == 2 && newsType == AppConst.NEWS.VIDEO;
    }

    private boolean isEssayDetail(Byte type) {
        return type == 1 || type == 3;
    }

    private boolean isNews(Byte type, Long newsId) {
        return type != 4;
    }

    private boolean isAdvert(Byte type) {
        return type == 4;
    }

    /**
     * 组装新闻url
     * @param type
     * @param newsType
     * @return
     */
    private String getNewsUrlBegin(byte type, byte newsType) {
        String url = "";
        if (isEssayShare(type, newsType)) {
            url = "shareNewsDetail.html?";
        }
        if (isIconEssayShare(type, newsType)) {
            url = "sharePicDetail.html?";
        }
        if (isVideoShare(type, newsType)) {
            url = "shareVideoDetail.html?";
        }
        if (isEssayDetail(type)) {
            url = "newsDetail.html?";
        }
        return url;
    }

    /**
     * 组装广告url
     * @param advert
     * @return
     */
    private String getAdvertBegin(Advert advert) {
        String url = "";
        if (advert != null) {
            if (advert.getAddress().contains("?")) {
                url = advert.getAddress() + "&";
            } else {
                url = advert.getAddress() + "?";
            }
        }
        return url;
    }

    /**
     * 是否处于提包状态
     * @param basicParam
     * @return
     */
    private Boolean getPublishState(BasicParam basicParam) {
        return appVersionSupplyService.getPublishState(basicParam);
    }

    @Override
    public Json<NewsDetailVO> execGetSyDetail(NewsParam newsParam) {
        NewsVO news = this.newsMapper.getById(newsParam.getNewsId(), newsParam.getUserId());
        logger.info("新闻详情es开始拉取 ");
        ResponseEntity<List<ESNewsContentDTO>> responseEntity = newsSearchFeignService.multipleGet(new Long[]{news.getId()});

        if (responseEntity == null || responseEntity.getStatusCode().isError() || responseEntity.getBody().isEmpty()) {
            logger.info("新闻详情es拉取失败:{}", responseEntity.getBody());
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "获取详情时新闻缺失");
        }
        logger.info("新闻详情es拉取完毕, isError:{},content :{}", responseEntity.getStatusCode().isError(), responseEntity.getBody().get(0).getContent());
        news.setContent(responseEntity.getBody().get(0).getContent());
        if (null != news) {
            // TODO[沈涛] 有空用redis分布式锁处理
            NewsDetailVO newsDetailVO = new NewsDetailVO(news);
            try {
                //分享出去的文章记录点击次数,点击数加1
                if (newsParam.getType() == 2) {
                    this.newsStatisticsMapper.searchRecommended(newsParam.getNewsId());
                }
                if (newsParam.getUserId() != null && newsParam.getType() != 2) {
                    NewsRecord record = this.newsRecordMapper.getByIds(newsParam.getNewsId(), newsParam.getUserId(), null);
                    Date d = new Date();
                    if (record == null) {
                        record = new NewsRecord();
                        record.setNewsId(newsParam.getNewsId());
                        record.setAddTime(d);
                        record.setUpdateTime(d);
                        record.setUserId(newsParam.getUserId());
                        this.newsRecordMapper.insertSelective(record);
                    } else {
                        record.setUpdateTime(d);
                        this.newsRecordMapper.updateByPrimaryKeySelective(record);
                    }
                }
                if (getPublishState(newsParam)) {
                    newsDetailVO.getNews().setAuthor(StringUtils.EMPTY);
                    newsDetailVO.getNews().setAuthorImg(StringUtils.EMPTY);
                }
                return ResultUtil.genSuccessResult(newsDetailVO);
            } catch (Exception e) {
                logger.info("新闻阅读记录记录失败:{}", e);
                return ResultUtil.genSuccessResult(newsDetailVO);
            }
        }
        logger.error("获取详情时新闻不存在-newsId:{},userId:{},type:{}", newsParam.getNewsId(), newsParam.getUserId(), newsParam.getType());
        return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "获取详情时新闻不存在");
    }

    @Override
    public Json<NewsGoldMeta> execGetGold(ExecGoldParam execGoldParam) {
//        Json<NewsGoldMeta> result = ResultUtil.genFailedResult(ErrorCode.PARAM_ERR, "参数错误");
//        if (!checkReadGoldParam(execGoldParam)) {
//            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "参数错误");
//        }

        //首先判断有无此新闻
        if (null != execGoldParam.getUserId() && null != execGoldParam.getNewsId()) {
            News news = this.newsMapper.selectByPrimaryKey(execGoldParam.getNewsId());
            if (isNewsExsit(news, execGoldParam.getViewTime())) {

                //填充一些额外参数
                NewsGoldMeta newsGoldMeta = new NewsGoldMeta();
                ExecGoldCalParam execGoldCalParam = new ExecGoldCalParam();
                BeanUtils.copyProperties(execGoldParam, execGoldCalParam);
                execGoldCalParam.setNewsGoldMeta(newsGoldMeta);
                execGoldCalParam.setNews(news);

                //默认策略
                goldenStrategyContext.chooseCalulator(execGoldCalParam);

                return ResultUtil.genSuccessResult(execGoldCalParam.getNewsGoldMeta());
            }
        }
        //否则返回默认的，防止出现参数错误
        NewsGoldMeta newsGoldMeta = new NewsGoldMeta();
        newsGoldMeta.setGoldNum(0);
        newsGoldMeta.setTaskName(TaskEnum.TASK_NEWS_READ.getDesc());
        newsGoldMeta.setGoldType(UN_GOLD);
        newsGoldMeta.setTotalGold(BigDecimal.ZERO);
        return ResultUtil.genSuccessResult(newsGoldMeta);
    }

    private boolean checkReadGoldParam(ExecGoldParam execGoldParam) {
        if (null == execGoldParam.getNewsId() ||
                null == execGoldParam.getUserId()) {
            return false;
        }
        return true;
    }

    private boolean isNewsExsit(News news, Integer viewTime) {
        return news != null && viewTime != null;
    }

    @Override
    public Json getBack(Long newsId, Long userId, Integer viewTime, String tabType, String advertShow) {
        NewsRecord nRecord = this.newsRecordMapper.getByIds(newsId, userId, null);
        Date d = new Date();
        if (nRecord != null) {
            nRecord.setUpdateTime(d);
            //阅读时间大于上次阅读时间则更新
            if (viewTime > nRecord.getCheckTime()) {
                nRecord.setCheckTime(viewTime);
            }
            this.newsRecordMapper.updateByPrimaryKeySelective(nRecord);
        } else {
            NewsRecord nr = new NewsRecord();
            nr.setNewsId(newsId);
            nr.setUserId(userId);
            nr.setUpdateTime(d);
            nr.setCheckTime(viewTime);
            nr.setGetGold(AppConst.UN_GOLD);
            nr.setAddTime(d);
            nr.setLastLocation(tabType);
            nr.setAdViewType(Byte.valueOf(advertShow));
            this.newsRecordMapper.insertSelective(nr);
        }
        return ResultUtil.genSuccessResult();
    }

    @Override
    public Json<List<News4Client>> queryRecommendNews(Long newsId, Long userId) {
     /*   //调用存储过程，以及制定的篇数获取详情页推荐的文章
        List<News> list = this.newsMapper.queryRecommendNewsList(newsId, AppConst.NEWS_DETAIL_RECOMMEND_NUM, userId);
        List<News4Client> news4ClientList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            news4ClientList = list.stream().map(news -> new News4Client(news, null)).collect(Collectors.toList());
            //广告插入条数和位置
            int adSize = getAdvertSizeFromRecommendNews(list);
            if (adSize > 0) {
                List<AdvertDTO> adList = this.advertService.getListAds(adSize);
                if (!CollectionUtils.isEmpty(adList)) {
                    for (int i = 0; i < adList.size(); i++) {
                        AdvertDTO dto = adList.get(i);
                    }
                }
            }
        }
        //推荐的文章，放入去重表，不会再次推荐
        if (null != userId) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
                this.newsRecommendedMapper.batchInsert(userId, (byte) 4, list);
            }
        }
        News news = this.newsMapper.selectByPrimaryKey(newsId);
        //文章和组图默认第一条是广告（详情页文章最下面的广告）
        if (news != null && news.getType() != NewsTypeEnum.NEWS_VIDEO.getCode()) {
            List<AdvertDTO> adList = this.advertService.getListAds(1);
            if (adList != null && adList.size() > 0) {
                AdvertDTO dto = adList.get(0);
            }
        }
        */
        ResponseEntity<List<Long>> responseEntity = newsRecommendFeignService.recommendByNewsDetail(newsId, userId);
        List<Long> ids = responseEntity.getBody();
        List<News> list = new ArrayList<>();
        if (null != ids && !ids.isEmpty()) {
            list = newsMapper.findNewsByIds(ids);
        }

        List<News4Client> news4ClientList = list.stream().map(news -> new News4Client(news, null)).collect(Collectors.toList());
        return ResultUtil.genSuccessResult(news4ClientList);
    }

    /**
     * 广告插入条数和位置
     */
    private int getAdvertSizeFromRecommendNews(List<News> list) {
        int adSize = 0;
        int size = list.size();
        if (size > 3) {
            adSize = 3;
        } else if (size == 1) {
            adSize = 1;
        } else if (size >= 2) {
            adSize = 2;
        }
        return adSize;
    }

    @Override
    public Json<List<News4Client>> queryRecommendNews4ImgNews(Long newsId) {
        //组图末尾推荐的组图（包含广告）
        List<News> list = this.newsMapper.queryRecommendNewsList(newsId, 8, null);
        List<News4Client> news4ClientList = new ArrayList<>();
        for (News aList : list) {
            news4ClientList.add(new News4Client(aList, null));
        }
        return ResultUtil.genSuccessResult(news4ClientList);
    }

    @Override
    public Json<NewShareGoldDTO> saveShareNews(Long newsId, Long userId) {
        if (newsId == null || userId == null) {
            return ResultUtil.genFailedResult(ErrorCode.PARAM_ERR, "参数错误");
        }
        User user = this.userService.selectByPrimaryKey(userId);
        //用户未正式注册前不能分享新闻获得金币
        if (user == null || user.getState() != AppConst.USER_STATE.NORMAL) {
            return ResultUtil.genSuccessResult(new NewShareGoldDTO());
        }

        NewShareGoldDTO shareGoldDTO = null;
        KeyGenerator shareRecordKey = USER_SHARE_NEWS_RECORD.copy()
                .appendKey(userId.toString())
                .appendKey(DateUtils.formatDate(new Date()))
                .appendKey(newsId.toString());
        if (!redisStringAdapter.hasKey(shareRecordKey)) {
            //发放分享文章奖励
            Long reward = missionService.completeTask(userId, TASK_NEWS_SHARE, newsId.toString());
            if (null != reward) {
                shareGoldDTO = new NewShareGoldDTO();
                shareGoldDTO.setGoldNum(reward);
                shareGoldDTO.setTotalGold(userAmountService.selectGoldBalanceByUserId(userId));
                shareGoldDTO.setTaskName(TASK_NEWS_SHARE.getDesc());
            }
            //记录是否分享过该新闻
            redisStringAdapter.set(shareRecordKey, "exist");
            redisStringAdapter.expire(shareRecordKey, DateUtils.getCurSeconds());
        }


        this.newsStatisticsMapper.addShares(newsId);

        //生成分享记录
        NewsCollect nc = this.newsCollectMapper.selectByIds(newsId, userId, NewsCollectEnum.SHARE.getCode());
        if (nc == null && user.getState() == AppConst.USER_STATE.NORMAL) {
            NewsCollect collect = new NewsCollect();
            collect.setNewsId(newsId);
            collect.setUserId(userId);
            collect.setAddTime(new Date());
            collect.setType(NewsCollectEnum.SHARE.getCode());
            this.newsCollectMapper.insert(collect);
            News news = this.newsMapper.selectByPrimaryKey(newsId);
            //热文且分享成功才赠送金币
            if (news.getHot() == NewsIsHotEnum.NEWS_IS_HOST.getCode()) {
                //分享成功获取金币记录
                NewsShare share = new NewsShare();
                share.setAddTime(new Date());
                share.setNewsId(newsId);
                share.setUserId(userId);
                share.setReward(SHARE_REWARD_GOLD_NUM.intValue());
                share.setType(NewsSharEnum.NEWS_SHARE.getCode());
                this.newsShareMapper.insert(share);
            }
        }
        return ResultUtil.genSuccessResult(shareGoldDTO);
    }

    /**
     * 万事通发放分享文章奖励
     * 用户每日分享不同文章给与奖励,限制次数,并标记完成所有次数后每日任务为完成状态
     * @param userId 用户ID
     * @param newsId 分享新闻
     * @deprecated 统一放到missionService
     */
    private NewShareGoldDTO grantShareGoldForWST(Long userId, Long newsId) {
        KeyGenerator shareNumKey = TASK_SHARE_NEWS_NUM.copy().appendKey(userId.toString()).appendKey(DateUtils.formatDate(new Date()));
        Integer number = redisStringAdapter.getInt(shareNumKey);
        if (number == null) {
            number = 0;
        }
        KeyGenerator shareRecordKey = USER_SHARE_NEWS_RECORD.copy()
                .appendKey(userId.toString())
                .appendKey(DateUtils.formatDate(new Date()))
                .appendKey(newsId.toString());
        NewShareGoldDTO newShareGoldDTO = null;
        if (number < this.newsProperties.getShareNumAwardCount() && !redisStringAdapter.hasKey(shareRecordKey)) {

            PayFlow payFlow = PayFlow.initPayFlow(userId, TASK_NEWS_SHARE.getType(), REWARD_TYPE_GOLD, newsId.toString());
            this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, SHARE_REWARD_GOLD_NUM, false);
            newShareGoldDTO = new NewShareGoldDTO();
            newShareGoldDTO.setGoldNum(SHARE_REWARD_GOLD_NUM.longValue());
            newShareGoldDTO.setTotalGold(userAmountService.selectGoldBalanceByUserId(userId));
            number++;
            //统计完成次数
            redisStringAdapter.set(shareNumKey, number);
            this.redisStringAdapter.expire(shareNumKey, DateUtils.getCurSeconds());
            //记录是否分享过该新闻
            redisStringAdapter.set(shareRecordKey, "exist");
            redisStringAdapter.expire(shareRecordKey, DateUtils.getCurSeconds());

            //统计当天完成任务获得的金币总数
            KeyGenerator userRewardSumKey = RedisConfig.USER_MISSION_REWARD_SUM_PER_DAY.copy()
                    .setKey(userId + ":" + DateUtils.formatDate(new Date()));
            redisStringAdapter.incrementWithDefault(userRewardSumKey, NewsConstant.NEWS_REWARD_NUM, SHARE_REWARD_GOLD_NUM.intValue());
            redisStringAdapter.expire(userRewardSumKey, DateUtils.getCurSeconds());

            //标记分享文章的任务为完成状态
            if (number == this.newsProperties.getShareNumAwardCount()) {
                this.missionService.compleDailyTask(userId, TaskEnum.TASK_NEWS_SHARE.getType());

                String taskType = "日常任务";
                String title = "完成" + taskType + ":" + "分享新闻/视频";
                String content = "恭喜" + title + ",共计获得" + 200 + "金币";
                PushMessage pushMessage = PushMessage.build();
                pushMessage.setTitle(title);
                pushMessage.setContent(content);
                pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
                pushMessage.setPayloadInfo(PushPayloadInfo.build(PushMessageEnum.TASK_COMPLETED));
                pushMsgSupplyFeignService.pushMsg(pushMessage);
            }
        }

        return newShareGoldDTO;
    }

    @Override
    public Json<NewsMeta> refreshVideo(Long userId, Byte type, Integer kindId) {
        NewsMeta meta = new NewsMeta();
        NewsRecommendParam param = new NewsRecommendParam();
        param.setUserId(userId);
        param.setPagesize(AppConst.REFRESH_VIDEO_NUM);
        if (null != kindId) {
            param.setKindId(Long.valueOf(kindId));
        }
        param.setType(type);
        List<News> newsList = this.newsMapper.queryVideoList(param);
        if (!CollectionUtils.isEmpty(newsList)) {
            List<News4Client> news4ClientList = newsList.stream().map(news -> new News4Client(news, null)).collect(Collectors.toList());
            //去重
            this.newsRecommendedMapper.batchInsert(userId, type, newsList);
            int adSize = getAdvertSizeFromVedio(newsList);
            meta.setList(news4ClientList);
            meta.setNewsCount(newsList.size());
        }
        return ResultUtil.genSuccessResult(meta);
    }

    /**
     * 在视频列表中的广告插入
     * @param newsList
     * @return
     */
    private int getAdvertSizeFromVedio(List<News> newsList) {
        int adSize = newsList.size() / 4;
        if (adSize == 0) {
            adSize = newsList.size() >= 2 ? 1 : 0;
        }
        return adSize;
    }

    @Override
    public Json<List<NewsSearchWord>> searchHotTitle() {
        return ResultUtil.genSuccessResult(this.newsSearchWordMapper.queryList());
    }

    @Override
    public Json<List<NewsKind>> searchKinds() {
        return ResultUtil.genSuccessResult(this.newsKindMapper.selectVideoKinds());
    }

    @Deprecated
    @Override
    public Json<FailVideo> getFailVideo(Long newsId) {
        //新闻视频无法播放的处理
        return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "无效视频");
    }

    @Override
    public Json addClick(Long newsId) {
        this.newsStatisticsMapper.searchRecommended(newsId);
        return ResultUtil.genSuccessResult();
    }

    @Override
    public void delNewsTag() {
        this.newsTagMapper.delByDate(DateUtils.addField(new Date(), Calendar.DATE, -2));
    }

}
