package com.bxm.localnews.news.strategy;

import com.bxm.localnews.activity.service.MissionService;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.integration.feign.PushMsgSupplyFeignService;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.news.domain.NewsRecordMapper;
import com.bxm.localnews.news.domain.NewsStatisticsMapper;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import com.bxm.localnews.news.param.ExecGoldParam;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import com.bxm.localnews.news.vo.NewsRecord;
import com.bxm.localnews.user.service.PayFlowService;
import com.bxm.localnews.user.service.UserAmountService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.PayFlow;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.StringUtils;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;

import static com.bxm.localnews.common.constant.AppConst.*;
import static com.bxm.localnews.common.constant.RedisConfig.RECOMMEND_NEWS_READ;
import static com.bxm.localnews.common.constant.TaskEnum.READ_PUSH_ARTICLE;


/**
 * 文章阅读奖励策略抽象类，主要放一些公用方法与变量
 */
public abstract class AbstractGoldenStrategy implements GoldenStrategy {

    public boolean viewTimeFlag = true;

    public boolean advertShowFlag = true;

    public boolean tabTYpeFlag = true;

    @Resource
    public NewsRecordMapper newsRecordMapper;

    @Resource
    public UserService userService;
    @Resource
    public PayFlowService payFlowService;
    @Resource
    public NewsStatisticsMapper newsStatisticsMapper;
    @Resource
    public RedisStringAdapter redisStringAdapter;
    @Resource
    public MissionService missionService;
    public Integer randomInterval;
    public String configTabType;
    public String configAdvertShow;
    public Integer configViewTime;
    @Resource
    private NewsProperties newsProperties;
    @Resource
    private UserAmountService userAmountService;
    @Resource
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;

    @PostConstruct
    public void init() {
        this.randomInterval = RandomUtils.getRandomTime(this.newsProperties.getAwardTimeLag());
        this.configTabType = this.newsProperties.getTabType();
        this.configAdvertShow = this.newsProperties.getShowAdvert();
        this.configViewTime = this.newsProperties.getViewTime();
    }


    @Override
    public void commonJudgment(ExecGoldCalParam execGoldParam) {
        Long newsId = execGoldParam.getNewsId();
        Long userId = execGoldParam.getUserId();
        Integer viewTime = execGoldParam.getViewTime();
        String advertShow = execGoldParam.getAdvertShow();
        String isRecommendNews = execGoldParam.getIsRecommendNews();

        NewsGoldMeta newsGoldMeta = execGoldParam.getNewsGoldMeta();

        User user = this.userService.selectByPrimaryKey(userId);
        this.newsStatisticsMapper.addActiveViews(newsId);
        Date today = new Date();
        //游客用户，不赠送金币
        if (isGuestUser(user)) {
            newsGoldMeta.setGoldType(AppConst.UN_GOLD);
            //推荐类文章直接送金币，推荐类文章，每天3篇，次数记录在redis中 暂时废弃
//        } else if (isRecommondNews(isRecommendNews)) {
//            execRecommendGold(newsId, userId, newsGoldMeta);
        } else {
            //判断新闻阅读是否有效
            NewsRecord nRecord = this.newsRecordMapper.getByIds(newsId, userId, null);

            //存在阅读记录并且该用户对于该新闻已获得奖励
            if (nRecord != null && nRecord.getGetGold() == NN_GOLD) {
                doUpdateRecord(newsGoldMeta, viewTime, nRecord);
                //其他情况->///
            } else {
                //存在阅读记录并且该用户对于该新闻未获得奖励
                if (nRecord != null && nRecord.getActiveView() != NN_GOLD) {
                    doUpdateRecord(newsGoldMeta, viewTime, nRecord);
                    //不存在阅读记录
                } else if (nRecord == null) {
                    nRecord = generatorNewsRecord(execGoldParam);
                    this.newsRecordMapper.insertSelective(nRecord);
                }

                nRecord.setUpdateTime(today);
                nRecord.setCheckTime(viewTime);
                nRecord.setAdViewType(Byte.valueOf(advertShow));

                //查看最近新闻浏览间隔
                boolean suspendFlag = isSuspend(userId);

                //初始化包装类为【未获取金币】
                newsGoldMeta.setGoldType(AppConst.UN_GOLD);

                //转换包装类
                execGoldParam.setNewsGoldMeta(newsGoldMeta);
                execGoldParam.setnRecord(nRecord);
                execGoldParam.setSuspendFlag(suspendFlag);

                calculator(execGoldParam);
            }

        }

    }

    /**
     * 判断获取金币的间隔时间是否满足条件
     *
     * @param userId
     * @return
     */
    protected boolean isSuspend(Long userId) {
        NewsRecord record = this.newsRecordMapper.getOneByUserId(userId, NN_GOLD);
        if (record != null) {
            Long time = record.getGetGoldTime().getTime() + record.getIntervalNum() * 1000;
            Long time2 = System.currentTimeMillis();
            return time <= time2;
        }
        return true;
    }


    /**
     * 增加金币并且判断是否已完成任务
     *
     * @param userId
     * @param newsId
     * @param key
     * @param number
     * @param taskTypeEnum
     * @param rewardNum
     * @param flag
     */
    protected void addGold(Long userId,
                           Long newsId,
                           KeyGenerator key,
                           Integer number,
                           TaskEnum taskTypeEnum,
                           Integer rewardNum,
                           Boolean flag) {
        PayFlow payFlow = PayFlow.initPayFlow(userId, taskTypeEnum.getType(), REWARD_TYPE_GOLD, newsId.toString());
        //1.更新金币
        this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, new BigDecimal(rewardNum), flag);
        //2.更新用户剩余可获取金币次数
        this.redisStringAdapter.set(key, number - 1, DateUtils.getCurSeconds());
        //3.判断是否完成任务
        if (number == 1) {
            this.missionService.compleDailyTask(userId, taskTypeEnum.getType());

            String taskType = "日常任务";
            String title = "完成" + taskType + ":" + taskTypeEnum.getDesc();
            String content = "恭喜" + title + ",共计获得" + 200 + "金币";
            PushMessage pushMessage = PushMessage.build();
            pushMessage.setTitle(title);
            pushMessage.setContent(content);
            pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
            pushMessage.setPayloadInfo(PushPayloadInfo.build(taskTypeEnum.getPushMessageEnum()));
            pushMsgSupplyFeignService.pushMsg(pushMessage);
        }
    }

    /**
     * 生成阅读记录
     *
     * @param execGoldParam
     * @return
     */
    NewsRecord generatorNewsRecord(ExecGoldParam execGoldParam) {
        Date today = new Date();
        NewsRecord nRecord = new NewsRecord();
        nRecord.setNewsId(execGoldParam.getNewsId());
        nRecord.setUserId(execGoldParam.getUserId());
        nRecord.setUpdateTime(today);
        nRecord.setCheckTime(execGoldParam.getViewTime());
        nRecord.setGetGold(AppConst.UN_GOLD);
        nRecord.setAddTime(today);
        nRecord.setLastLocation(execGoldParam.getTabType());
        nRecord.setAdViewType(Byte.valueOf(execGoldParam.getAdvertShow()));
        nRecord.setActiveView((byte) 2);
        return nRecord;
    }

    /**
     * 是否是游客用户
     *
     * @param user
     * @return
     */
    private boolean isGuestUser(User user) {
        if (user == null || user.getState() == AppConst.USER_STATE.VISITOR) {
            return true;
        }
        return false;
    }

    /**
     * 是否是推荐的新闻
     *
     * @param isRecommendNews
     * @return
     */
    private boolean isRecommondNews(String isRecommendNews) {
        if (StringUtils.equals(IS_RECOMMEND_NEWS, isRecommendNews)) {
            return true;
        }
        return false;
    }

    /**
     * 更新阅读记录表
     *
     * @param newsGoldMeta
     * @param viewTime
     * @param nRecord
     */
    private void doUpdateRecord(NewsGoldMeta newsGoldMeta, Integer viewTime, NewsRecord nRecord) {
        newsGoldMeta.setGoldType(AppConst.UN_GOLD);
        nRecord.setUpdateTime(new Date());
        if (viewTime > nRecord.getCheckTime()) {
            nRecord.setCheckTime(viewTime);
        }

        this.newsRecordMapper.updateByPrimaryKeySelective(nRecord);

    }

    /**
     * 若是推荐新闻，则更新
     *
     * @param newsId
     * @param userId
     * @param newsGoldMeta
     */
    private void execRecommendGold(Long newsId, Long userId, NewsGoldMeta newsGoldMeta) {
        KeyGenerator key = getReadNewsCacheKey(userId);
        String number = this.redisStringAdapter.getString(key);
        Integer numberFormat;
        newsGoldMeta.setGoldType(AppConst.UN_GOLD);
        if (isNumberNotExsit(number)) {
            numberFormat = BY_READ_RECOMMEND_REWARD_GOLD_NUM;
            this.redisStringAdapter.set(key, number, DateUtils.getCurSeconds());
        } else {
            numberFormat = Integer.valueOf(number);
        }

        if (numberFormat > 0) {
            this.addGold(userId, newsId, key, numberFormat, READ_PUSH_ARTICLE, READ_RECOMMEND_REWARD_GOLD_NUM, false);
            newsGoldMeta.setGoldType(NN_GOLD);
            newsGoldMeta.setGoldNum(READ_RECOMMEND_REWARD_GOLD_NUM);
        }
    }

    /**
     * 得到新闻剩余阅读数量的key
     *
     * @param userId
     * @return
     */
    private KeyGenerator getReadNewsCacheKey(Long userId) {
        KeyGenerator key = RECOMMEND_NEWS_READ.copy();
        key.setKey(userId + DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
        return key;
    }

    /**
     * 检查是否有效阅读
     *
     * @param configViewTime
     * @param viewTime
     * @return
     */
    boolean checkViewTimeFlag(Integer configViewTime, Integer viewTime) {
        return viewTime > configViewTime;
    }

    /**
     * 检查是否有广告位被展示出来
     *
     * @param configAdvertShow
     * @param advertShow
     * @return
     */
    boolean checkAdvertShowFlag(String configAdvertShow, String advertShow) {
        if (AppConst.NN_ADVERT_SHOW.equals(configAdvertShow)) {
            if (!AppConst.NN_ADVERT_SHOW.equals(advertShow)) {
                return false;
            }
        }
        return true;
    }

    /**
     * 检查是否被滑到底部
     *
     * @param configTabType
     * @param tabType
     * @return
     */
    boolean checkTabTYpeFlag(String configTabType, String tabType) {
        if (AppConst.NN_TAB_TYPE.equals(configTabType)) {
            if (!AppConst.NN_TAB_TYPE.equals(tabType)) {
                return false;
            }
        }
        return true;
    }

    /**
     * 初始化用户当天的剩余阅读奖励次数
     *
     * @param key
     */
    protected Integer initReadNum(KeyGenerator key) {
        Integer number = this.newsProperties.getReadNumAwardCount();
        this.redisStringAdapter.set(key, number, DateUtils.getCurSeconds());
        return number;
    }

    /**
     * 判断用户是否存在阅读奖励次数
     *
     * @param number
     * @return
     */
    protected boolean isNumberNotExsit(String number) {
        return StringUtils.isEmpty(number);
    }

    /**
     * 判断用户是否剩余阅读奖励次数
     *
     * @param number
     * @return
     */
    protected boolean isNumberRemained(Integer number) {
        return null != number && number > 0;
    }

}
