/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.news.constant.SensitiveFlagEnum;
import com.bxm.localnews.news.domain.NewsKindMapper;
import com.bxm.localnews.news.domain.UserKindMapper;
import com.bxm.localnews.news.dto.KindDTO;
import com.bxm.localnews.news.service.NewsKindService;
import com.bxm.localnews.news.vo.NewsKind;
import com.bxm.localnews.news.vo.UserKind;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service(value="newsKindService")
@RefreshScope
public class NewsKindServiceImpl
implements NewsKindService {
    private static final Logger logger = LoggerFactory.getLogger(NewsKindServiceImpl.class);
    private NewsKindMapper newsKindMapper;
    private UserKindMapper userKindMapper;
    private RedisStringAdapter redisStringAdapter;
    private RedisHashMapAdapter redisHashMapAdapter;
    private RedisSetAdapter redisSetAdapter;
    private AppVersionSupplyService appVersionSupplyService;

    @Autowired
    public NewsKindServiceImpl(NewsKindMapper newsKindMapper, UserKindMapper userKindMapper, RedisStringAdapter redisStringAdapter, RedisHashMapAdapter redisHashMapAdapter, RedisSetAdapter redisSetAdapter, AppVersionSupplyService appVersionSupplyService) {
        this.newsKindMapper = newsKindMapper;
        this.userKindMapper = userKindMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.appVersionSupplyService = appVersionSupplyService;
    }

    private Boolean getPublishState(BasicParam basicParam) {
        return this.appVersionSupplyService.getPublishState(basicParam);
    }

    public List<NewsKind> selectAll(BasicParam basicParam, String areaName) {
        List<NewsKind> allKinds = this.selectAllToRedis();
        this.replaceLocalAreaName(areaName, allKinds);
        if (this.getPublishState(basicParam).booleanValue()) {
            allKinds.removeIf(newsKind -> SensitiveFlagEnum.IS_SENSITIVE.getState().equals(newsKind.getSensitiveFlag()));
        }
        return allKinds;
    }

    public Message createUserDefaultKinds(Long userId) {
        return Message.build((int)this.newsKindMapper.initUserDefaultKinds(userId));
    }

    public Message createUserDefaultKindsForPublish(Long userId, BasicParam basicParam) {
        List<Object> ids = Lists.newArrayList();
        List<NewsKind> allKinds = this.selectAllToRedis();
        ids = allKinds.stream().filter(newsKind -> newsKind.getIsDefault() == 1).map(NewsKind::getId).collect(Collectors.toList());
        List<Integer> userKindList = this.getFixKindId();
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            userKindList.addAll(ids);
        }
        userKindList = userKindList.stream().distinct().collect(Collectors.toList());
        ArrayList userKinds = Lists.newArrayList();
        for (int i = 0; i < userKindList.size(); ++i) {
            UserKind userKind = new UserKind();
            userKind.setUserId(userId);
            userKind.setKindId(userKindList.get(i));
            userKind.setSortNo(Integer.valueOf(i));
            userKinds.add(userKind);
        }
        this.userKindMapper.batchInsert((List)userKinds);
        return Message.build((boolean)true);
    }

    public KindDTO getMyKindAndAllKind(Long userId, String areaName, BasicParam basicParam) {
        List<NewsKind> allKinds = this.selectAll(basicParam, areaName);
        KindDTO kindDTO = new KindDTO(allKinds, null);
        if (null != userId) {
            List<NewsKind> myKinds = this.getMyKind(userId);
            this.replaceLocalAreaName(areaName, myKinds);
            if (this.getPublishState(basicParam).booleanValue()) {
                myKinds.removeIf(newsKind -> SensitiveFlagEnum.IS_SENSITIVE.getState().equals(newsKind.getSensitiveFlag()));
            }
            kindDTO = new KindDTO(allKinds, myKinds);
        }
        return kindDTO;
    }

    private void replaceLocalAreaName(String areaName, List<NewsKind> myKinds) {
        NewsKind removeNewsKind = null;
        if (StringUtils.isNotBlank((CharSequence)areaName) && myKinds != null && myKinds.size() > 0) {
            for (NewsKind newsKind : myKinds) {
                logger.info("newsKind.getName:{}", (Object)newsKind.getName());
                if (!StringUtils.equals((CharSequence)newsKind.getName(), (CharSequence)"\u672c\u5730")) continue;
                removeNewsKind = newsKind;
                break;
            }
        }
        if (removeNewsKind != null) {
            myKinds.remove(removeNewsKind);
        }
    }

    public Message addUserKind(Long userId, Integer kindId) {
        List<NewsKind> myKinds = this.getMyKind(userId);
        if (myKinds.stream().filter(item -> item.getId().equals(kindId)).findAny().isPresent()) {
            return Message.build((boolean)false, (String)"\u91cd\u590d\u6dfb\u52a0");
        }
        List<NewsKind> allKinds = this.selectAllToRedis();
        Optional<NewsKind> newsKindOptional = allKinds.stream().filter(item -> item.getId().equals(kindId)).findFirst();
        if (newsKindOptional.isPresent()) {
            NewsKind newsKind = newsKindOptional.get();
            myKinds.add(newsKind);
        }
        this.syncMyKind(myKinds, userId);
        return Message.build();
    }

    public void resortUserKind(Long userId, Integer[] kindIds, String firstOpenType) {
        if (ArrayUtils.isEmpty((Object[])kindIds)) {
            return;
        }
        List userKindIds = Stream.of(kindIds).collect(Collectors.toList());
        List<Integer> userKindList = this.getFixKindId();
        userKindList.addAll(userKindIds);
        userKindList = userKindList.stream().distinct().collect(Collectors.toList());
        List<NewsKind> allKinds = this.selectAllToRedis();
        ArrayList myKinds = Lists.newArrayList();
        userKindList.forEach(id -> allKinds.forEach(newsKind -> {
            if (newsKind.getId().equals(id)) {
                myKinds.add(newsKind);
            }
        }));
        this.syncMyKind(myKinds, userId);
    }

    private List<NewsKind> getMyKind(Long userId) {
        TypeReference<List<NewsKind>> typeReference = new TypeReference<List<NewsKind>>(){};
        List myKinds = (List)this.redisHashMapAdapter.get(RedisConfig.NEWS_USER_KIND, userId.toString(), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)myKinds)) {
            myKinds = this.userKindMapper.myKinds(userId);
            this.syncMyKind(myKinds, userId);
        }
        return myKinds;
    }

    private void syncMyKind(List<NewsKind> myKinds, Long userId) {
        if (CollectionUtils.isNotEmpty(myKinds)) {
            this.redisHashMapAdapter.put(RedisConfig.NEWS_USER_KIND, userId.toString(), myKinds);
            this.redisSetAdapter.add(RedisConfig.NEWS_USER_KIND_SET, new Object[]{userId});
        }
    }

    private List<NewsKind> selectAllToRedis() {
        List newsKindList;
        String str = (String)this.redisStringAdapter.get(RedisConfig.NEWS_KIND, String.class);
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            newsKindList = JSONArray.parseArray((String)str, NewsKind.class);
        } else {
            newsKindList = this.newsKindMapper.selectAll();
            try {
                if (null != newsKindList) {
                    this.redisStringAdapter.set(RedisConfig.NEWS_KIND, (Object)JSONArray.toJSONString((Object)newsKindList));
                }
            }
            catch (Exception e) {
                logger.error("newsKind set redis error");
            }
        }
        return newsKindList;
    }

    private List<Integer> getFixKindId() {
        List<NewsKind> allKinds = this.selectAllToRedis();
        return allKinds.stream().filter(newsKind -> newsKind.getIsFix() == 1).map(NewsKind::getId).collect(Collectors.toList());
    }
}

