/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.NewsStatisticsMapper;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.service.NewsReplyService;
import com.bxm.localnews.news.vo.MyReceiveReplysVO;
import com.bxm.localnews.news.vo.MyReplysVO;
import com.bxm.localnews.news.vo.NewsReply;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class NewsReplyServiceImpl
implements NewsReplyService {
    @Resource
    private NewsReplyMapper newsReplyMapper;
    @Resource
    private NewsStatisticsMapper newsStatisticsMapper;
    @Resource
    private NewsMapper newsMapper;

    public List<NewsReplyDTO> queryReplyList(Long newsId, MPage page) {
        List list = this.newsReplyMapper.queryParentList(newsId, page);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (NewsReplyDTO vo : list) {
                List replies;
                if (vo.getDeleteFlag() == 1) {
                    vo.setReplyContent(null);
                }
                if (!CollectionUtils.isNotEmpty((Collection)(replies = this.newsReplyMapper.selectReplyList(newsId, vo.getId())))) continue;
                replies.forEach(replay -> {
                    if (replay.getDeleteFlag() == 1) {
                        replay.setReplyContent(null);
                    }
                });
                vo.setList(replies);
            }
        }
        return list;
    }

    public Json reply(NewsReply newsReply) {
        this.newsStatisticsMapper.replystatistics(newsReply.getNewsId());
        this.newsReplyMapper.insertSelective(newsReply);
        return ResultUtil.genSuccessResult();
    }

    public List<MyReplysVO> selectMyReplys(Long userId, MPage page) {
        return this.newsReplyMapper.selectMyReplys(userId, page);
    }

    public Json delMyReply(Long replyId) {
        this.newsReplyMapper.deleteByPrimaryKey(replyId);
        return ResultUtil.genSuccessResult();
    }

    public List<MyReceiveReplysVO> myReceiveReplys(Long userId, MPage page) {
        List result = this.newsReplyMapper.myReceiveReplys(userId, page);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            result.forEach(reply -> {
                if (reply.getDeleteFlag() == 1) {
                    reply.setReplyContent(null);
                }
            });
        }
        return result;
    }

    @Async
    public void triggerUpdateInfo(Long userId, String nickname, String headImg) {
        NewsReply parent = new NewsReply(nickname, headImg, userId);
        NewsReply user = new NewsReply(userId, nickname, headImg);
        this.newsReplyMapper.updateByUserId(user);
        this.newsReplyMapper.updateByParentUserId(parent);
    }
}

