/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.activity.dto.NewShareGoldDTO;
import com.bxm.localnews.activity.service.MissionService;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.integration.feign.NewsRecommendFeignService;
import com.bxm.localnews.integration.feign.NewsSearchFeignService;
import com.bxm.localnews.integration.feign.PushMsgSupplyFeignService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.domain.NewsKindMapper;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsRecommendedMapper;
import com.bxm.localnews.news.domain.NewsRecordMapper;
import com.bxm.localnews.news.domain.NewsSearchWordMapper;
import com.bxm.localnews.news.domain.NewsShareMapper;
import com.bxm.localnews.news.domain.NewsStatisticsMapper;
import com.bxm.localnews.news.domain.NewsTagMapper;
import com.bxm.localnews.news.domain.UserSearchRecordMapper;
import com.bxm.localnews.news.dto.ESNewsContentDTO;
import com.bxm.localnews.news.enums.NewsCollectEnum;
import com.bxm.localnews.news.enums.NewsConstant;
import com.bxm.localnews.news.enums.NewsIsHotEnum;
import com.bxm.localnews.news.enums.NewsSharEnum;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import com.bxm.localnews.news.param.ExecGoldParam;
import com.bxm.localnews.news.param.NewsParam;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.strategy.GoldenStrategyContext;
import com.bxm.localnews.news.vo.FailVideo;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.News4Client;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.localnews.news.vo.NewsDetailVO;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import com.bxm.localnews.news.vo.NewsKind;
import com.bxm.localnews.news.vo.NewsMeta;
import com.bxm.localnews.news.vo.NewsRecommendParam;
import com.bxm.localnews.news.vo.NewsRecord;
import com.bxm.localnews.news.vo.NewsSearchWord;
import com.bxm.localnews.news.vo.NewsShare;
import com.bxm.localnews.news.vo.NewsUrlVo;
import com.bxm.localnews.news.vo.NewsVO;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.vo.Advert;
import com.bxm.localnews.user.service.PayFlowService;
import com.bxm.localnews.user.service.UserAmountService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.PayFlow;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="newsService")
public class NewsServiceImpl
implements NewsService {
    private static final Logger logger = LoggerFactory.getLogger(NewsServiceImpl.class);
    @Resource
    private NewsMapper newsMapper;
    @Resource
    private NewsRecordMapper newsRecordMapper;
    @Resource
    private UserService userService;
    @Resource
    private PayFlowService payFlowService;
    @Resource
    private NewsStatisticsMapper newsStatisticsMapper;
    @Resource
    private NewsCollectMapper newsCollectMapper;
    @Resource
    private NewsRecommendedMapper newsRecommendedMapper;
    @Resource
    private AdvertService advertService;
    @Resource
    private NewsShareMapper newsShareMapper;
    @Resource
    private NewsSearchWordMapper newsSearchWordMapper;
    @Resource
    private NewsKindMapper newsKindMapper;
    @Resource
    private NewsProperties newsProperties;
    @Resource
    private UserSearchRecordMapper userSearchRecordMapper;
    @Resource
    private NewsTagMapper newsTagMapper;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private MissionService missionService;
    @Resource
    private GoldenStrategyContext goldenStrategyContext;
    @Resource
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;
    @Resource
    private AppVersionSupplyService appVersionSupplyService;
    @Resource
    private UserAmountService userAmountService;
    @Resource
    private NewsRecommendFeignService newsRecommendFeignService;
    @Resource
    private NewsSearchFeignService newsSearchFeignService;

    @Override
    public Json<NewsUrlVo> getUrl(Long newsId, Long userId, Byte type) {
        News news;
        if (this.isNews(type, newsId) && null != (news = this.newsMapper.selectByPrimaryKey(newsId))) {
            String url = this.getNewsUrlBegin(type, news.getType()) + "newsId=" + newsId + "&userId=" + userId + "&type=" + type;
            NewsUrlVo newsUrlVo = new NewsUrlVo(url);
            return ResultUtil.genSuccessResult((Object)newsUrlVo);
        }
        if (this.isAdvert(type)) {
            Advert advert = this.advertService.selectByPrimaryKey(newsId);
            String url = this.getAdvertBegin(advert) + "userId=" + userId + "&type=" + type;
            NewsUrlVo newsUrlVo = new NewsUrlVo(url);
            return ResultUtil.genSuccessResult((Object)newsUrlVo);
        }
        logger.error("\u83b7\u5f97\u8be6\u60c5\u5730\u5740\u65f6\u65b0\u95fb\u4e0d\u5b58\u5728-newsId:{},userId:{},type:{}", new Object[]{newsId, userId, type});
        return ResultUtil.genFailedResult((int)503, (String)"\u83b7\u5f97\u8be6\u60c5\u5730\u5740\u65f6\u65b0\u95fb\u4e0d\u5b58\u5728");
    }

    private boolean isEssayShare(Byte type, Byte newsType) {
        return type == 2 && newsType == 1;
    }

    private boolean isIconEssayShare(Byte type, Byte newsType) {
        return type == 2 && newsType == 2;
    }

    private boolean isVideoShare(Byte type, Byte newsType) {
        return type == 2 && newsType == 3;
    }

    private boolean isEssayDetail(Byte type) {
        return type == 1 || type == 3;
    }

    private boolean isNews(Byte type, Long newsId) {
        return type != 4;
    }

    private boolean isAdvert(Byte type) {
        return type == 4;
    }

    private String getNewsUrlBegin(byte type, byte newsType) {
        String url = "";
        if (this.isEssayShare(type, newsType)) {
            url = "shareNewsDetail.html?";
        }
        if (this.isIconEssayShare(type, newsType)) {
            url = "sharePicDetail.html?";
        }
        if (this.isVideoShare(type, newsType)) {
            url = "shareVideoDetail.html?";
        }
        if (this.isEssayDetail(type)) {
            url = "newsDetail.html?";
        }
        return url;
    }

    private String getAdvertBegin(Advert advert) {
        String url = "";
        if (advert != null) {
            url = advert.getAddress().contains("?") ? advert.getAddress() + "&" : advert.getAddress() + "?";
        }
        return url;
    }

    private Boolean getPublishState(BasicParam basicParam) {
        return this.appVersionSupplyService.getPublishState(basicParam);
    }

    @Override
    public Json<NewsDetailVO> execGetSyDetail(NewsParam newsParam) {
        NewsVO news = this.newsMapper.getById(newsParam.getNewsId(), newsParam.getUserId());
        logger.info("\u65b0\u95fb\u8be6\u60c5es\u5f00\u59cb\u62c9\u53d6 ");
        ResponseEntity responseEntity = this.newsSearchFeignService.multipleGet(new Long[]{news.getId()});
        if (responseEntity == null || responseEntity.getStatusCode().isError() || ((List)responseEntity.getBody()).isEmpty()) {
            logger.info("\u65b0\u95fb\u8be6\u60c5es\u62c9\u53d6\u5931\u8d25:{}", responseEntity.getBody());
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u83b7\u53d6\u8be6\u60c5\u65f6\u65b0\u95fb\u7f3a\u5931");
        }
        logger.info("\u65b0\u95fb\u8be6\u60c5es\u62c9\u53d6\u5b8c\u6bd5, isError:{},content :{}", (Object)responseEntity.getStatusCode().isError(), (Object)((ESNewsContentDTO)((List)responseEntity.getBody()).get(0)).getContent());
        news.setContent(((ESNewsContentDTO)((List)responseEntity.getBody()).get(0)).getContent());
        if (null != news) {
            NewsDetailVO newsDetailVO = new NewsDetailVO(news);
            try {
                if (newsParam.getType() == 2) {
                    this.newsStatisticsMapper.searchRecommended(newsParam.getNewsId());
                }
                if (newsParam.getUserId() != null && newsParam.getType() != 2) {
                    NewsRecord record = this.newsRecordMapper.getByIds(newsParam.getNewsId(), newsParam.getUserId(), null);
                    Date d = new Date();
                    if (record == null) {
                        record = new NewsRecord();
                        record.setNewsId(newsParam.getNewsId());
                        record.setAddTime(d);
                        record.setUpdateTime(d);
                        record.setUserId(newsParam.getUserId());
                        this.newsRecordMapper.insertSelective(record);
                    } else {
                        record.setUpdateTime(d);
                        this.newsRecordMapper.updateByPrimaryKeySelective(record);
                    }
                }
                if (this.getPublishState((BasicParam)newsParam).booleanValue()) {
                    newsDetailVO.getNews().setAuthor("");
                    newsDetailVO.getNews().setAuthorImg("");
                }
                return ResultUtil.genSuccessResult((Object)newsDetailVO);
            }
            catch (Exception e) {
                logger.info("\u65b0\u95fb\u9605\u8bfb\u8bb0\u5f55\u8bb0\u5f55\u5931\u8d25:{}", (Throwable)e);
                return ResultUtil.genSuccessResult((Object)newsDetailVO);
            }
        }
        logger.error("\u83b7\u53d6\u8be6\u60c5\u65f6\u65b0\u95fb\u4e0d\u5b58\u5728-newsId:{},userId:{},type:{}", new Object[]{newsParam.getNewsId(), newsParam.getUserId(), newsParam.getType()});
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u83b7\u53d6\u8be6\u60c5\u65f6\u65b0\u95fb\u4e0d\u5b58\u5728");
    }

    @Override
    public Json<NewsGoldMeta> execGetGold(ExecGoldParam execGoldParam) {
        News news;
        if (null != execGoldParam.getUserId() && null != execGoldParam.getNewsId() && this.isNewsExsit(news = this.newsMapper.selectByPrimaryKey(execGoldParam.getNewsId()), execGoldParam.getViewTime())) {
            NewsGoldMeta newsGoldMeta = new NewsGoldMeta();
            ExecGoldCalParam execGoldCalParam = new ExecGoldCalParam();
            BeanUtils.copyProperties((Object)execGoldParam, (Object)execGoldCalParam);
            execGoldCalParam.setNewsGoldMeta(newsGoldMeta);
            execGoldCalParam.setNews(news);
            this.goldenStrategyContext.chooseCalulator(execGoldCalParam);
            return ResultUtil.genSuccessResult((Object)execGoldCalParam.getNewsGoldMeta());
        }
        NewsGoldMeta newsGoldMeta = new NewsGoldMeta();
        newsGoldMeta.setGoldNum(0);
        newsGoldMeta.setTaskName(TaskEnum.TASK_NEWS_READ.getDesc());
        newsGoldMeta.setGoldType((byte)1);
        newsGoldMeta.setTotalGold(BigDecimal.ZERO);
        return ResultUtil.genSuccessResult((Object)newsGoldMeta);
    }

    private boolean checkReadGoldParam(ExecGoldParam execGoldParam) {
        return null != execGoldParam.getNewsId() && null != execGoldParam.getUserId();
    }

    private boolean isNewsExsit(News news, Integer viewTime) {
        return news != null && viewTime != null;
    }

    @Override
    public Json getBack(Long newsId, Long userId, Integer viewTime, String tabType, String advertShow) {
        NewsRecord nRecord = this.newsRecordMapper.getByIds(newsId, userId, null);
        Date d = new Date();
        if (nRecord != null) {
            nRecord.setUpdateTime(d);
            if (viewTime > nRecord.getCheckTime()) {
                nRecord.setCheckTime(viewTime);
            }
            this.newsRecordMapper.updateByPrimaryKeySelective(nRecord);
        } else {
            NewsRecord nr = new NewsRecord();
            nr.setNewsId(newsId);
            nr.setUserId(userId);
            nr.setUpdateTime(d);
            nr.setCheckTime(viewTime);
            nr.setGetGold(Byte.valueOf((byte)1));
            nr.setAddTime(d);
            nr.setLastLocation(tabType);
            nr.setAdViewType(Byte.valueOf(advertShow));
            this.newsRecordMapper.insertSelective(nr);
        }
        return ResultUtil.genSuccessResult();
    }

    @Override
    public Json<List<News4Client>> queryRecommendNews(Long newsId, Long userId) {
        ResponseEntity responseEntity = this.newsRecommendFeignService.recommendByNewsDetail(newsId, userId);
        List ids = (List)responseEntity.getBody();
        List list = new ArrayList();
        if (null != ids && !ids.isEmpty()) {
            list = this.newsMapper.findNewsByIds(ids);
        }
        List news4ClientList = list.stream().map(news -> new News4Client(news, null)).collect(Collectors.toList());
        return ResultUtil.genSuccessResult(news4ClientList);
    }

    private int getAdvertSizeFromRecommendNews(List<News> list) {
        int adSize = 0;
        int size = list.size();
        if (size > 3) {
            adSize = 3;
        } else if (size == 1) {
            adSize = 1;
        } else if (size >= 2) {
            adSize = 2;
        }
        return adSize;
    }

    @Override
    public Json<List<News4Client>> queryRecommendNews4ImgNews(Long newsId) {
        List list = this.newsMapper.queryRecommendNewsList(newsId, 8, null);
        ArrayList<News4Client> news4ClientList = new ArrayList<News4Client>();
        for (News aList : list) {
            news4ClientList.add(new News4Client(aList, null));
        }
        return ResultUtil.genSuccessResult(news4ClientList);
    }

    @Override
    public Json<NewShareGoldDTO> saveShareNews(Long newsId, Long userId) {
        if (newsId == null || userId == null) {
            return ResultUtil.genFailedResult((int)503, (String)"\u53c2\u6570\u9519\u8bef");
        }
        User user = this.userService.selectByPrimaryKey(userId);
        if (user == null || user.getState() != 1) {
            return ResultUtil.genSuccessResult((Object)new NewShareGoldDTO());
        }
        NewShareGoldDTO shareGoldDTO = null;
        KeyGenerator shareRecordKey = RedisConfig.USER_SHARE_NEWS_RECORD.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date())).appendKey((Object)newsId.toString());
        if (!this.redisStringAdapter.hasKey(shareRecordKey).booleanValue()) {
            Long reward = this.missionService.completeTask(userId, TaskEnum.TASK_NEWS_SHARE, newsId.toString());
            if (null != reward) {
                shareGoldDTO = new NewShareGoldDTO();
                shareGoldDTO.setGoldNum(reward);
                shareGoldDTO.setTotalGold(this.userAmountService.selectGoldBalanceByUserId(userId));
                shareGoldDTO.setTaskName(TaskEnum.TASK_NEWS_SHARE.getDesc());
            }
            this.redisStringAdapter.set(shareRecordKey, (Object)"exist");
            this.redisStringAdapter.expire(shareRecordKey, (long)DateUtils.getCurSeconds());
        }
        this.newsStatisticsMapper.addShares(newsId);
        NewsCollect nc = this.newsCollectMapper.selectByIds(newsId, userId, Byte.valueOf(NewsCollectEnum.SHARE.getCode()));
        if (nc == null && user.getState() == 1) {
            NewsCollect collect = new NewsCollect();
            collect.setNewsId(newsId);
            collect.setUserId(userId);
            collect.setAddTime(new Date());
            collect.setType(Byte.valueOf(NewsCollectEnum.SHARE.getCode()));
            this.newsCollectMapper.insert(collect);
            News news = this.newsMapper.selectByPrimaryKey(newsId);
            if (news.getHot().byteValue() == NewsIsHotEnum.NEWS_IS_HOST.getCode()) {
                NewsShare share = new NewsShare();
                share.setAddTime(new Date());
                share.setNewsId(newsId);
                share.setUserId(userId);
                share.setReward(Integer.valueOf(AppConst.SHARE_REWARD_GOLD_NUM.intValue()));
                share.setType(Byte.valueOf(NewsSharEnum.NEWS_SHARE.getCode()));
                this.newsShareMapper.insert(share);
            }
        }
        return ResultUtil.genSuccessResult((Object)shareGoldDTO);
    }

    private NewShareGoldDTO grantShareGoldForWST(Long userId, Long newsId) {
        KeyGenerator shareNumKey = RedisConfig.TASK_SHARE_NEWS_NUM.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date()));
        Integer number = this.redisStringAdapter.getInt(shareNumKey);
        if (number == null) {
            number = 0;
        }
        KeyGenerator shareRecordKey = RedisConfig.USER_SHARE_NEWS_RECORD.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date())).appendKey((Object)newsId.toString());
        NewShareGoldDTO newShareGoldDTO = null;
        if (number < this.newsProperties.getShareNumAwardCount() && !this.redisStringAdapter.hasKey(shareRecordKey).booleanValue()) {
            PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskEnum.TASK_NEWS_SHARE.getType(), (Byte)10, (String)newsId.toString());
            this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, AppConst.SHARE_REWARD_GOLD_NUM, false);
            newShareGoldDTO = new NewShareGoldDTO();
            newShareGoldDTO.setGoldNum(Long.valueOf(AppConst.SHARE_REWARD_GOLD_NUM.longValue()));
            newShareGoldDTO.setTotalGold(this.userAmountService.selectGoldBalanceByUserId(userId));
            Integer n = number;
            Integer n2 = number = Integer.valueOf(number + 1);
            this.redisStringAdapter.set(shareNumKey, (Object)number);
            this.redisStringAdapter.expire(shareNumKey, (long)DateUtils.getCurSeconds());
            this.redisStringAdapter.set(shareRecordKey, (Object)"exist");
            this.redisStringAdapter.expire(shareRecordKey, (long)DateUtils.getCurSeconds());
            KeyGenerator userRewardSumKey = RedisConfig.USER_MISSION_REWARD_SUM_PER_DAY.copy().setKey(userId + ":" + DateUtils.formatDate((Date)new Date()));
            this.redisStringAdapter.incrementWithDefault(userRewardSumKey, NewsConstant.NEWS_REWARD_NUM.longValue(), AppConst.SHARE_REWARD_GOLD_NUM.intValue());
            this.redisStringAdapter.expire(userRewardSumKey, (long)DateUtils.getCurSeconds());
            if (number.intValue() == this.newsProperties.getShareNumAwardCount()) {
                this.missionService.compleDailyTask(userId, Byte.valueOf(TaskEnum.TASK_NEWS_SHARE.getType()));
                String taskType = "\u65e5\u5e38\u4efb\u52a1";
                String title = "\u5b8c\u6210" + taskType + ":\u5206\u4eab\u65b0\u95fb/\u89c6\u9891";
                String content = "\u606d\u559c" + title + ",\u5171\u8ba1\u83b7\u5f97" + 200 + "\u91d1\u5e01";
                PushMessage pushMessage = PushMessage.build();
                pushMessage.setTitle(title);
                pushMessage.setContent(content);
                pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
                pushMessage.setPayloadInfo(PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.TASK_COMPLETED));
                this.pushMsgSupplyFeignService.pushMsg(pushMessage);
            }
        }
        return newShareGoldDTO;
    }

    @Override
    public Json<NewsMeta> refreshVideo(Long userId, Byte type, Integer kindId) {
        NewsMeta meta = new NewsMeta();
        NewsRecommendParam param = new NewsRecommendParam();
        param.setUserId(userId);
        param.setPagesize(Integer.valueOf(12));
        if (null != kindId) {
            param.setKindId(Long.valueOf(kindId.intValue()));
        }
        param.setType(type);
        List newsList = this.newsMapper.queryVideoList(param);
        if (!CollectionUtils.isEmpty((Collection)newsList)) {
            List news4ClientList = newsList.stream().map(news -> new News4Client(news, null)).collect(Collectors.toList());
            this.newsRecommendedMapper.batchInsert(userId, type, newsList);
            int adSize = this.getAdvertSizeFromVedio(newsList);
            meta.setList(news4ClientList);
            meta.setNewsCount(newsList.size());
        }
        return ResultUtil.genSuccessResult((Object)meta);
    }

    private int getAdvertSizeFromVedio(List<News> newsList) {
        int adSize = newsList.size() / 4;
        if (adSize == 0) {
            adSize = newsList.size() >= 2 ? 1 : 0;
        }
        return adSize;
    }

    @Override
    public Json<List<NewsSearchWord>> searchHotTitle() {
        return ResultUtil.genSuccessResult((Object)this.newsSearchWordMapper.queryList());
    }

    @Override
    public Json<List<NewsKind>> searchKinds() {
        return ResultUtil.genSuccessResult((Object)this.newsKindMapper.selectVideoKinds());
    }

    @Override
    @Deprecated
    public Json<FailVideo> getFailVideo(Long newsId) {
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u65e0\u6548\u89c6\u9891");
    }

    @Override
    public Json addClick(Long newsId) {
        this.newsStatisticsMapper.searchRecommended(newsId);
        return ResultUtil.genSuccessResult();
    }

    @Override
    public void delNewsTag() {
        this.newsTagMapper.delByDate(DateUtils.addField((Date)new Date(), (int)5, (int)-2));
    }
}

