/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.integration.feign.NewsRecommendFeignService;
import com.bxm.localnews.integration.feign.NewsSearchFeignService;
import com.bxm.localnews.news.domain.MarketingActivitiesMapper;
import com.bxm.localnews.news.domain.MarketingActivitiesRecommendedMapper;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsPoolMapper;
import com.bxm.localnews.news.domain.NewsRecommendedMapper;
import com.bxm.localnews.news.dto.ESNewsContentDTO;
import com.bxm.localnews.news.dto.VideoDto;
import com.bxm.localnews.news.enums.ShowLevelEnum;
import com.bxm.localnews.news.param.VideoQueryParam;
import com.bxm.localnews.news.service.RecommendService;
import com.bxm.localnews.news.service.VideoRecommendService;
import com.bxm.localnews.news.vo.MarketingActivities;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.News4Client;
import com.bxm.localnews.news.vo.NewsMeta;
import com.bxm.localnews.news.vo.NewsRecommendParam;
import com.bxm.localnews.news.vo.NewsTopListParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="recommendService")
public class RecommendServiceImpl
extends BaseService
implements RecommendService {
    private static final int MAX_PAGE_SIZE = 20;
    private static final int CACHE_ALARM_VALUE = 60;
    private NewsMapper newsMapper;
    private NewsRecommendedMapper newsRecommendedMapper;
    private MarketingActivitiesMapper marketingActivitiesMapper;
    private MarketingActivitiesRecommendedMapper marketingActivitiesRecommendedMapper;
    private AppVersionSupplyService appVersionSupplyService;
    private NewsProperties newsProperties;
    private VideoRecommendService videoRecommendService;
    private RedisListAdapter redisListAdapter;
    private RedisStringAdapter redisStringAdapter;
    private NewsPoolMapper newsPoolMapper;
    private NewsRecommendFeignService newsRecommendFeignService;
    private NewsSearchFeignService newsSearchFeignService;
    private BizConfigProperties bizConfigProperties;
    private DistributedLock distributedLock;

    @Autowired
    public RecommendServiceImpl(NewsMapper newsMapper, NewsRecommendedMapper newsRecommendedMapper, NewsProperties newsProperties, AppVersionSupplyService appVersionSupplyService, VideoRecommendService videoRecommendService, RedisListAdapter redisListAdapter, RedisStringAdapter redisStringAdapter, NewsPoolMapper newsPoolMapper, NewsRecommendFeignService newsRecommendFeignService, NewsSearchFeignService newsSearchFeignService, MarketingActivitiesMapper marketingActivitiesMapper, MarketingActivitiesRecommendedMapper marketingActivitiesRecommendedMapper, BizConfigProperties bizConfigProperties, DistributedLock distributedLock) {
        this.newsMapper = newsMapper;
        this.newsRecommendedMapper = newsRecommendedMapper;
        this.newsProperties = newsProperties;
        this.appVersionSupplyService = appVersionSupplyService;
        this.videoRecommendService = videoRecommendService;
        this.redisListAdapter = redisListAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.newsPoolMapper = newsPoolMapper;
        this.newsRecommendFeignService = newsRecommendFeignService;
        this.newsSearchFeignService = newsSearchFeignService;
        this.marketingActivitiesMapper = marketingActivitiesMapper;
        this.marketingActivitiesRecommendedMapper = marketingActivitiesRecommendedMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.distributedLock = distributedLock;
    }

    @Override
    public Json<NewsMeta> execRecommend(NewsRecommendParam param) {
        int count = 0;
        return this.retry(param, count);
    }

    private Json<NewsMeta> retry(NewsRecommendParam param, int count) {
        String requestId = String.valueOf(this.nextSequence());
        String userId = String.valueOf(param.getUserId());
        NewsMeta meta = new NewsMeta();
        List idList = new ArrayList();
        if (this.distributedLock.lock(userId, requestId)) {
            ResponseEntity responseEntity = this.newsRecommendFeignService.recommendList(param.getUserId(), Integer.valueOf(param.getKindId().intValue()), param.getPagesize(), param.getAreaCode(), param.getCurPage());
            idList = (List)responseEntity.getBody();
            this.logger.info("\u7528\u6237id:{},\u63a8\u8350\u5f15\u64ce\u8fd4\u56de:{}", (Object)param.getUserId(), responseEntity.getBody());
            this.distributedLock.unlock(userId, requestId);
        } else {
            this.logger.info("\u65b0\u95fb\u63a8\u8350\u8bf7\u6c42\u8fc7\u5feb\uff0c\u8bf7\u4f11\u606f\u4e00\u4f1a!\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)param));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.retry(param, count++);
        }
        if (CollectionUtils.isEmpty(idList)) {
            return ResultUtil.genSuccessResult((Object)meta);
        }
        List list = this.newsMapper.findNewsByIds(idList);
        Long[] ids = (Long[])list.stream().mapToLong(News::getId).boxed().toArray(Long[]::new);
        ResponseEntity newsRspEntity = this.newsSearchFeignService.multipleGet(ids);
        List dtos = (List)newsRspEntity.getBody();
        for (News news2 : list) {
            if (dtos == null || dtos.isEmpty()) continue;
            Optional<ESNewsContentDTO> optional = dtos.stream().filter(dto -> dto.getId().longValue() == news2.getId().longValue()).findFirst();
            news2.setContent((String)optional.map(ESNewsContentDTO::getContent).orElse(null));
            news2.setLinkUrl(this.getNewsDetailUrl(news2.getId(), param.getUserId()));
        }
        List<Object> result = new ArrayList<News>();
        List<News> activityNews = this.addMarketingActivities(param.getUserId(), param.getAreaCode());
        if (CollectionUtils.isNotEmpty(activityNews)) {
            result.addAll(activityNews);
            result = result.stream().sorted(Comparator.comparing(News::getShowLevel)).collect(Collectors.toList());
        }
        for (Long id : idList) {
            Optional<News> optionalNews = list.stream().filter(news -> news.getId().longValue() == id.longValue()).findFirst();
            optionalNews.ifPresent(result::add);
        }
        result = this.warp(result, param.getPagesize());
        List<News4Client> news4ClientList = result.stream().map(news -> new News4Client(news, null)).collect(Collectors.toList());
        if (param.getKindId() == null || (long)this.newsProperties.getRecommendKindId() == param.getKindId()) {
            this.addRecommendVideo(param, news4ClientList);
        }
        meta.setList(news4ClientList);
        meta.setNewsCount(meta.getList().size());
        this.hideInfo(param, meta);
        this.logger.info("\u63a8\u8350\u5b8c\u6210\uff1a{}", (Object)meta);
        return ResultUtil.genSuccessResult((Object)meta);
    }

    private String getNewsDetailUrl(Long newsId, Long userId) {
        return this.bizConfigProperties.getH5ServerHost() + "/newsDetail.html?newsId=" + newsId + "&userId=" + userId + "&type=" + 1;
    }

    private void addRecommendVideo(NewsRecommendParam param, List<News4Client> news4ClientList) {
        this.logger.info("NewsRecommendParam\uff1a{}", (Object)param);
        if (param.getCurPage() != 0 && param.getCurPage() % 2 == 0) {
            VideoQueryParam videoParam = new VideoQueryParam();
            videoParam.setUserId(param.getUserId());
            List<VideoDto> videoDtoList = this.videoRecommendService.execRecommend(videoParam);
            if (CollectionUtils.isNotEmpty(videoDtoList)) {
                int size = news4ClientList.size();
                news4ClientList.add(size / 2, new News4Client(videoDtoList));
            }
        }
    }

    private List<News> addMarketingActivities(Long userId, String areaCode) {
        List list = this.marketingActivitiesMapper.listForRecommend(userId, areaCode);
        ArrayList<News> newsList = new ArrayList<News>();
        for (MarketingActivities activities : list) {
            News news = new News();
            news.setId(activities.getId());
            news.setTitle(activities.getTitle());
            news.setAuthor(activities.getAuthor());
            news.setContent(activities.getLinkUrl());
            news.setKindId(activities.getDeliveryChannel());
            news.setActivity(Byte.valueOf((byte)2));
            news.setIssueTime(activities.getShowTime());
            if (activities.getCoverUrl() != null) {
                String[] coverUrls = StringUtils.split((String)activities.getCoverUrl(), (String)",");
                news.setImgNum(Integer.valueOf(coverUrls.length));
                news.setImgUrl(JSON.toJSONString((Object)coverUrls));
            }
            news.setHot(Byte.valueOf((byte)1));
            news.setTop(Byte.valueOf((byte)1));
            news.setType(Byte.valueOf((byte)1));
            news.setShowLevel(activities.getShowLevel());
            news.setShowLevelDetail(activities.getShowLevelDetail());
            news.setDeliveryType(activities.getDeliveryType());
            news.setAreaDetail(activities.getAreaDetail());
            news.setLinkUrl(activities.getLinkUrl());
            newsList.add(news);
            this.marketingActivitiesRecommendedMapper.save(userId, activities.getId());
        }
        return newsList;
    }

    private List<News> warp(List<News> list, Integer pageSize) {
        list.forEach(news -> {
            news.setTop(Byte.valueOf((byte)1));
            news.setHot(Byte.valueOf((byte)1));
        });
        ArrayList<News> result = new ArrayList<News>();
        for (int i = 0; i < (pageSize > list.size() ? list.size() : pageSize.intValue()); ++i) {
            News news2 = list.get(i);
            this.logger.info("title:{},getShowLevelDetail:{}", (Object)news2.getTitle(), (Object)news2.getShowLevelDetail());
            this.logger.info("news.getShowLevelDetail().indexOf(ShowLevelEnum.TOP.getCode().toString())>-1:{}", (Object)(news2.getShowLevelDetail().indexOf(ShowLevelEnum.TOP.getCode().toString()) > -1 ? 1 : 0));
            if (news2.getShowLevelDetail() != null && news2.getShowLevelDetail().indexOf(ShowLevelEnum.TOP.getCode().toString()) > -1) {
                news2.setTop(Byte.valueOf((byte)2));
            }
            if (news2.getShowLevelDetail() != null && news2.getShowLevelDetail().indexOf(ShowLevelEnum.HOT.getCode().toString()) > -1) {
                news2.setHot(Byte.valueOf((byte)2));
            }
            if (news2.getShowLevelDetail() != null && news2.getShowLevelDetail().indexOf(ShowLevelEnum.ACTIVITY.getCode().toString()) > -1) {
                news2.setActivity(Byte.valueOf((byte)2));
            }
            if (news2.getShowLevelDetail() != null && news2.getShowLevelDetail().indexOf(ShowLevelEnum.LOCAL.getCode().toString()) > -1) {
                news2.setLocal(Byte.valueOf((byte)2));
            }
            result.add(news2);
        }
        return result;
    }

    private void hideInfo(NewsRecommendParam param, NewsMeta meta) {
        if (this.appVersionSupplyService.getPublishState((BasicParam)param).booleanValue()) {
            meta.getList().removeIf(client -> client.getVideos() != null);
            for (News4Client client2 : meta.getList()) {
                if (client2.getNews() == null) continue;
                client2.getNews().setAuthor(null);
                client2.getNews().setAuthorImg(null);
            }
        }
    }

    @Override
    public Json<NewsMeta> getTopNewsList(NewsTopListParam param) {
        List<Object> topNewsList = Lists.newArrayList();
        List topNewsOfAreaList = null;
        KeyGenerator keyGeneratorOfArea = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey((Object)param.getAreaCode());
        String topNewsOfAreaListStr = this.redisStringAdapter.getString(keyGeneratorOfArea);
        if (StringUtils.isNotBlank((String)topNewsOfAreaListStr)) {
            topNewsOfAreaList = JSON.parseArray((String)topNewsOfAreaListStr, News.class);
        } else {
            topNewsOfAreaList = this.newsMapper.findTopNewsOfAreaList(param.getAreaCode());
            if (topNewsOfAreaList != null && topNewsOfAreaList.size() > 0) {
                this.redisStringAdapter.set(keyGeneratorOfArea, (Object)JSON.toJSONString((Object)topNewsOfAreaList));
            }
        }
        List topNewsOfWholeCountryList = null;
        KeyGenerator keyGeneratorOfWholeCountry = RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST;
        String topNewsOfWholeCountryListStr = this.redisStringAdapter.getString(keyGeneratorOfWholeCountry);
        if (StringUtils.isNotBlank((String)topNewsOfWholeCountryListStr)) {
            topNewsOfWholeCountryList = JSON.parseArray((String)topNewsOfWholeCountryListStr, News.class);
        } else {
            topNewsOfWholeCountryList = this.newsMapper.findTopNewsOfWholeCountryList();
            if (topNewsOfWholeCountryList != null && topNewsOfWholeCountryList.size() > 0) {
                this.redisStringAdapter.set(keyGeneratorOfWholeCountry, (Object)JSON.toJSONString((Object)topNewsOfWholeCountryList));
            }
        }
        topNewsList = this.filterTopNews(topNewsOfAreaList, topNewsOfWholeCountryList);
        NewsMeta newsMeta = new NewsMeta();
        if (topNewsList.size() == 0) {
            return ResultUtil.genSuccessResult((Object)newsMeta);
        }
        ArrayList news4ClientList = Lists.newArrayList();
        topNewsList = this.warp(topNewsList, 2);
        for (News news : topNewsList) {
            News4Client news4Client = new News4Client();
            news4Client.setNews(news);
            news4ClientList.add(news4Client);
        }
        newsMeta.setList((List)news4ClientList);
        newsMeta.setNewsCount(newsMeta.getList().size());
        this.hideInfo(param, newsMeta);
        return ResultUtil.genSuccessResult((Object)newsMeta);
    }

    private List<News> filterTopNews(List<News> topNewsOfAreaList, List<News> topNewsOfWholeCountryList) {
        ArrayList<News> topNewsList = new ArrayList<News>();
        if (CollectionUtils.isNotEmpty(topNewsOfAreaList) && CollectionUtils.isNotEmpty(topNewsOfWholeCountryList)) {
            topNewsList.add(topNewsOfAreaList.get(0));
            topNewsList.add(topNewsOfWholeCountryList.get(0));
            return topNewsList;
        }
        if (CollectionUtils.isNotEmpty(topNewsOfAreaList) && CollectionUtils.isEmpty(topNewsOfWholeCountryList)) {
            topNewsList.addAll(topNewsOfAreaList);
        } else if (CollectionUtils.isNotEmpty(topNewsOfWholeCountryList) && CollectionUtils.isEmpty(topNewsOfAreaList)) {
            topNewsList.addAll(topNewsOfWholeCountryList);
        }
        topNewsList = topNewsList.stream().limit(2L).collect(Collectors.toList());
        return topNewsList;
    }

    private void hideInfo(NewsTopListParam param, NewsMeta meta) {
        if (this.appVersionSupplyService.getPublishState((BasicParam)param).booleanValue()) {
            meta.getList().removeIf(client -> client.getVideos() != null);
            for (News4Client client2 : meta.getList()) {
                if (client2.getNews() == null) continue;
                client2.getNews().setAuthor(null);
                client2.getNews().setAuthorImg(null);
            }
        }
    }
}

