/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.news.domain.UserKindMapper;
import com.bxm.localnews.news.param.UserKindExample;
import com.bxm.localnews.news.service.NewsKindService;
import com.bxm.localnews.news.service.UserKindService;
import com.bxm.localnews.news.vo.UserKind;
import com.bxm.newidea.component.vo.Message;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserKindServiceImpl
implements UserKindService {
    private UserKindMapper userKindMapper;
    private NewsProperties newsProperties;
    private NewsKindService newsKindService;

    @Autowired
    public UserKindServiceImpl(UserKindMapper userKindMapper, NewsProperties newsProperties, NewsKindService newsKindService) {
        this.userKindMapper = userKindMapper;
        this.newsProperties = newsProperties;
        this.newsKindService = newsKindService;
    }

    public Message copyKinds(Long fromUserId, Long toUserId) {
        this.userKindMapper.copyKinds(fromUserId, toUserId);
        this.newsKindService.createUserDefaultKinds(toUserId);
        return Message.build();
    }

    public void resortKinds(final Long userId, Integer[] kindIds, String firstOpenType) {
        this.userKindMapper.deleteByExample(new UserKindExample(){
            {
                this.createCriteria().andUserIdEqualTo(userId);
            }
        });
        if ("1".equals(firstOpenType)) {
            Object[] fixedKindIds = this.getFixedKinds();
            kindIds = (Integer[])ArrayUtils.addAll((Object[])fixedKindIds, (Object[])kindIds);
        }
        if (kindIds != null && kindIds.length > 0) {
            ArrayList<UserKind> userKindList = new ArrayList<UserKind>();
            for (int i = 0; i < kindIds.length; ++i) {
                UserKind userKind = new UserKind();
                userKind.setUserId(userId);
                userKind.setKindId(kindIds[i]);
                userKind.setSortNo(Integer.valueOf(i));
                userKindList.add(userKind);
            }
            this.userKindMapper.batchInsert(userKindList);
        }
    }

    private Integer[] getFixedKinds() {
        Integer[] fixedKindIds = new Integer[]{this.newsProperties.getRecommendKindId(), this.newsProperties.getVideoKindId(), this.newsProperties.getKnowledgeKindId()};
        return fixedKindIds;
    }
}

