/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.news.domain.VideoInformMapper;
import com.bxm.localnews.news.param.VideoBlackParam;
import com.bxm.localnews.news.param.VideoInformParam;
import com.bxm.localnews.news.service.VideoBlackService;
import com.bxm.localnews.news.vo.VideoBlack;
import com.bxm.localnews.news.vo.VideoInform;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VideoBlackServiceImpl
extends BaseService
implements VideoBlackService {
    @Autowired
    private RedisListAdapter redisListAdapter;
    @Autowired
    private VideoInformMapper videoInformMapper;

    @Override
    public Message produceVideoReply(VideoBlackParam videoBlackParam) {
        if (!this.checkParam(videoBlackParam)) {
            return Message.build((boolean)false, (String)"\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25");
        }
        KeyGenerator keyGenerator = RedisConfig.VIDEO_QUEUE.copy().setKey("videoBlackQueue");
        VideoBlack videoBlack = new VideoBlack();
        BeanUtils.copyProperties((Object)videoBlackParam, (Object)videoBlack);
        this.redisListAdapter.leftPush(keyGenerator, new Object[]{videoBlack});
        return Message.build((boolean)true);
    }

    @Override
    public Message informVideo(VideoInformParam param) {
        VideoInform videoInformParam = new VideoInform();
        videoInformParam.setVideoId(param.getVideoId());
        videoInformParam.setUserId(param.getUserId());
        List informList = this.videoInformMapper.selectByModel(videoInformParam);
        if (CollectionUtils.isNotEmpty((Collection)informList)) {
            return Message.build((boolean)false, (String)"\u60a8\u5df2\u4e3e\u62a5\u8fc7");
        }
        VideoInform videoInform = new VideoInform();
        BeanUtils.copyProperties((Object)param, (Object)videoInform);
        videoInform.setId(this.nextSequence());
        this.videoInformMapper.insertSelective(videoInform);
        return Message.build((boolean)true);
    }

    private boolean checkParam(VideoBlackParam videoBlackParam) {
        if (null == videoBlackParam.getVideoId() || null == videoBlackParam.getUserId()) {
            return false;
        }
        return 1 != videoBlackParam.getType() || null != videoBlackParam.getReason();
    }
}

