/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.feign.NewsRecommendFeignService;
import com.bxm.localnews.news.domain.VideoMapper;
import com.bxm.localnews.news.domain.VideoRecommendMapper;
import com.bxm.localnews.news.dto.VideoDto;
import com.bxm.localnews.news.param.VideoQueryParam;
import com.bxm.localnews.news.service.VideoRecommendService;
import com.bxm.localnews.news.vo.VideoRecommend;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class VideoRecommendServiceImpl
extends BaseService
implements VideoRecommendService {
    private static final int MAX_PAGE_SIZE = 12;
    private static final int CACHE_ALARM_VALUE = 24;
    private VideoMapper videoMapper;
    private RedisListAdapter redisListAdapter;
    private VideoRecommendMapper videoRecommendMapper;
    private Condition waitCondition;
    private ReentrantLock lock;
    private NewsRecommendFeignService newsRecommendFeignService;

    @Autowired
    public VideoRecommendServiceImpl(VideoMapper videoMapper, RedisListAdapter redisListAdapter, VideoRecommendMapper videoRecommendMapper, NewsRecommendFeignService newsRecommendFeignService) {
        this.videoMapper = videoMapper;
        this.redisListAdapter = redisListAdapter;
        this.videoRecommendMapper = videoRecommendMapper;
        this.newsRecommendFeignService = newsRecommendFeignService;
    }

    @Override
    public List<VideoDto> execRecommend(VideoQueryParam param) {
        ResponseEntity responseEntity = this.newsRecommendFeignService.recommendVideoList(param.getUserId(), Integer.valueOf(param.getPageSize()));
        List result = (List)responseEntity.getBody();
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            result.forEach(video -> {
                String videoUrl = video.getVideoUrl();
                int fistQuestionMarkIndex = StringUtils.indexOf((CharSequence)videoUrl, (CharSequence)"?") + 1;
                String firstPart = StringUtils.substring((String)videoUrl, (int)0, (int)fistQuestionMarkIndex);
                videoUrl = StringUtils.substring((String)videoUrl, (int)fistQuestionMarkIndex);
                try {
                    String queryPart = URLEncoder.encode(videoUrl, StandardCharsets.UTF_8.name());
                    queryPart = StringUtils.replace((String)queryPart, (String)"%25", (String)"%");
                    queryPart = StringUtils.replace((String)queryPart, (String)"%26", (String)"&");
                    queryPart = StringUtils.replace((String)queryPart, (String)"%3D", (String)"=");
                    video.setVideoUrl(firstPart + queryPart);
                }
                catch (UnsupportedEncodingException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        return result;
    }

    private void markRecommended(List<VideoDto> result, final long userId) {
        if (CollectionUtils.isNotEmpty(result)) {
            new BatchHelper<VideoRecommendMapper, VideoDto>(VideoRecommendMapper.class, result){

                protected int invoke(VideoDto element) {
                    VideoRecommend recommend = new VideoRecommend();
                    recommend.setAddTime(new Date());
                    recommend.setId(Long.valueOf(VideoRecommendServiceImpl.this.nextId()));
                    recommend.setType(Byte.valueOf((byte)1));
                    recommend.setUserId(Long.valueOf(userId));
                    recommend.setVideoId(element.getId());
                    return VideoRecommendServiceImpl.this.videoRecommendMapper.insert(recommend);
                }
            };
        }
    }

    private void callAsyncRecommend(long userId) {
        VideoRecommendService recommendService = (VideoRecommendService)SpringContextHolder.getBean(VideoRecommendService.class);
        recommendService.doAsyncVideoRecommend(userId);
    }

    @Override
    @Async
    public void doAsyncVideoRecommend(long userId) {
        this.logger.debug("\u8fdb\u5165\u5f02\u6b65\u8c03\u7528");
        long current = System.currentTimeMillis();
        KeyGenerator userCacheKey = RedisConfig.VIDEO_RECOMMEND.copy().appendKey((Object)userId);
        List result = this.videoMapper.getUserRecommend(Long.valueOf(userId));
        Object[] videoDtos = result.toArray(new VideoDto[0]);
        this.redisListAdapter.remove(userCacheKey);
        this.redisListAdapter.rightPush(userCacheKey, videoDtos);
        this.redisListAdapter.expire(userCacheKey, 1800L);
        this.logger.debug("\u7ed9[{}]\u8fdb\u884c\u5c0f\u89c6\u9891\u63a8\u8350\u3002\u82b1\u8d39\u65f6\u95f4[{}]", (Object)userId, (Object)(System.currentTimeMillis() - current));
    }
}

