/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.news.domain.VideoMapper;
import com.bxm.localnews.news.domain.VideoReplayLikeMapper;
import com.bxm.localnews.news.domain.VideoReplyMapper;
import com.bxm.localnews.news.dto.VideoReplyDto;
import com.bxm.localnews.news.param.VideoReplyLikeParam;
import com.bxm.localnews.news.param.VideoReplyListQueryParam;
import com.bxm.localnews.news.param.VideoReplyParam;
import com.bxm.localnews.news.service.VideoReplyFacadeService;
import com.bxm.localnews.news.service.VideoReplyService;
import com.bxm.localnews.news.vo.Video;
import com.bxm.localnews.news.vo.VideoReplayLike;
import com.bxm.localnews.news.vo.VideoReply;
import com.bxm.localnews.user.dto.UserBaseInfoWarper;
import com.bxm.localnews.user.service.UserService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class VideoReplyServiceImpl
extends BaseService
implements VideoReplyService,
VideoReplyFacadeService {
    @Autowired
    private VideoReplyMapper videoReplyMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private RedisListAdapter redisListAdapter;
    @Autowired
    private VideoMapper videoMapper;
    @Autowired
    private VideoReplayLikeMapper videoReplayLikeMapper;

    @Override
    public PageWarper<VideoReplyDto> queryByPageSize(VideoReplyListQueryParam param) {
        List videoReplyDtoList = this.videoReplyMapper.queryByPageSize(param);
        for (VideoReplyDto videoReplyDto : videoReplyDtoList) {
            VideoReplyDto sourceReply = videoReplyDto.getSourceReply();
            if (null != sourceReply && this.isLike(param.getUserId(), sourceReply.getId())) {
                sourceReply.setIsLike(Integer.valueOf(1));
            }
            if (!this.isLike(param.getUserId(), videoReplyDto.getId())) continue;
            videoReplyDto.setIsLike(Integer.valueOf(1));
        }
        return new PageWarper(videoReplyDtoList);
    }

    private boolean isLike(Long userId, Long replyId) {
        VideoReplayLike videoReplayLike = this.videoReplayLikeMapper.selectByModel(new VideoReplayLike(replyId, userId));
        return null != videoReplayLike;
    }

    @Override
    public Message replyVideo(VideoReplyParam videoReplyParam) {
        if (!this.checkReplyParam(videoReplyParam)) {
            return Message.build((boolean)false, (String)"\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef");
        }
        VideoReply videoReply = this.convertReply(videoReplyParam);
        this.videoReplyMapper.insertSelective(videoReply);
        Video video = this.videoMapper.selectByPrimaryKey(videoReplyParam.getVideoId());
        if (null != video) {
            Video videoUp = new Video();
            videoUp.setId(videoReplyParam.getVideoId());
            videoUp.setCommentCount(Long.valueOf(video.getCommentCount() + 1L));
            this.videoMapper.updateByPrimaryKeySelective(videoUp);
        }
        return Message.build((boolean)true);
    }

    private boolean checkReplyParam(VideoReplyParam videoReplyParam) {
        return null != videoReplyParam.getUserId() && null != videoReplyParam.getComment() && null != videoReplyParam.getVideoId();
    }

    private VideoReply convertReply(VideoReplyParam param) {
        Long userId = param.getUserId();
        UserBaseInfoWarper userBaseInfoWarper = this.userService.getUserBaseInfo(userId);
        VideoReply videoReply = new VideoReply();
        videoReply.setVideoId(param.getVideoId());
        videoReply.setComment(param.getComment());
        videoReply.setUserId(userId);
        videoReply.setUserName(userBaseInfoWarper.getUserName());
        videoReply.setUserImg(userBaseInfoWarper.getUserImg());
        videoReply.setAddTime(new Date());
        videoReply.setReplyId(param.getReplyId());
        videoReply.setLikeCount(Integer.valueOf(0));
        videoReply.setIsDeleted(Byte.valueOf((byte)0));
        videoReply.setId(this.nextSequence());
        return videoReply;
    }

    @Override
    public Message produceVideoReplyLike(VideoReplyLikeParam videoReplyLikeParam) {
        if (!this.checkLikeParam(videoReplyLikeParam)) {
            return Message.build((boolean)false, (String)"\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef");
        }
        KeyGenerator keyGenerator = RedisConfig.VIDEO_QUEUE.copy().setKey("videoReplyLikeQueue");
        this.redisListAdapter.leftPush(keyGenerator, new Object[]{videoReplyLikeParam});
        this.callAsyncConsume();
        return Message.build((boolean)true);
    }

    private void callAsyncConsume() {
        VideoReplyService videoReplyService = (VideoReplyService)SpringContextHolder.getBean(VideoReplyService.class);
        videoReplyService.videoReplyLikeConsume();
    }

    @Override
    @Async
    public void videoReplyLikeConsume() {
        KeyGenerator keyGenerator = RedisConfig.VIDEO_QUEUE.copy().setKey("videoReplyLikeQueue");
        VideoReplyLikeParam videoReplyLikeWarper = (VideoReplyLikeParam)this.redisListAdapter.rightPop(keyGenerator, VideoReplyLikeParam.class);
        if (null != videoReplyLikeWarper) {
            int count;
            this.logger.info("\u5c0f\u89c6\u9891\u56de\u590d\u70b9\u8d5e\u5f00\u59cb\u6d88\u8d39...");
            int type = videoReplyLikeWarper.getType();
            VideoReply videoReply = this.videoReplyMapper.selectByPrimaryKey(videoReplyLikeWarper.getReplyId());
            if (videoReply != null && (count = this.saveReplyLiKeRecord(videoReply.getId(), videoReplyLikeWarper.getUserId(), type)) > 0) {
                this.logger.debug("\u8bc4\u8bba\u5b9e\u4f53:{}", JSONObject.toJSON((Object)videoReply));
                int likeCount = this.generatorLikeCount(type, videoReply.getLikeCount());
                this.logger.debug("\u70b9\u8d5e\u6570:{}", (Object)likeCount);
                VideoReply videoReplyUp = new VideoReply();
                videoReplyUp.setId(videoReplyLikeWarper.getReplyId());
                videoReplyUp.setLikeCount(Integer.valueOf(likeCount));
                this.videoReplyMapper.updateByPrimaryKeySelective(videoReplyUp);
            }
            this.videoReplyLikeConsume();
        }
    }

    private int generatorLikeCount(int type, int likeCount) {
        if (0 == type) {
            if (likeCount > 0) {
                --likeCount;
            }
        } else {
            ++likeCount;
        }
        return likeCount;
    }

    private int saveReplyLiKeRecord(Long replyId, Long userId, int type) {
        int count = 0;
        VideoReplayLike videoReplayLike = this.videoReplayLikeMapper.selectByModel(new VideoReplayLike(replyId, userId));
        if (type == 1) {
            if (null == videoReplayLike) {
                VideoReplayLike videoReplayLikeNew = new VideoReplayLike();
                videoReplayLikeNew.setAddTime(new Date());
                videoReplayLikeNew.setId(this.nextSequence());
                videoReplayLikeNew.setReplyId(replyId);
                videoReplayLikeNew.setUserId(userId);
                count = this.videoReplayLikeMapper.insert(videoReplayLikeNew);
            }
        } else if (null != videoReplayLike) {
            count = this.videoReplayLikeMapper.deleteByPrimaryKey(videoReplayLike.getId());
        }
        return count;
    }

    public void triggerUpdateInfo(Long userId, String nickname, String headImg) {
        VideoReply videoReply = new VideoReply();
        videoReply.setUserId(userId);
        videoReply.setUserImg(headImg);
        videoReply.setUserName(nickname);
        this.videoReplyMapper.updateByUserIdSelective(videoReply);
    }

    private boolean checkLikeParam(VideoReplyLikeParam videoReplyLikeParam) {
        return null != videoReplyLikeParam.getReplyId() && null != videoReplyLikeParam.getUserId();
    }
}

