/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.news.domain.UserTagConsumeMapper;
import com.bxm.localnews.news.service.WeightService;
import com.bxm.localnews.news.vo.UserTag;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class WeightServiceImpl
extends BaseService
implements WeightService {
    private static final long INTERVAL = 300000L;
    @Resource
    private UserTagConsumeMapper userTagConsumeMapper;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    public void recalcuUserTagWeight(Long userId) {
        Long lastRecommendTime = (Long)this.redisHashMapAdapter.get(RedisConfig.NEWS_RECOMMEND_INTERVAL, userId.toString(), Long.class);
        long current = System.currentTimeMillis();
        if (lastRecommendTime == null || current - lastRecommendTime > 300000L) {
            this.redisHashMapAdapter.put(RedisConfig.NEWS_RECOMMEND_INTERVAL, userId.toString(), (Object)current);
            this.execRecalcu(userId);
        }
    }

    private void execRecalcu(Long userId) {
        List recountTags = this.userTagConsumeMapper.recountUserTags(userId);
        List kindTags = this.userTagConsumeMapper.getKindTags();
        for (UserTag kindTag : kindTags) {
            if (!recountTags.stream().noneMatch(tag -> StringUtils.equals((CharSequence)kindTag.getName(), (CharSequence)tag.getName()))) continue;
            kindTag.setUserId(userId);
            recountTags.add(kindTag);
        }
        boolean removeEmpty = recountTags.removeIf(tag -> tag.getName() == null || "".equals(tag.getName()));
        if (removeEmpty) {
            this.logger.error("[{}]\u63a8\u8350\u7684\u65b0\u95fb\u6807\u7b7e\u5305\u542b\u7a7a\u6807\u7b7e", (Object)userId);
        }
        this.userTagConsumeMapper.deleteUserTag(userId);
        this.batchSave(recountTags);
    }

    private void batchSave(List<UserTag> tags) {
        final Date current = new Date();
        new BatchHelper<UserTagConsumeMapper, UserTag>(UserTagConsumeMapper.class, tags){

            protected int invoke(UserTag element) {
                element.setId(Long.valueOf(WeightServiceImpl.this.nextId()));
                element.setUpdateTime(current);
                return ((UserTagConsumeMapper)this.mapper).insert(element);
            }
        };
    }
}

