/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.strategy;

import com.bxm.localnews.activity.service.MissionService;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.integration.feign.PushMsgSupplyFeignService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.news.domain.NewsRecordMapper;
import com.bxm.localnews.news.domain.NewsStatisticsMapper;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import com.bxm.localnews.news.param.ExecGoldParam;
import com.bxm.localnews.news.strategy.GoldenStrategy;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import com.bxm.localnews.news.vo.NewsRecord;
import com.bxm.localnews.user.service.PayFlowService;
import com.bxm.localnews.user.service.UserAmountService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.PayFlow;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;

public abstract class AbstractGoldenStrategy
implements GoldenStrategy {
    public boolean viewTimeFlag = true;
    public boolean advertShowFlag = true;
    public boolean tabTYpeFlag = true;
    @Resource
    public NewsRecordMapper newsRecordMapper;
    @Resource
    public UserService userService;
    @Resource
    public PayFlowService payFlowService;
    @Resource
    public NewsStatisticsMapper newsStatisticsMapper;
    @Resource
    public RedisStringAdapter redisStringAdapter;
    @Resource
    public MissionService missionService;
    public Integer randomInterval;
    public String configTabType;
    public String configAdvertShow;
    public Integer configViewTime;
    @Resource
    private NewsProperties newsProperties;
    @Resource
    private UserAmountService userAmountService;
    @Resource
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;

    @PostConstruct
    public void init() {
        this.randomInterval = RandomUtils.getRandomTime((String)this.newsProperties.getAwardTimeLag());
        this.configTabType = this.newsProperties.getTabType();
        this.configAdvertShow = this.newsProperties.getShowAdvert();
        this.configViewTime = this.newsProperties.getViewTime();
    }

    @Override
    public void commonJudgment(ExecGoldCalParam execGoldParam) {
        Long newsId = execGoldParam.getNewsId();
        Long userId = execGoldParam.getUserId();
        Integer viewTime = execGoldParam.getViewTime();
        String advertShow = execGoldParam.getAdvertShow();
        String isRecommendNews = execGoldParam.getIsRecommendNews();
        NewsGoldMeta newsGoldMeta = execGoldParam.getNewsGoldMeta();
        User user = this.userService.selectByPrimaryKey(userId);
        this.newsStatisticsMapper.addActiveViews(newsId);
        Date today = new Date();
        if (this.isGuestUser(user)) {
            newsGoldMeta.setGoldType((byte)1);
        } else {
            NewsRecord nRecord = this.newsRecordMapper.getByIds(newsId, userId, null);
            if (nRecord != null && nRecord.getGetGold() == 2) {
                this.doUpdateRecord(newsGoldMeta, viewTime, nRecord);
            } else {
                if (nRecord != null && nRecord.getActiveView() != 2) {
                    this.doUpdateRecord(newsGoldMeta, viewTime, nRecord);
                } else if (nRecord == null) {
                    nRecord = this.generatorNewsRecord((ExecGoldParam)execGoldParam);
                    this.newsRecordMapper.insertSelective(nRecord);
                }
                nRecord.setUpdateTime(today);
                nRecord.setCheckTime(viewTime);
                nRecord.setAdViewType(Byte.valueOf(advertShow));
                boolean suspendFlag = this.isSuspend(userId);
                newsGoldMeta.setGoldType((byte)1);
                execGoldParam.setNewsGoldMeta(newsGoldMeta);
                execGoldParam.setnRecord(nRecord);
                execGoldParam.setSuspendFlag(suspendFlag);
                this.calculator(execGoldParam);
            }
        }
    }

    protected boolean isSuspend(Long userId) {
        NewsRecord record = this.newsRecordMapper.getOneByUserId(userId, (byte)2);
        if (record != null) {
            Long time = record.getGetGoldTime().getTime() + (long)(record.getIntervalNum() * 1000);
            Long time2 = System.currentTimeMillis();
            return time <= time2;
        }
        return true;
    }

    protected void addGold(Long userId, Long newsId, KeyGenerator key, Integer number, TaskEnum taskTypeEnum, Integer rewardNum, Boolean flag) {
        PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)taskTypeEnum.getType(), (Byte)10, (String)newsId.toString());
        this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, new BigDecimal(rewardNum), flag.booleanValue());
        this.redisStringAdapter.set(key, (Object)(number - 1), (long)DateUtils.getCurSeconds());
        if (number == 1) {
            this.missionService.compleDailyTask(userId, Byte.valueOf(taskTypeEnum.getType()));
            String taskType = "\u65e5\u5e38\u4efb\u52a1";
            String title = "\u5b8c\u6210" + taskType + ":" + taskTypeEnum.getDesc();
            String content = "\u606d\u559c" + title + ",\u5171\u8ba1\u83b7\u5f97" + 200 + "\u91d1\u5e01";
            PushMessage pushMessage = PushMessage.build();
            pushMessage.setTitle(title);
            pushMessage.setContent(content);
            pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
            pushMessage.setPayloadInfo(PushPayloadInfo.build((PushMessageEnum)taskTypeEnum.getPushMessageEnum()));
            this.pushMsgSupplyFeignService.pushMsg(pushMessage);
        }
    }

    NewsRecord generatorNewsRecord(ExecGoldParam execGoldParam) {
        Date today = new Date();
        NewsRecord nRecord = new NewsRecord();
        nRecord.setNewsId(execGoldParam.getNewsId());
        nRecord.setUserId(execGoldParam.getUserId());
        nRecord.setUpdateTime(today);
        nRecord.setCheckTime(execGoldParam.getViewTime());
        nRecord.setGetGold(Byte.valueOf((byte)1));
        nRecord.setAddTime(today);
        nRecord.setLastLocation(execGoldParam.getTabType());
        nRecord.setAdViewType(Byte.valueOf(execGoldParam.getAdvertShow()));
        nRecord.setActiveView(Byte.valueOf((byte)2));
        return nRecord;
    }

    private boolean isGuestUser(User user) {
        return user == null || user.getState() == 0;
    }

    private boolean isRecommondNews(String isRecommendNews) {
        return StringUtils.equals((CharSequence)"2", (CharSequence)isRecommendNews);
    }

    private void doUpdateRecord(NewsGoldMeta newsGoldMeta, Integer viewTime, NewsRecord nRecord) {
        newsGoldMeta.setGoldType((byte)1);
        nRecord.setUpdateTime(new Date());
        if (viewTime > nRecord.getCheckTime()) {
            nRecord.setCheckTime(viewTime);
        }
        this.newsRecordMapper.updateByPrimaryKeySelective(nRecord);
    }

    private void execRecommendGold(Long newsId, Long userId, NewsGoldMeta newsGoldMeta) {
        Integer numberFormat;
        KeyGenerator key = this.getReadNewsCacheKey(userId);
        String number = this.redisStringAdapter.getString(key);
        newsGoldMeta.setGoldType((byte)1);
        if (this.isNumberNotExsit(number)) {
            numberFormat = 3;
            this.redisStringAdapter.set(key, (Object)number, (long)DateUtils.getCurSeconds());
        } else {
            numberFormat = Integer.valueOf(number);
        }
        if (numberFormat > 0) {
            this.addGold(userId, newsId, key, numberFormat, TaskEnum.READ_PUSH_ARTICLE, 10, false);
            newsGoldMeta.setGoldType((byte)2);
            newsGoldMeta.setGoldNum(10);
        }
    }

    private KeyGenerator getReadNewsCacheKey(Long userId) {
        KeyGenerator key = RedisConfig.RECOMMEND_NEWS_READ.copy();
        key.setKey(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
        return key;
    }

    boolean checkViewTimeFlag(Integer configViewTime, Integer viewTime) {
        return viewTime > configViewTime;
    }

    boolean checkAdvertShowFlag(String configAdvertShow, String advertShow) {
        return !"2".equals(configAdvertShow) || "2".equals(advertShow);
    }

    boolean checkTabTYpeFlag(String configTabType, String tabType) {
        return !"2".equals(configTabType) || "2".equals(tabType);
    }

    protected Integer initReadNum(KeyGenerator key) {
        Integer number = this.newsProperties.getReadNumAwardCount();
        this.redisStringAdapter.set(key, (Object)number, (long)DateUtils.getCurSeconds());
        return number;
    }

    protected boolean isNumberNotExsit(String number) {
        return StringUtils.isEmpty((CharSequence)number);
    }

    protected boolean isNumberRemained(Integer number) {
        return null != number && number > 0;
    }
}

