/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.strategy;

import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.news.domain.NewsRecordMapper;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import com.bxm.localnews.news.strategy.AbstractGoldenStrategy;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import com.bxm.localnews.news.vo.NewsRecord;
import com.bxm.localnews.user.service.UserAmountService;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class GoldCalculatorOfVideo
extends AbstractGoldenStrategy {
    @Resource
    private NewsRecordMapper newsRecordMapper;
    @Resource
    private UserAmountService userAmountService;

    @Override
    public void calculator(ExecGoldCalParam execGoldCalParam) {
        Long reward;
        Long newsId = execGoldCalParam.getNewsId();
        Long userId = execGoldCalParam.getUserId();
        Integer viewTime = execGoldCalParam.getViewTime();
        String advertShow = execGoldCalParam.getAdvertShow();
        NewsGoldMeta newsGoldMeta = execGoldCalParam.getNewsGoldMeta();
        NewsRecord nRecord = execGoldCalParam.getnRecord();
        byte goldType = 1;
        if (this.checkLegalWithFlag(this.viewTimeFlag, this.advertShowFlag, execGoldCalParam.isSuspendFlag()) && (reward = this.missionService.completeTask(userId, TaskEnum.TASK_VIDEO_READ, newsId.toString())) != null) {
            goldType = 2;
            nRecord.setGetGoldTime(new Date());
            nRecord.setIntervalNum(this.randomInterval);
            newsGoldMeta.setGoldNum(reward.intValue());
            newsGoldMeta.setTotalGold(this.userAmountService.selectGoldBalanceByUserId(userId));
        }
        nRecord.setGetGold(Byte.valueOf(goldType));
        nRecord.setUserId(userId);
        this.newsRecordMapper.updateByPrimaryKeySelective(nRecord);
        newsGoldMeta.setTaskName(TaskEnum.TASK_VIDEO_READ.getDesc());
        newsGoldMeta.setGoldType(goldType);
    }

    @Override
    public boolean support(int newsType) {
        return 3 == newsType;
    }

    private Integer getConfigTime(News news) {
        String videoScal = "0";
        double dou = Double.valueOf(videoScal) * (double)news.getVideoLen().intValue();
        return (int)Math.floor(dou);
    }

    private boolean checkLegalWithFlag(boolean viewTimeFlag, boolean advertShowFlag, boolean isSuspendFlag) {
        return viewTimeFlag && advertShowFlag && isSuspendFlag;
    }
}

