package com.bxm.localnews.news.Relation.impl;

import com.bxm.localnews.dto.MerchantUserDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.Relation.MerchantRelationService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @Author: pf.w
 * @Date: 2020/7/16 19:10
 */

@Service
@Log4j2
public class MerchantRelationServiceImpl implements MerchantRelationService {

    @Autowired
    RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private RedisStringAdapter redisStringAdapter;


    /**
     * 用户关联的认证商家
     */
    public static KeyGenerator MERCHANT_USER_KEY = DefaultKeyGenerator.build().setModule("merchant").setGroup("user").appendKey("merchant0k");
    public static KeyGenerator USER_CACHE_INFO =  DefaultKeyGenerator.build("user", "cache", "info").copy();
    @Override
    public MerchantUserDTO getRelationMerchantAndIsVip(Long userId) {
        log.debug("relation merchant userId : {}",userId);
        if (null == userId) {
            return null;
        }

        MerchantUserDTO info = redisHashMapAdapter.get(MERCHANT_USER_KEY, userId.toString(), MerchantUserDTO
                .class);

        if(log.isDebugEnabled()){
            log.debug("relation merchant userId : {} info :{}",userId,info);
        }

        return Objects.nonNull(info) ? info : null;
    }

    @Override
    public Integer isVip(Long userId) {
        if(null == userId){
            return 0;
        }
        return userIntegrationService.checkUserIsVip(userId) ? 1 : 0;
    }
}
