package com.bxm.localnews.news.convert.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.Relation.MerchantRelationService;
import com.bxm.localnews.news.config.UserProperties;
import com.bxm.localnews.news.convert.Converter;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.VideoMapper;
import com.bxm.localnews.news.enums.NewsConstant;
import com.bxm.localnews.news.enums.ReplyStatusEnum;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.param.NewsReplyAddParam;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.service.BaseService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Objects;

@Component
public class NewsReplyConver extends BaseService implements Converter<NewsReplyAddParam,NewsReply> {

    private final UserIntegrationService userIntegrationService;
    private final UserProperties userProperties;
    private final VideoMapper videoMapper;
    private final NewsReplyMapper newsReplyMapper;
    private final ForumPostMapper forumPostMapper;
    private final MerchantRelationService merchantRelationService;

    @Autowired
    public NewsReplyConver(UserIntegrationService userIntegrationService,
                           UserProperties userProperties,
                           VideoMapper videoMapper,
                           NewsReplyMapper newsReplyMapper,
                           ForumPostMapper forumPostMapper,
                           MerchantRelationService merchantRelationService

    ){
        this.userIntegrationService = userIntegrationService;
        this.userProperties = userProperties;
        this.videoMapper = videoMapper;
        this.newsReplyMapper = newsReplyMapper;
        this.forumPostMapper = forumPostMapper;
        this.merchantRelationService = merchantRelationService;
    }
    @Override
    public NewsReply convert(NewsReplyAddParam newsReplyAddParam) {
        NewsReply newsReply = new NewsReply();
        BeanUtils.copyProperties(newsReplyAddParam, newsReply);
        newsReply.setStatus(ReplyStatusEnum.IS_SHOW.getCode());
        newsReply.setLikeCount(0);
        newsReply.setRootId(0L);
        newsReply.setLevel((byte) 0);
        newsReply.setAddTime(new Date());
        newsReply.setInteractiveCount(0);
        newsReply.setId(nextSequence());
        //得到用户的头像昵称
        if (null != newsReplyAddParam.getUserId()) {
            UserBean userBean = userIntegrationService.selectUserFromCache(newsReplyAddParam.getUserId());
            if (StringUtils.isBlank(userBean.getHeadImg()) || StringUtils.isBlank(userBean.getNickname())){
                logger.info("评论用户头像或昵称为空,userInfo={}", JSON.toJSONString(userBean));
            }
            newsReply.setHeadImg(StringUtils.isBlank(userBean.getHeadImg()) ? userProperties.getDefaultHeadImgUrl() : userBean.getHeadImg());
            newsReply.setUserNickname(userBean.getNickname());
            newsReply.setIsVip(merchantRelationService.isVip(userBean.getId()));
        }
        //如果不传type默认是新闻类型
        if (newsReplyAddParam.getType() == null) {
            newsReply.setType(ReplyTypeEnum.NEWS_REPLY.getCode());
        }
        //判断id来自于新闻、小视频、还是帖子，真是操了
        String idStr = newsReplyAddParam.getNewsId().toString();
        if (idStr.startsWith("4") && idStr.length() == 16) {
            newsReply.setType(ReplyTypeEnum.POST_REPLY.getCode());
        } else if (videoMapper.exists(newsReplyAddParam.getNewsId()) > 0) {
            newsReply.setType(ReplyTypeEnum.VIDEO_REPLY.getCode());
        } else {
            newsReply.setType(ReplyTypeEnum.NEWS_REPLY.getCode());
        }
        //马甲号发帖标识
        Boolean vestPost = false ;
        //如果是对新闻的直接评论则设置父评论信息为null
        if (newsReply.getParentId() == null || newsReply.getParentId() == 0) {
            newsReply.setRootId(0L);
            newsReply.setParentId(0L);
            newsReply.setLevel(NewsConstant.REPLY_LEVEL_0);
            //根评论且发帖用户是马甲号时,马甲号发帖时 马甲号发帖标识 设置为true;
            if (newsReplyAddParam.getType() == ReplyTypeEnum.POST_REPLY.getCode()){
                ForumPostVo forumPostVo = forumPostMapper.selectByPrimaryKey(newsReplyAddParam.getNewsId());
                UserBean postVoUser= userIntegrationService.selectUserFromCache(forumPostVo.getUserId());
                vestPost = Objects.nonNull(postVoUser) && postVoUser.getState() == 3 ;
            }
        } else {
            NewsReply newsReplyDb = newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getParentId(), newsReplyAddParam.getNewsId());
            if (newsReplyDb != null) {
                newsReply.setRootId(newsReplyDb.getRootId());
                Byte level = newsReplyDb.getLevel();
                if (level == 0) {
                    newsReply.setLevel(NewsConstant.REPLY_LEVEL_1);
                    newsReply.setRootId(newsReplyDb.getId());
                } else {
                    newsReply.setLevel(NewsConstant.REPLY_LEVEL_2);
                    newsReply.setRootId(newsReplyDb.getRootId());
                }
            }
        }
        if (Objects.nonNull(newsReplyAddParam.getParentUserId())){
            UserBean parentUser = userIntegrationService.selectUserFromCache(newsReplyAddParam.getParentUserId());
            vestPost = vestPost || (Objects.nonNull(parentUser) && Objects.nonNull(parentUser.getState()) && parentUser.getState() == 3 );

        }
        //正式用户对马甲号用户回复时,或对马甲号发帖评论时添加未互动标记
        if(vestPost){
            newsReply.setVestInteract((byte) 0);
        }

        return newsReply;
    }

}
