package com.bxm.localnews.news.param;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.enums.DisplayAreaEnum;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostTopicVO;
import com.google.common.collect.Lists;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * 帖子额外参数填充
 * @author liujia
 * @date 2020/05/14 09:25
 */
@Data
@Builder
public class ForumPostFillContext {
    /**
     * 原始帖子信息，必须提供
     */
    private List<ForumPostVo> data;

    /**
     * 当前请求的用户ID，可以为空，用于处理一些与用户逻辑相关的内容
     */
    private Long userId;

    /**
     * 地区编码，可以为空
     */
    private String areaCode;

    /**
     * 是否填充标题，因为历史需求，有一部分帖子是没有标题的
     * 根据{产品：康文静}的需求从内容中抽取部分作为标题
     * 历史默认都是加载，提供了默认值
     */
    @Builder.Default
    private boolean fillTitle = true;

    /**
     * 是否填充话题信息
     * 历史默认都是加载，提供了默认值
     */
    @Builder.Default
    private boolean loadTopic = true;

    /**
     * 帖子列表中涉及到的话题列表，loadTipic为true时加载
     */
    @Builder.Default
    private List<PostTopicVO> postTopicVoList = Lists.newArrayList();

    /**
     * 是否加载评论,历史默认都是加载，提供了默认值
     */
    @Builder.Default
    private boolean loadComment = true;

    /**
     * 是否加载用户的点赞状态，如果为true userId必须提供
     * 历史默认都是加载，提供了默认值
     */
    @Builder.Default
    private boolean loadLikeStatus = true;

    /**
     * 用户点赞信息列表，如果loadLikeStatus为true时加载
     */
    @Builder.Default
    private List<Long> postLikeIdList = Lists.newArrayList();

    /**
     * 是否加载用户的收藏状态，如果为true userId必须提供
     * 历史默认都是加载，提供了默认值
     */
    @Builder.Default
    private boolean loadCollectStatus = true;

    /**
     * 用户收藏内容ID列表，loadCollectStatus为ture时加载
     */
    @Builder.Default
    private List<Long> postCollectIdList = Lists.newArrayList();

    /**
     * 显示位置
     */
    private DisplayAreaEnum displayArea;

    /**
     * areaCode对应的地区信息
     */
    private LocationDTO location;
}
