package com.bxm.localnews.news.service;

import com.bxm.localnews.news.dto.BaseForumPostDTO;
import com.bxm.localnews.news.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.news.dto.InteractRankInfo;
import com.bxm.localnews.news.vo.*;

import java.util.Date;
import java.util.List;

/**
 * 帖子相关提供服务接口
 * @author liujia
 */
public interface ForumPostFacadeService {

    /**
     * 获取帖子的简略信息
     * @param postId   帖子ID
     * @param userId   当前访问用户ID
     * @param areaCode 请求用户的所属区域编码
     * @return 帖子简略信息
     */
    ForumPostBriefInfoDto getBriefInfo(Long postId, Long userId, String areaCode,String ip);

    /**
     * 获取帖子的简略信息
     * @param postId 帖子ID
     * @return 帖子简历信息
     */
    ForumPostBriefInfoDto getBriefInfo(Long postId);

    /**
     * 获得用户的发帖数量
     *
     * @param userId
     * @return
     */
    Integer getPublishPostNum(Long userId);

    /**
     * 根据阅读数限制获取发布时间在一天内的帖子
     *
     * @param clickCountLimit
     * @return
     */
    List<ForumPostClickCountVo> getRecentPosts(Integer clickCountLimit);

    /**
     * 根据阅读数限制获取发布时间在一天内的帖子(被推到推荐库的)
     *
     * @param clickCountLimit
     * @return
     */
    List<ForumPostClickCountVo> getRecentRecommendPosts(Integer clickCountLimit);

    /**
     * 批量增加帖子阅读数
     *
     * @param forumPostClickList
     */
    void batchAddClick(List<ForumPostClickCountVo> forumPostClickList);

    /**
     * 帖子视频转码
     *
     * @param id
     * @param postImgList
     */
    void transcodePostVideo(Long id, List<PostImgVo> postImgList);

    /**
     * 批量替换帖子视频地址
     *
     * @param transcodeMapList
     */
    void batchUpdatePostVideo(List<TranscodeMap> transcodeMapList);

    /**
     * 获取用户七天内发布的最新的一条帖子
     * @param userId
     * @return
     */
    BaseForumPostDTO getForumPostByUserId(Long userId, Long targetUserId);

    /**
     * 批量获取用户帖子图片
     *
     * @param userIdList
     * @param currentUserId
     * @return
     */
    List<UserImgVo> batchGetUserImg(List<Long> userIdList, Long currentUserId);

    /**
     * 批量缓存一定时间内更新的用户帖子图片、视频
     *
     * @return
     */
    void cacheUserPostImg(Date startTime);

    /**
     * 根据id获取话题
     * @param id
     * @return
     */
    TopicFacadeVO getTopicById(Long id);

    /**
     * 根据帖子id获取帖子信息
     * @param id ： 帖子id
     * @return 帖子详情
     */
    ForumPostVo getForumPostById(Long id);

    /**
     * 发帖榜  V3.3.0
     * @param areaCode
     * @return
     */
    List<ForumRankVo> forumRank(String areaCode,List<Long> userIds);

    /**
     * 发帖榜个人热度 V3.3.0
     * @param userId
     * @return
     */
    ForumPostRankForUserVo forumRankForUser(Long userId);

    /**
     * 获取评论排行  V3.3.1
     * @param areaCode
     * @param limitNum
     * @return
     */
    List<InteractRankInfo> getInteractRankInfo(String areaCode, int limitNum, List<Long> userIds);

    /**
     * 获取个人评论数
     * @param userId
     * @return
     */
    Integer replyNumForUser(Long userId);
}
