package com.bxm.localnews.news.service;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.dto.CalculatePostDTO;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.dto.PostLikeDto;
import com.bxm.localnews.news.vo.ForumPostLike;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostImgVo;

import java.util.List;

/**
 * 社区相关静态数据服务
 */
public interface ForumPostStatisticService {

    /**
     * 更新帖子点赞数量
     *
     * @param type
     * @param postId
     */
    void doUpdateForumInfo(int type, Long postId);

    /**
     * 对帖子的消费次数进行消费，对帖子的次数进行增加
     *
     * @param ids
     * @param userId
     */
    void doConsumeRecommendedCount(List<Long> ids, Long userId);

    /**
     * 对帖子的点击次数进行消费，对帖子的次数进行增加
     *
     * @param postId
     * @param userId
     */
    void doConsumeClickCount(Long postId, Long userId);

    /**
     * 对帖子的有效阅读次数进行消费，对帖子的次数进行增加
     *
     * @param postId
     * @param userId
     */
    void doConsumeActiveViewCount(Long postId, Long userId);

    /**
     * 定时修改帖子为显示的点赞数据
     *
     * @return
     */
    int doRefreshLikeInfo();

    /**
     * 点赞定时任务批量发送消息
     *
     * @param postLikes
     */
    void asyncSendPostLikeMessage(List<ForumPostLike> postLikes);

    /**
     * 得到帖子鲜花数量
     *
     * @param isBrilliant
     * @return
     */
    int getPostLikeConsume(Integer isBrilliant);

    /**
     * 帖子点赞异步执行
     *
     * @param userId
     * @param postId
     * @param type     1点赞,0取消点赞
     * @param areaCode
     * @param isOld
     * @param platform
     */
    void doAsyncLikePost(Long userId, Long postId, int type, String areaCode, byte isOld, Integer platform);

    /**
     * 封装点赞返回实体
     *
     * @param postLikeDto
     * @param userId
     * @param userId1
     * @param postLikeConsume
     */
    void fillPostLikeDto(PostLikeDto postLikeDto, Long userId, Long userId1, int postLikeConsume);

    /**
     * 判断帖子是否开启占位符，若有，则替换
     *
     * @param postVo 帖子
     * @param locationDTO 地区
     * @return 是否开启
     */
    Boolean judgeEnablePlaceholder(ForumPostVo postVo, LocationDTO locationDTO);

    /**
     * 查看详情时异步调用
     *
     * @param userId
     * @param postId
     * @param shareUserId
     * @param platform
     * @param forumPostVo
     */
    void doAsyncReadPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo,String ip);

    /**
     * 组装首页feed流帖子展示的封面
     *
     * @param forumPostVo
     */
    void exchangeCoverPost(ForumPostVo forumPostVo);

    /**
     * 组装本地圈feed流帖子展示的封面
     *
     * @param forumPostVo
     */
    void exchangeDetailPost(ForumPostVo forumPostVo);

    /**
     * 获得本地圈feed流的帖子封面
     * 1.取图片封面
     * 2.取图片内容
     *
     * @param imgList
     * @return
     */
    List<PostImgVo> getDetailFromPost(List<PostImgVo> imgList);

    /**
     * 获得首页feed流帖子的封面
     * 1.取视频封面
     * 2.取图片封面
     * 3.取图片内容
     *
     * @param coverList
     * @param imgList
     * @return
     */
    List<PostImgVo> getCoverFromPost(String coverList, List<PostImgVo> imgList, Byte coverSelect);

    /**
     * 帖子点赞用户头像,用户昵称同步
     */
    void doSyncPostLikeInfo();

    /**
     * 帖子点赞概览,评论概览信息同步
     */
    void doSyncPostStaticInfo();

    /**
     * 统计客户端最近半小时发帖情况
     *
     * @return
     */
    List<CalculatePostDTO> calculatePostCount();

    /**
     * 计算参与人数
     */
    void calcParticipantsNum();

    /**
     * 完成首次发帖任务以及发帖任务
     *
     * @param forumPostVo
     * @return
     */
    NewsCompleTaskDTO completeTask(ForumPostVo forumPostVo);

    /**
     * 增加点赞数
     *
     * @param forumPostVo
     * @param num
     */
    void addPostLike(ForumPostVo forumPostVo, Integer num);

    /**
     * 帖子增加马甲号评论
     *
     * @param forumPostVo
     * @return
     */
    void addPostReply(ForumPostVo forumPostVo);

    /**
     * 记录帖子阅读信息
     *
     * @param userId
     * @param postId
     * @param shareUserId
     * @param platform
     * @param forumPostVo
     */
    void doRecordForumPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo);

    /**
     * 异步调用
     * 增加用户发布数
     *
     * @param forumPostVo
     */
    void doAsyncAddPublishNum(ForumPostVo forumPostVo);

    /**
     * 更新帖子中用户头像以及昵称
     *
     * @param userId
     * @param nickname
     * @param headImg
     */
    void doTriggerUpdateInfo(Long userId, String nickname, String headImg);

    /**
     * 用户更改信息后同步帖子点赞表的用户头像,用户昵称字段
     *
     * @param userId
     * @param nickname
     * @param headImg
     */
    void doTriggerUpdateForumPostLikeInfo(Long userId, String nickname, String headImg);

    /**
     * 对content的处理
     * 首先拼接编辑寄语，然后拼接板块后语
     * 对客户端的信息进行水印处理以及用h5代码包装
     * 对h5返回的信息只需要处理水印
     *
     * @param forumPostVo 帖子信息
     * @param basicParam  基础参数
     */
    void generateForumPostContent(ForumPostVo forumPostVo, BasicParam basicParam, String ip, Long userId, String areaCode);

}
