package com.bxm.localnews.news.service;

import java.util.List;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.dto.MyCollectDTO;
import com.bxm.localnews.news.dto.NewsCollectDTO;
import com.bxm.localnews.news.param.NewsCollectPageParam;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * Created by Administrator on 2018/2/23 0023.
 */
public interface NewsCollectService {

    /**
     * 获取收藏的新闻列表
     *
     * @param userId
     * @param page
     * @return
     */
    List<NewsCollectDTO> queryList(Long userId, MPage page);

    /**
     * 收藏或取消收藏新闻
     *
     * @param newsCollect
     * @return
     */
    Json collectNews(NewsCollect newsCollect,Integer platform,String areaCode);

    /**
     * 得到收藏列表（包含新闻、帖子、小纸条）
     * @param newsCollectPageParam
     * @return
     */
    PageWarper<MyCollectDTO> listCollect(NewsCollectPageParam newsCollectPageParam);

}
