package com.bxm.localnews.news.service;

import java.util.List;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.dto.NewsLikeDTO;
import com.bxm.localnews.news.dto.PostLikeDto;
import com.bxm.localnews.news.param.NewsLikeParam;
import com.bxm.localnews.news.param.NewsParam;
import com.bxm.localnews.news.vo.*;

/**
 * Created by hsq 10:31 2018/2/8
 */
public interface NewsService {

    /**
     * 获取新闻详情页跳转地址
     *
     * @param id
     * @param userId
     * @param type   1：详情地址  2：分享地址 3：搜索文章查看详情地址 4:广告分享链接（newsId为广告id）
     * @return
     */
    Json<NewsUrlVo> getUrlAddress(Long id, Long userId, Byte type);

    /**
     * 新闻视频推荐
     *
     * @param newsId
     * @param userId
     * @param size
     * @return
     */
    Json<List<News4Client>> listRecommendNews(Long newsId, Long userId, Integer size, String areaCode,Integer platform);

    /**
     * 组图推荐
     *
     * @param newsId
     * @return
     */
    Json<List<News4Client>> listRecommendNews4ImgNews(Long newsId);


    /**
     * 新闻详情
     *
     * @param newsParam
     * @return
     */
    Json<NewsDetailVO> getNewsDetail(NewsParam newsParam, BasicParam basicParam);

    /**
     * 完成任务并推送消息
     *
     * @param newsParam
     * @param newsVO
     */
    void completeTaskAndPush(NewsParam newsParam, NewsVO newsVO);

    /**
     * 阅读文章返回时调用
     *
     * @param newsId
     * @param userId
     * @param viewTime   阅读时间
     * @param tabType    是否读取到文章末尾 1：否   2：是
     * @param advertShow 广告位是否展示出来 1：否  2：是
     * @return
     */
    Json doRecordNews(Long newsId, Long userId, Integer viewTime, String tabType, String advertShow);

    /**
     * 获取热门搜索标题
     *
     * @return
     */
    Json<List<NewsSearchWord>> listHotTitle();

    /**
     * 视频分类
     *
     * @return
     */
    Json<List<NewsKind>> listNewsKinds();

    /**
     * 无效视频重新抓取
     *
     * @param newsId
     * @return
     */
    Json<FailVideo> getFailVideo(Long newsId);

    /**
     * 点击次数+1
     *
     * @param newsId
     * @return
     */
    Json doSaveNewsClick(Long newsId);

    /**
     * 填充新闻列表的额外参数
     *
     * @param userId 当前推荐用户
     * @param result 推荐结果
     */
    void fillExtInfo(Long userId, List<News> result, String areaCode);

    /**
     * 封面图转 封面
     * @param coverStr
     * @return
     */
    List<PostImgVo> getCoverByCoverStr(String coverStr);

    /**
     * 根据新闻id获取详情,由客户端调用
     *
     * @param newsParam
     * @param basicParam
     * @return
     */
    Json<NewsDetailVO> getNewsDetailById(NewsParam newsParam, BasicParam basicParam,String ip);

    /**
     * 组装新闻的封面
     * @param news
     */
    void exchangeCoverNews(News news);

    void exchangeDetailNews(News news);

    /**
     * 获取封面的图片
     * @param coverList
     * @param imgUrl
     * @param videoList
     * @param coverSelect 封面选择
     * @return
     */
    List<PostImgVo> getCoverFromNews(String coverList, String imgUrl, List<PostImgVo> videoList,Byte coverSelect);

    /**
     * 获取内容的图片
     *
     * @param imgUrl
     * @param videoList
     * @return
     */
    List<PostImgVo> getDetailFromNews(String imgUrl, List<PostImgVo> videoList);

    /**
     * 新闻点赞
     *
     * @param newsLikeParam
     * @return
     */
    PostLikeDto doNewsLike(NewsLikeParam newsLikeParam);

    /**
     * 新闻点赞列表
     *
     * @param newsId
     * @return
     */
    List<NewsLikeDTO> listPostLikeByNewsId(Long newsId);

    /**
     * 判断新闻是否开启占位符
     *
     * @param newsVo
     * @param location
     * @return
     */
    News judgeEnablePlaceholder(News newsVo, LocationDTO location);

    /**
     * 更新新闻点赞表的信息
     * @param userId
     * @param nickname
     * @param headImg
     * @return
     */
	void doTriggerUpdateNewsLikeInfo(Long userId, String nickname, String headImg);
}
