package com.bxm.localnews.news.service;

/**
 * 敏感词服务接口，用于判断提交的内容中是否存在敏感词
 * 用于评论提交、发帖等用途，后续可扩展不同的题库对应不同的处理策略
 * @author liujia
 */
public interface SensitiveWordService {

    /**
     * 判断字符串中是否存在敏感词
     * @param source 原始字符串
     * @return true表示存在敏感词
     */
    boolean contains(String source);

    /**
     * 重新加载敏感词库
     */
    void reload();
}
