package com.bxm.localnews.news.service;

import com.bxm.localnews.news.dto.ShareContentDTO;

import java.util.List;

/**
 * 获取头部的帖子信息服务，用于分享或显示排行
 * @author liujia
 * @date 2020/05/12 20:32
 */
public interface ShareRankService {

    /**
     * 获取地区编码对应的阅读量最高的新闻或者帖子
     * @param areaCode 地区编码
     * @return 分享的内容数据
     */
    List<ShareContentDTO> getTopPost(String areaCode);

    /**
     * 刷新地区的头部帖子缓存
     * 根据缓存中的键值（地区编码）获取地区阅读量排行靠前的帖子数据更新到缓存中
     */
    void refreshCache();
}
