package com.bxm.localnews.news.service;

/**
 * 用户定位变更同步处理
 * 记录用户变更后的位置，主要用于统计排行榜
 *
 * @author pf.w
 * @date 2020/6/23 14:38
 */
public interface UserLocationSyncService {

    /**
     * 同步用户定位，数据来自消息队列的定义
     *
     * @param userId   用户ID
     * @param areaCode 变更后的地区编码
     */
    void syncUserLocation(Long userId, String areaCode);
}
