package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.*;
import com.bxm.localnews.news.config.ClientConfigProperties;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.config.ReplyConfigProperties;
import com.bxm.localnews.news.constant.AppConst;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.*;
import com.bxm.localnews.news.dto.CalculatePostDTO;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.dto.PostLikeDto;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.enums.TaskEnum;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.service.AssemblyService;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.vo.*;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.localnews.vo.VirtualUserInfo;
import com.bxm.newidea.component.redis.HyperLogLogAdapter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.IPUtil;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.google.common.collect.Lists;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

@Service
@Log4j2
public class ForumPostStatisticServiceImpl extends BaseService implements ForumPostStatisticService {

    @Resource
    private ForumTopicMapper forumTopicMapper;

    @Resource
    private NewsReplyMapper newsReplyMapper;

    @Resource
    private UserReplyMapper userReplyMapper;

    @Resource
    private ForumPostRecordMapper forumPostRecordMapper;

    @Resource
    private ForumPostLikeMapper forumPostLikeMapper;

    @Resource
    private ForumPostMapper forumPostMapper;

    @Resource
    private UserIntegrationService userIntegrationService;

    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;

    @Resource
    private LocationIntegrationService locationIntegrationService;

    @Resource
    private MissionIntegrationService missionIntegrationService;

    @Resource
    private MessageService messageService;

    @Resource
    private BizLogIntegrationService bizLogIntegrationService;

    @Resource
    private ClientConfigProperties clientConfigProperties;

    @Resource
    private NewsProperties newsProperties;

    @Resource
    private ReplyConfigProperties replyConfigProperties;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private AssemblyService assemblyService;

    @Resource
    private HyperLogLogAdapter hyperLogLogAdapter;

    @Override
    public void doUpdateForumInfo(int type, Long postId) {
        //更新帖子点赞数量
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setId(postId);
        forumPostStatistic.setLikeCount(type == 0 ? -1 : 1);

        //维护帖子点赞概览信息
        List<ForumPostLike> forumPostLikes = forumPostLikeMapper.selectByPostIdAndOrderByAddtime(postId);
        if (CollectionUtils.isNotEmpty(forumPostLikes)) {
            forumPostStatistic.setLikeInfo(JSONObject.toJSONString(forumPostLikes));
        }
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public int doRefreshLikeInfo() {
        //根据时间查询要修改的帖子点赞信息
        List<ForumPostLike> postLikes = forumPostLikeMapper.selectNotShowPostLike();
        postLikes.forEach(e -> {
            e.setIsShow((byte) 1);
            forumPostLikeMapper.updateByPrimaryKeySelective(e);
            //帖子概览数据的更新
            this.doUpdateForumInfo(1, e.getPostId());
        });
        //异步发送消息推送
        SpringContextHolder.getBean(ForumPostStatisticService.class).asyncSendPostLikeMessage(postLikes);
        return CollectionUtils.isEmpty(postLikes) ? 0 : postLikes.size();
    }

    @Async
    @Override
    public void asyncSendPostLikeMessage(List<ForumPostLike> postLikes) {
        if (CollectionUtils.isNotEmpty(postLikes)) {
            postLikes.forEach(e -> {
                ForumPostVo postVo = forumPostMapper.selectByPrimaryKey(e.getPostId());
                //给用户添加赞数
                userIntegrationService.updateUserLikeNumByUserId(postVo.getUserId());

                final int postLikeConsume = getPostLikeConsume(postVo.getIsBrilliant());
                //用户已删除的帖子不发送推送
                boolean flag = postVo.getStatus() != 4;
                if (flag) {
                    //用户添加红花，帖子作者增加红花
                    String addContent = "你发布的【" + ExtendFactory.getPostContent(postVo.getTitle(), postVo.getTextField()) + "】被赞";
                    AccountGoldParam usableParam = AccountGoldParam.buildPostLikeAddParam(postVo.getUserId(), postLikeConsume, e.getId(), addContent);
                    this.userAccountIntegrationService.addGold(usableParam);
                    //推送点赞信息(机器人点赞没有platform)
                    this.doAsyncLikePost(e.getUserId(), e.getPostId(), 1, postVo.getAreaCode(), (byte) 1, null);
                }
            });
        }
    }

    @Override
    public int getPostLikeConsume(Integer isBrilliant) {
        if (Objects.isNull(isBrilliant) || isBrilliant == 0) {
            return clientConfigProperties.getPostCommonLikeConsume();
        } else {
            return clientConfigProperties.getPostBrilliantLikeConsume();
        }
    }

    @Async
    @Override
    public void doAsyncLikePost(Long userId, Long postId, int type, String areaCode, byte isOld, Integer platform) {
        if (1 == type) {
            ForumPostVo forumPostVo = forumPostMapper.selectByPrimaryKey(postId);
            //添加马甲号点赞(旧版没有马甲号点赞)
            this.generateVirtualLike(forumPostVo, isOld);
            //数据埋点(马甲号点赞时没有platform)
            if (Objects.nonNull(platform)) {
                bizLogIntegrationService.forumLikeSuccessed(userId, postId, areaCode, platform);
            } else {
                //马甲号点赞调用新版文文案接口 isOld = 0为新版文案接口
                isOld = 0;
            }
            //消息推送(新旧版文案不一)
            judgeEnablePlaceholder(forumPostVo, null);
            exchangeDetailPost(forumPostVo);
            this.messageService.pushPostLikeMessage(forumPostVo, userId, isOld, getPostLikeConsume(forumPostVo.getIsBrilliant()));
        }
    }

    /**
     * 返回包装类，如已经点赞过两篇文章，则不返回文案
     */
    @Override
    public void fillPostLikeDto(PostLikeDto postLikeDto, Long userId, Long authorUserId, int postLikeConsume) {
        String dateKey = DateFormatUtils.format(new Date(), "yyyy-MM-dd");
        KeyGenerator forumPostLikeTimeKey = RedisConfig.FORUMPOST_LIEK_TIME.copy().appendKey(dateKey).appendKey(userId);
        //点赞次数
        long likeCount = redisStringAdapter.incrementWithDefault(forumPostLikeTimeKey, 1, 1, 86400);
        if (likeCount <= 2L) {
            postLikeDto.setCopyWriter("已赞赏楼主" + postLikeConsume + "朵小红花");
            postLikeDto.setShowFlower(PostLikeDto.SUCCESS_CODE);
        } else {
            postLikeDto.setCopyWriter(null);
            postLikeDto.setShowFlower(PostLikeDto.FAILURE_CODE);
        }
    }

    @Override
    public Boolean judgeEnablePlaceholder(ForumPostVo postVo, LocationDTO location) {
        //开启占位符
        boolean flag = Objects.nonNull(postVo) && Objects.nonNull(postVo.getEnablePlaceholder()) && postVo.getEnablePlaceholder() == 1;
        if (flag) {
            //帖子标题是否为空
            boolean titleFlag = StringUtils.isNotBlank(postVo.getTitle());
            if (Objects.isNull(location) || StringUtils.isBlank(location.getName())) {
                if (titleFlag) {
                    postVo.setTitle(postVo.getTitle().replace("{areaname}", "本地"));
                }
                if (StringUtils.isNotBlank(postVo.getContent())) {
                    postVo.setContent(postVo.getContent().replace("{areaname}", "本地"));
                }
                postVo.setTextField(StringUtils.isNotBlank(postVo.getTextField()) ?
                        postVo.getTextField().replace("{areaname}", "本地") : postVo.getTextField());
            } else {
                if (titleFlag) {
                    postVo.setTitle(postVo.getTitle().replace("{areaname}", location.getName()));
                }
                if (StringUtils.isNotBlank(postVo.getContent())) {
                    postVo.setContent(postVo.getContent().replace("{areaname}", location.getName()));
                }
                postVo.setTextField(StringUtils.isNotBlank(postVo.getTextField()) ?
                        postVo.getTextField().replace("{areaname}", location.getName()) : postVo.getTextField());
            }
        }

        return flag;
    }

    @Async
    @Override
    public void doAsyncReadPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo, String ip) {
        //添加帖子阅读记录
        this.doRecordForumPost(userId, postId, shareUserId, platform, forumPostVo);
        //在小程序中每日首次打开,分享人随机获得20-50的小红花
        if (null != shareUserId && shareUserId != 0) {
            if (PlatformEnum.APPLET.getCode() == platform && !shareUserId.equals(userId)) {
                //用户首次打开小程序完成
                String content = "转发【" + ExtendFactory.getPostContent(forumPostVo.getTitle(), forumPostVo.getTextField()) + "】被阅读";
                NewsCompleTaskDTO firstBrowse = missionIntegrationService.compleTask(shareUserId, TaskEnum.TASK_FIRST_BROWSE.name(), userId.toString(), content);
                logger.info("用户={}在小程序中打开帖子,新闻id={},分享人的shareUserId={},完成任务接口返回={}", userId, forumPostVo.getId(), shareUserId, JSONObject.toJSONString(firstBrowse));
                if (Objects.nonNull(firstBrowse) && firstBrowse.getGoldNum() > 0) {
                    //提取必要信息
                    String extendContent = null;
                    List<PostImgVo> imgList = this.getDetailFromPost(forumPostVo.getPostImgList());
                    String extendUrl = CollectionUtils.isNotEmpty(imgList) ? null : imgList.get(0).getImgUrl();
                    if (StringUtils.isEmpty(extendUrl)) {
                        extendContent = ExtendFactory.getTitle(forumPostVo.getTitle(), forumPostVo.getTextField());
                    }
                    //发送消息
                    messageService.addMessage(
                            shareUserId,
                            userId,
                            firstBrowse,
                            forumPostVo.getId(),
                            ReplyTypeEnum.POST_REPLY.getCode(),
                            extendUrl,
                            extendContent,
                            forumPostVo.getTitle());
                }
            }
        }

        //如果是[站外]访问[待审核]的帖子，记录访问次数
        if (null != platform && PlatformEnum.WEB.getCode() == platform && 2 == forumPostVo.getStatus()) {
            KeyGenerator keyGenerator = RedisConfig.FORUM_RECORD_FROM_H5.copy().appendKey(postId);
            //将ip从字符串转为数值，便于存储
            long ipNum;
            if (StringUtils.isNotBlank(ip)) {
                ipNum = IPUtil.ip2long(ip);
            } else {
                ipNum = RandomUtils.nextLong();
            }
            hyperLogLogAdapter.add(keyGenerator, ipNum);
        }
    }

    @Override
    public void exchangeCoverPost(ForumPostVo forumPostVo) {
        List<PostImgVo> coverFromPost = this.getCoverFromPost(forumPostVo.getCoverList(), forumPostVo.getPostImgList(), forumPostVo.getCoverSelect());
        forumPostVo.setPostImgList(coverFromPost);
        if (CollectionUtils.isNotEmpty(coverFromPost)) {
            forumPostVo.setShareImg(coverFromPost.get(0));
        } else {
            forumPostVo.setShareImg(PostImgVo.buildImg(newsProperties.getDefaultShareCover()));
        }
    }

    @Override
    public void exchangeDetailPost(ForumPostVo forumPostVo) {
        forumPostVo.setShareImg(getShareImg(forumPostVo));
        forumPostVo.setPostImgList(getDetailFromPost(forumPostVo.getPostImgList()));
    }

    @Override
    public List<PostImgVo> getDetailFromPost(List<PostImgVo> imgList) {
        List<PostImgVo> coverList = new ArrayList<>();

        List<PostImgVo> videoCoverTempList = new ArrayList<>();
        List<PostImgVo> imgCoverTempList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(imgList)) {
            for (PostImgVo postImgVo : imgList) {
                if (StringUtils.isBlank(postImgVo.getType()) || StringUtils.isBlank(postImgVo.getImgUrl())) {
                    continue;
                }
                if ("VIDEO".equals(postImgVo.getType())) {
                    postImgVo.setImgUrl(assemblyService.buildVideoCover(postImgVo.getImgUrl()));
                    videoCoverTempList.add(postImgVo);
                } else if ("IMG".equals(postImgVo.getType())) {
                    postImgVo.setImgUrl(assemblyService.buildImgCover(postImgVo.getImgUrl()));
                    imgCoverTempList.add(postImgVo);
                }
            }
        }

        if (CollectionUtils.isNotEmpty(videoCoverTempList)) {
            coverList.addAll(videoCoverTempList);
        }
        if (CollectionUtils.isNotEmpty(imgCoverTempList)) {
            coverList.addAll(imgCoverTempList);
        }

        return coverList.stream().limit(9).collect(Collectors.toList());
    }

    @Override
    public List<PostImgVo> getCoverFromPost(String coverStr, List<PostImgVo> imgList, Byte coverSelect) {
        List<PostImgVo> coverArray = new ArrayList<>();
        //视频图片数量
        Integer videoSize = 1;
        //内容图片数量
        Integer imageSize = 3;
        if (coverSelect == 0) {
            coverArray = SpringContextHolder.getBean(NewsService.class).getCoverByCoverStr(coverStr);
            if (CollectionUtils.isEmpty(coverArray)) {
                coverArray = getCoverByVideo(imgList, videoSize);
            }
            if (CollectionUtils.isEmpty(coverArray)) {
                coverArray = getCoverByImgUrl(imgList, imageSize);
            }
        } else if (coverSelect == 1) {
            coverArray = getCoverByVideo(imgList, videoSize);
            if (CollectionUtils.isEmpty(coverArray)) {
                coverArray = getCoverByImgUrl(imgList, imageSize);
            }
        } else if (coverSelect == 2) {
            videoSize = 3;
            coverArray = getCoverByVideo(imgList, videoSize);
            if (coverArray.size() < videoSize) {
                imageSize = videoSize - coverArray.size();
                List<PostImgVo> coverByImgUrl = getCoverByImgUrl(imgList, imageSize);
                coverArray.addAll(coverByImgUrl);
            }
        }

        return coverArray;
    }

    /**
     * 内容图转封面
     *
     * @param imgList 图片列表
     * @param size    个数
     * @return 封面图
     */
    private List<PostImgVo> getCoverByImgUrl(List<PostImgVo> imgList, Integer size) {
        List<PostImgVo> result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(imgList)) {
            for (PostImgVo postImgVo : imgList) {
                if (StringUtils.isBlank(postImgVo.getType()) || StringUtils.isBlank(postImgVo.getImgUrl())) {
                    continue;
                }
                if ("IMG".equals(postImgVo.getType())) {
                    postImgVo.setImgUrl(assemblyService.buildImgCover(postImgVo.getImgUrl()));
                    result.add(postImgVo);
                }
                if (result.size() >= size) {
                    break;
                }
            }
        }

        return result;
    }

    /**
     * 视频图转封面
     *
     * @param videoList 视频图列表
     * @param size      个数
     * @return 封面图
     */
    private List<PostImgVo> getCoverByVideo(List<PostImgVo> videoList, Integer size) {
        List<PostImgVo> result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(videoList)) {
            for (PostImgVo postImgVo : videoList) {
                if (StringUtils.isBlank(postImgVo.getType()) || StringUtils.isBlank(postImgVo.getImgUrl())) {
                    continue;
                }
                if ("VIDEO".equals(postImgVo.getType())) {
                    postImgVo.setImgUrl(assemblyService.buildVideoCover(postImgVo.getImgUrl()));
                    result.add(postImgVo);
                }
                if (result.size() >= size) {
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public void doConsumeRecommendedCount(List<Long> ids, Long userId) {
        List<ForumPostStatistic> forumPostStatisticList =
                ids.stream().map(id -> ForumPostStatistic.buildRecommend(id, 1)).collect(Collectors.toList());
        MybatisBatchBuilder.create(ForumPostMapper.class, forumPostStatisticList).run(ForumPostMapper::updateStatisticByPrimaryKeySelective);
    }

    @Override
    public void doConsumeClickCount(Long postId, Long userId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setClickCount(1);
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public void doConsumeActiveViewCount(Long postId, Long userId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setReviewCount(1);
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public void doSyncPostLikeInfo() {
        List<Long> list = forumPostLikeMapper.selectNotExitsUserInfo();
        List<ForumPostLike> paramList = Lists.newArrayList();
        list.forEach(e -> {
            ForumPostLike postLike = new ForumPostLike();
            postLike.setUserId(e);
            UserBean userInfo = userIntegrationService.selectUserFromCache(e);
            if (Objects.nonNull(userInfo)) {
                postLike.setUserNickname(userInfo.getNickname());
                postLike.setHeadImg(userInfo.getHeadImg());
                paramList.add(postLike);
            }
        });
        MybatisBatchBuilder.create(ForumPostLikeMapper.class, paramList).run(ForumPostLikeMapper::updateUserInfoByUserId);
    }

    @Override
    public void doSyncPostStaticInfo() {
        List<Long> list = forumPostMapper.selectNotExitReplyAndLikeInfo();
        List<ForumPostStatistic> paramList = Lists.newArrayList();
        list.forEach(e -> {
            ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
            forumPostStatistic.setId(e);
            List<NewsReply> replyList = newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(e);
            if (CollectionUtils.isNotEmpty(replyList)) {
                forumPostStatistic.setReplyInfo(JSONObject.toJSONString(replyList));
            }
            List<ForumPostLike> forumPostLikes = forumPostLikeMapper.selectByPostIdAndOrderByAddtime(e);
            if (CollectionUtils.isNotEmpty(forumPostLikes)) {
                forumPostStatistic.setLikeInfo(JSONObject.toJSONString(forumPostLikes));
            }
            boolean flag = !(StringUtils.isBlank(forumPostStatistic.getLikeInfo()) && StringUtils.isBlank(forumPostStatistic.getReplyInfo()));
            if (flag) {
                paramList.add(forumPostStatistic);
            }
        });
        MybatisBatchBuilder.create(ForumPostMapper.class, paramList).run(ForumPostMapper::updateStatisticByPrimaryKeySelective);
    }

    @Override
    public List<CalculatePostDTO> calculatePostCount() {
        List<CalculatePostDTO> result = Lists.newArrayList();
        //最近半小时发帖统计
        List<PostCount> newPostCount = forumPostMapper.selectNewPostCount();
        //未审核帖子数量
        List<PostCount> unreviewedCounts = forumPostMapper.selectPendingReviewCount();
        newPostCount.forEach(e -> {
            CalculatePostDTO calculatePostDTO = new CalculatePostDTO();
            if (StringUtils.isNotBlank(e.getAreaCode())) {
                LocationDTO location = locationIntegrationService.getLocationByGeocode(e.getAreaCode());
                calculatePostDTO.setAreaName(location.getName());
                calculatePostDTO.setAreaCode(e.getAreaCode());
            } else {
                calculatePostDTO.setAreaName("其他地区");
                calculatePostDTO.setAreaCode(StringUtils.EMPTY);
            }
            calculatePostDTO.setNewPostCount(e.getNum());
            Integer unReviewed = unreviewedCounts.stream().filter(k -> StringUtils.equalsIgnoreCase(e.getAreaCode(), k.getAreaCode()))
                    .findFirst().map(PostCount::getNum).orElse(0);
            calculatePostDTO.setPendingReviewCount(unReviewed);
            int userCount = forumPostMapper.selectUserCount(e.getAreaCode());
            calculatePostDTO.setUserCount(userCount);
            result.add(calculatePostDTO);
        });
        return result;
    }

    @Override
    public void calcParticipantsNum() {
        logger.info("calculate participants num start. ");

        calcAllParticipantsNum();
        calcAreaParticipantsNum();

        //清除缓存
        //redisHashMapAdapter.remove(RedisConfig.FORUM.copy());
        redisHashMapAdapter.remove(RedisConfig.TOPIC.copy());

        logger.info("calculate participants num end. ");
    }

    /**
     * 计算话题全国参与人数
     */
    private void calcAllParticipantsNum() {
        //计算版块参与人数
//        List<ForumVo> forumVoList = forumMapper.getForumList(null, null);
//        if (CollectionUtils.isNotEmpty(forumVoList)) {
//            for (ForumVo forumVo : forumVoList) {
//                Integer participantsNum = getParticipantsNum(forumVo.getId(), null, null);
//                forumMapper.updateForum(forumVo.getId(), participantsNum);
//            }
//        }

        //计算话题参与人数
        List<TopicVo> topicVoList = forumTopicMapper.getTopicList(null, null);
        if (CollectionUtils.isNotEmpty(topicVoList)) {
            for (TopicVo topicVo : topicVoList) {
                Integer participantsNum = getParticipantsNum(null, topicVo.getId(), null);
                forumTopicMapper.updateTopic(topicVo.getId(), participantsNum);
            }
        }
    }

    /**
     * 计算话题区域参与人数
     */
    private void calcAreaParticipantsNum() {
        //获取版块话题投放区域
        List<ForumTopicAreaRelationVo> areaRelationVoList = forumTopicMapper.getAreaRelationList();

        if (CollectionUtils.isNotEmpty(areaRelationVoList)) {
            //根据区域计算参与人数
            areaRelationVoList.stream()
                    .filter(e -> null != e.getType() && null != e.getRelationId() && StringUtils.isNotBlank(e.getAreaCode()))
                    .forEach(e -> {
//                        if ((byte) 1 == e.getType()) {
//                            Integer participantsNum = getParticipantsNum(e.getRelationId(), null, e.getAreaCode());
//                            forumMapper.updateAreaParticipantsNum(e.getId(), participantsNum);
//                        } else if ((byte) 2 == e.getType()) {
                        if ((byte) 2 == e.getType()) {
                            Integer participantsNum = getParticipantsNum(null, e.getRelationId(), e.getAreaCode());
                            forumTopicMapper.updateAreaParticipantsNum(e.getId(), participantsNum);
                        }
                    });
        }
    }

    private Integer getParticipantsNum(Long forumId, Long topicId, String areaCode) {
        Integer participantsNum = forumPostMapper.calcPostNum(forumId, topicId, areaCode);
        if (null == participantsNum) {
            participantsNum = 0;
        }

        List<Long> postIdList = forumPostMapper.getPostIdList(forumId, topicId, areaCode);
        if (CollectionUtils.isNotEmpty(postIdList)) {
            for (Long postId : postIdList) {
                Integer replyNum = newsReplyMapper.calcReplyNum(postId);
                if (replyNum != null) {
                    participantsNum += replyNum;
                }
            }
        }

        return participantsNum;
    }

    @Override
    public NewsCompleTaskDTO completeTask(ForumPostVo forumPostVo) {
        Long userId = forumPostVo.getUserId();
        Long postId = forumPostVo.getId();
        //首次发帖
        String content = "首次发布【" + ExtendFactory.getPostContent(forumPostVo.getTitle(), forumPostVo.getTextField()) + "】";
        NewsCompleTaskDTO newsCompleTaskDTO = missionIntegrationService.compleTask(userId, TaskEnum.TASK_FIRST_POST_INTIVATION.name(), postId.toString(), content);
        //日常发帖
        if (null == newsCompleTaskDTO || null == newsCompleTaskDTO.getGoldNum() || 0L == newsCompleTaskDTO.getGoldNum()) {
            content = "发布【" + ExtendFactory.getPostContent(forumPostVo.getTitle(), forumPostVo.getTextField()) + "】";
            newsCompleTaskDTO = missionIntegrationService.compleTask(userId, TaskEnum.TASK_POST_INTIVATION.name(), postId.toString(), content);
        }
        return newsCompleTaskDTO;
    }

    @Async
    @Override
    public void addPostLike(ForumPostVo forumPostVo, Integer num) {
        //获取足够多的虚拟用户id
        List<VirtualUserInfo> virtualUserList = userIntegrationService.getVirtualUserListNew(num * 2, Lists
                .newArrayList(1, 2, 3), forumPostVo.getAreaCode());

        log.debug("发布帖子 异步获取点赞马甲数据 ： {}", virtualUserList);

        ArrayList<ForumPostLike> list = Lists.newArrayList();
        for (VirtualUserInfo virtualUser : virtualUserList) {
            ForumPostLike like = forumPostLikeMapper.selectByUserIdAndPostId(virtualUser.getId(), forumPostVo.getId());
            //该虚拟用户信息不存在时,添加虚拟用户点赞信息
            if (Objects.isNull(like)) {
                Calendar calendar = Calendar.getInstance();
                //随机时间生成马甲号点赞
                int amount = (int) (1 + Math.random() * (120));
                calendar.add(Calendar.MINUTE, amount);
                ForumPostLike postLike = ForumPostLike.builder()
                        .addTime(calendar.getTime())
                        .headImg(virtualUser.getHeadImg())
                        .id(nextId())
                        .isShow((byte) 0)
                        .isVest((byte) 1)
                        .postId(forumPostVo.getId())
                        .type((byte) 1)
                        .userId(virtualUser.getId())
                        .userNickname(virtualUser.getNickname())
                        .build();
                list.add(postLike);
            }
            //达到规定数量跳出循环
            if (list.size() >= num) {
                break;
            }
        }
        //批量插入虚拟用户点赞信息
        MybatisBatchBuilder.create(ForumPostLikeMapper.class, list).run(ForumPostLikeMapper::insertSelective);
    }

    @Async
    @Override
    public void addPostReply(ForumPostVo forumPostVo) {
        //需要添加评论的数量
        final int size = 5;
        List<String> list = newsReplyMapper.selectRandomReplyLibrary(replyConfigProperties.getNewReportId(), size);
        List<VirtualUserInfo> userList = userIntegrationService.getVirtualUserListNew(size, Lists.newArrayList(1, 2, 3),
                forumPostVo.getAreaCode());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        int i = 0;
        for (String replyContent : list) {
            int nextTime = ThreadLocalRandom.current().nextInt(300000);
            VirtualUserInfo virtualUser = userList.get(i);
            NewsReply newsReply = new NewsReply();
            newsReply.setAddTime(new Date(System.currentTimeMillis() + nextTime));
            newsReply.setDeleteFlag((byte) 0);
            newsReply.setHeadImg(virtualUser.getHeadImg());
            newsReply.setId(nextSequence());
            newsReply.setLevel((byte) 0);
            newsReply.setLikeCount(0);
            newsReply.setNewsId(forumPostVo.getId());
            newsReply.setReplyContent(replyContent);
            //如果是帖子
            newsReply.setType((byte) 3);
            newsReply.setParentId(0L);
            //都设置为待展示，等待扫描
            newsReply.setStatus((byte) 0);
            newsReply.setUserId(virtualUser.getId());
            newsReply.setUserNickname(virtualUser.getNickname());
            newsReply.setInteractiveCount(0);
            newsReply.setRootId(0L);
            newsReplyMapper.insertSelective(newsReply);
            UserReply userReply = new UserReply();
            BeanUtils.copyProperties(newsReply, userReply);
            userReplyMapper.insertSelective(userReply);
            i++;
        }
    }

    @Override
    public void doRecordForumPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo) {
        ForumPostRecord pRecord = this.forumPostRecordMapper.selectByIds(postId, userId, null);
        Date d = new Date();
        if (pRecord != null) {
            pRecord.setUpdateTime(d);
            this.forumPostRecordMapper.updateByPrimaryKeySelective(pRecord);
        } else {
            ForumPostRecord nr = new ForumPostRecord();
            nr.setId(nextSequence());
            nr.setPostId(postId);
            nr.setUserId(userId);
            nr.setUpdateTime(d);
            nr.setCheckTime(0);
            nr.setGetGold(AppConst.UN_GOLD);
            nr.setAddTime(d);
            nr.setLastLocation("1");
            nr.setAdViewType((byte) 1);
            this.forumPostRecordMapper.insertSelective(nr);
        }

        this.doConsumeClickCount(postId, userId);
    }

    @Async
    @Override
    public void doAsyncAddPublishNum(ForumPostVo forumPostVo) {
        try {
            userIntegrationService.addPostReplyNum(forumPostVo.getUserId(), 1);
        } catch (Exception e) {
            logger.debug("新增帖子调用增加发布数服务失败：", e);
        }
    }

    @Async
    @Override
    public void doTriggerUpdateInfo(Long userId, String nickname, String headImg) {
        List<ForumPostVo> forumPostVoList = forumPostMapper.selectForumPostByUser(userId);
        for (ForumPostVo forumPostVo : forumPostVoList) {
            forumPostMapper.updateUserInfo(forumPostVo.getId(), userId, headImg, nickname);
        }
    }

    @Async
    @Override
    public void doTriggerUpdateForumPostLikeInfo(Long userId, String nickname, String headImg) {
        if (StringUtils.isBlank(nickname) && StringUtils.isBlank(headImg)) {
            return;
        }
        forumPostLikeMapper.updateNickNameAndHeadImgByUserId(userId, nickname, headImg);
    }

    @Override
    public void generateForumPostContent(ForumPostVo forumPostVo, BasicParam basicParam, String ip, Long userId, String areaCode) {
        if (StringUtils.isNotEmpty(forumPostVo.getContent())) {
            if (StringUtils.isNotBlank(forumPostVo.getEditorMessage())) {
                forumPostVo.setContent(forumPostVo.getContent() + forumPostVo.getEditorMessage());
            }
            if (StringUtils.isNotBlank(forumPostVo.getForumContent())) {
                forumPostVo.setContent(forumPostVo.getContent() + forumPostVo.getForumContent());
            }
            // app和小程序不需要完整的html，只返回body部分
            // 1是h5的标志，h5在内嵌在app时，继承上级上下文，所以platform不能区分
            if (StringUtils.equals("1", basicParam.getDevcId()) ||
                    PlatformEnum.APPLET.getCode() == basicParam.getPlatform() ||
                    PlatformEnum.WEB.getCode() == basicParam.getPlatform()) {
                //取body的内容
                forumPostVo.setContent(assemblyService.fixContent(forumPostVo.getContent(), basicParam, ip, ReplyTypeEnum.POST_REPLY.getCode(), userId, areaCode, forumPostVo.getId()));
            } else {
                String content = assemblyService.assemblyContent(forumPostVo.getContent(), basicParam, ip, ReplyTypeEnum.POST_REPLY.getCode(), userId, areaCode, forumPostVo.getId());
                forumPostVo.setContent(content);
            }
        }
    }

    /**
     * 生成机器人点赞信息
     *
     * @param forumPostVo 帖子信息
     * @param isOld       是否是旧版点赞 1：旧版 0：新版
     */
    private void generateVirtualLike(ForumPostVo forumPostVo, int isOld) {
        if (isOld != 0) {
            return;
        }
        //当用户已经在该条帖子发布评论时,或者获得虚拟用户为空时 重新获得虚拟用户
        List<VirtualUserInfo> virtualUserList = userIntegrationService.getVirtualUserListNew(20, Lists.newArrayList(1, 2, 3), forumPostVo.getAreaCode());
        if (CollectionUtils.isEmpty(virtualUserList)) {
            return;
        }
        for (VirtualUserInfo virtualUserInfo : virtualUserList) {
            ForumPostLike like = forumPostLikeMapper.selectByUserIdAndPostId(virtualUserInfo.getId(), forumPostVo.getId());
            if (Objects.isNull(like)) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(Calendar.MINUTE, 3);
                ForumPostLike postLike = ForumPostLike.buildVestPostLike(nextId(), forumPostVo.getId(), virtualUserInfo.getId());
                postLike.setAddTime(calendar.getTime());
                postLike.setHeadImg(virtualUserInfo.getHeadImg());
                postLike.setUserNickname(virtualUserInfo.getNickname());
                forumPostLikeMapper.insertSelective(postLike);
                logger.info("添加马甲点赞成功,点赞信息:{}", JSONObject.toJSONString(postLike));
                break;
            }
        }
    }

    /**
     * 按次序取得分享图片
     *
     * @param forumPostVo 帖子信息
     * @return 图片
     */
    private PostImgVo getShareImg(ForumPostVo forumPostVo) {
        List<PostImgVo> coverFromPost = getCoverFromPost(forumPostVo.getCoverList(), forumPostVo.getPostImgList(), forumPostVo.getCoverSelect());
        if (CollectionUtils.isNotEmpty(coverFromPost)) {
            return coverFromPost.get(0);
        } else {
            return PostImgVo.buildImg(newsProperties.getDefaultShareCover());
        }
    }

}
