package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.NewsSearchIntegrationService;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.localnews.news.dto.ReplenishmentDTO;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.service.ForumPostService;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.localnews.news.service.MixRecommendService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.MixedRecommendPool;
import com.bxm.localnews.news.vo.NewsVO;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class MixRecommendServiceImpl extends BaseService implements MixRecommendService {

    private final MixedRecommendPoolMapper mixedRecommendPoolMapper;

    private ForumPostMapper forumPostMapper;

    private LocationIntegrationService locationIntegrationService;

    private NewsService newsService;

    private ForumPostStatisticService forumPostStatisticService;

    private NewsSearchIntegrationService newsSearchIntegrationService;

    @Autowired
    public MixRecommendServiceImpl(MixedRecommendPoolMapper mixedRecommendPoolMapper,
                                   ForumPostMapper forumPostMapper,
                                   LocationIntegrationService locationIntegrationService,
                                   NewsService newsService,
                                   ForumPostStatisticService forumPostStatisticService,
                                   NewsSearchIntegrationService newsSearchIntegrationService) {
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.forumPostMapper = forumPostMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.newsService = newsService;
        this.forumPostStatisticService = forumPostStatisticService;
        this.newsSearchIntegrationService = newsSearchIntegrationService;
    }

    @Override
    public List<ReplenishmentDTO> listRecommend(Long userId, String areaCode, Byte type, Integer size) {
        List<ReplenishmentDTO> result = Lists.newArrayList();

        LocationDTO location = null;
        if (StringUtils.isNotEmpty(areaCode)) {
            location = locationIntegrationService.getLocationByGeocode(areaCode);
        }
        List<ForumPostVo> postList = mixedRecommendPoolMapper.selectByBrokePost(areaCode, size);
        if (CollectionUtils.isNotEmpty(postList)) {
            LocationDTO finalLocation = location;
            postList.forEach(e -> result.add(forumRoReplenishment(e, finalLocation)));
        }

        //本地新闻&全国新闻
        if (result.size() < size) {
            List<Long> list = mixedRecommendPoolMapper.selectLocalNewsByAreaCode(areaCode, size - result.size());
            List<NewsVO> newsVoList = newsSearchIntegrationService.multipleGet(list.toArray(new Long[0]));
            if (CollectionUtils.isNotEmpty(newsVoList)) {
                LocationDTO finalLocation = location;
                newsVoList.forEach(e -> result.add(newsToReplenishment(e, finalLocation)));
            }
        }
        return result;
    }

    @Override
    public ReplenishmentDTO getHotPostOrNews(Long userId, String areaCode, Byte type) {
        if (null == type) {
            type = 3;
        }

        LocationDTO location = locationIntegrationService.getLocationByGeocode(areaCode);

        MixedRecommendPool mixedRecommendPool = mixedRecommendPoolMapper.selectHotRecommend(areaCode, userId);
        logger.info("[getHotPostOrNews]得到权重最高的帖子或者新闻，推荐库中权重最高:{}", JSONObject.toJSONString(mixedRecommendPool));
        if (null == mixedRecommendPool) {
            return null;
        }

        ReplenishmentDTO replenishmentDTO = new ReplenishmentDTO();
        if ("1".equals(mixedRecommendPool.getOrigin())) {
            ForumPostVo postVo = forumPostMapper.selectByPrimaryKey(mixedRecommendPool.getId());
            if (postVo != null) {
                replenishmentDTO = forumRoReplenishment(postVo, location);
            }
        } else if ("2".equals(mixedRecommendPool.getOrigin()) || "3".equals(mixedRecommendPool.getOrigin())) {
            List<NewsVO> newsVoList = newsSearchIntegrationService.multipleGet(new Long[]{mixedRecommendPool.getId()});
            if (CollectionUtils.isNotEmpty(newsVoList)) {
                NewsVO newsVO = newsVoList.get(0);
                replenishmentDTO = newsToReplenishment(newsVO, location);
            }
        }

        logger.info("[getHotPostOrNews]得到权重最高的帖子或者新闻,结果:{}", JSONObject.toJSONString(replenishmentDTO));
        return replenishmentDTO;
    }

    private ReplenishmentDTO forumRoReplenishment(ForumPostVo forumPostVo, LocationDTO location) {
        ReplenishmentDTO replenishmentDTO = new ReplenishmentDTO();
        replenishmentDTO.setImgList(forumPostStatisticService.getCoverFromPost(forumPostVo.getCoverList(), forumPostVo.getPostImgList(),forumPostVo.getCoverSelect()).stream().map(PostImgVo::getImgUrl).collect(Collectors.toList()));
        replenishmentDTO.setId(forumPostVo.getId());
        forumPostStatisticService.judgeEnablePlaceholder(forumPostVo, location);
        logger.debug("拼装分享、轮播帖子:[{}],地区信息:[{}]", JSONObject.toJSONString(forumPostVo), JSONObject.toJSONString(location));
        replenishmentDTO.setTitle(ExtendFactory.getSharePostContent(forumPostVo.getTitle(), forumPostVo.getTextField()));
        replenishmentDTO.setOrigin("1");

        return replenishmentDTO;
    }

    private ReplenishmentDTO newsToReplenishment(NewsVO news, LocationDTO location) {
        ReplenishmentDTO replenishmentDTO = new ReplenishmentDTO();
        replenishmentDTO.setId(news.getId());
        if (news.getAreaDetail() != null) {
            replenishmentDTO.setOrigin("2");
        } else {
            replenishmentDTO.setOrigin("3");
        }
        newsService.judgeEnablePlaceholder(news, location);
        logger.debug("拼装分享、轮播新闻:[{}],地区信息:[{}]", JSONObject.toJSONString(news), JSONObject.toJSONString(location));
        replenishmentDTO.setTitle(news.getTitle());
        replenishmentDTO.setImgList(newsService.getCoverFromNews(news.getCoverList(),news.getImgUrl(), news.getVideoList(),news.getCoverSelect()).stream().map(PostImgVo::getImgUrl).collect(Collectors.toList()));
        return replenishmentDTO;
    }

}
