package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.action.stream.MessageProcessor;
import com.bxm.localnews.news.domain.UserLocationSyncMapper;
import com.bxm.localnews.news.service.UserLocationSyncService;
import com.bxm.localnews.news.vo.UserLocationSyncVo;
import com.bxm.localnews.user.event.LocationActionEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;


@Service
@Slf4j
public class UserLocationSyncServiceImpl implements UserLocationSyncService {

    @Resource
    UserLocationSyncMapper userLocationSyncMapper;

    @StreamListener(MessageProcessor.USER_LOCATION_INPUT)
    public void handlerLocationChange(LocationActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("接收到用户位置信息变更：{}", JSON.toJSONString(event));
        }

        if (null != event) {
            syncUserLocation(event.getUserId(), event.getLocationCode());
        }
    }

    @Override
    public void syncUserLocation(Long userId, String areaCode) {

        Long uid = userLocationSyncMapper.hasUser(userId);

        UserLocationSyncVo userLocationSyncVo = new UserLocationSyncVo();
        userLocationSyncVo.setUserId(userId);
        userLocationSyncVo.setAreaCode(StringUtils.isEmpty(areaCode) ? null : areaCode);

        if (null != uid) {
            userLocationSyncMapper.update(userLocationSyncVo);
        } else {
            userLocationSyncMapper.insert(userLocationSyncVo);
        }
    }
}
