package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.news.domain.VideoShareMapper;
import com.bxm.localnews.news.event.VideoShareActionEvent;
import com.bxm.localnews.news.param.VideoShareParam;
import com.bxm.localnews.news.service.VideoShareService;
import com.bxm.localnews.news.vo.VideoShare;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.google.common.eventbus.EventBus;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class VideoShareServiceImpl extends BaseService implements VideoShareService {

    @Autowired
    private VideoShareMapper videoShareMapper;

    @Autowired
    private EventBus userActionEventBus;

    @Override
    public Message produceVideoShare(VideoShareParam videoShareParam) {
        VideoShare videoShare = new VideoShare();
        BeanUtils.copyProperties(videoShareParam, videoShare);
        videoShare.setId(nextSequence());
        videoShare.setAddTime(new Date());
        videoShareMapper.insertSelective(videoShare);

        userActionEventBus.post(VideoShareActionEvent.of()
                .setTargetId(videoShareParam.getVideoId())
                .setType(videoShareParam.getType())
                .setUserId(videoShare.getUserId()));
        return Message.build(true);
    }
}
