package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.news.domain.VideoBlackMapper;
import com.bxm.localnews.news.domain.VideoMapper;
import com.bxm.localnews.news.domain.VideoShareMapper;
import com.bxm.localnews.news.domain.VideoViewMapper;
import com.bxm.localnews.news.event.*;
import com.bxm.localnews.news.param.VideoBlackParam;
import com.bxm.localnews.news.param.VideoShareParam;
import com.bxm.localnews.news.param.VideoViewParam;
import com.bxm.localnews.news.service.VideoStatisticService;
import com.bxm.localnews.news.vo.Video;
import com.bxm.localnews.news.vo.VideoBlack;
import com.bxm.localnews.news.vo.VideoView;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class VideoStatisticServiceImpl extends BaseService implements VideoStatisticService {

    private final VideoBlackMapper videoBlackMapper;

    private final VideoShareMapper videoShareMapper;

    private final VideoViewMapper videoViewMapper;

    private final VideoMapper videoMapper;

    private final RedisListAdapter redisListAdapter;

    private final EventBus userActionEventBus;

    public VideoStatisticServiceImpl(VideoBlackMapper videoBlackMapper,
                                     VideoShareMapper videoShareMapper,
                                     VideoViewMapper videoViewMapper,
                                     VideoMapper videoMapper,
                                     RedisListAdapter redisListAdapter,
                                     EventBus userActionEventBus) {
        this.videoBlackMapper = videoBlackMapper;
        this.videoShareMapper = videoShareMapper;
        this.videoViewMapper = videoViewMapper;
        this.videoMapper = videoMapper;
        this.redisListAdapter = redisListAdapter;
        this.userActionEventBus = userActionEventBus;

        userActionEventBus.register(this);
    }

    @Subscribe
    public void handler(UserActionEvent event) {
        switch (event.getAction()) {
            case VIDEO_BLACK:
                VideoBlackActionEvent actionEvent = (VideoBlackActionEvent) event;
                VideoBlackParam param = new VideoBlackParam();
                param.setUserId(event.getUserId());
                param.setReason(actionEvent.getReason());
                param.setType(actionEvent.getType());
                param.setVideoId(actionEvent.getVideoId());

                videoBlackConsume(param);
                break;

            case VIDEO_COMMENT:
                VideoCommentActionEvent commentActionEvent = (VideoCommentActionEvent) event;

                videoCommentsConsume(event.getUserId(), commentActionEvent.getTargetId());
                break;
            case VIDEO_VIEW:
                VideoViewActionEvent videoViewActionEvent = (VideoViewActionEvent) event;

                VideoViewParam viewParam = new VideoViewParam();
                viewParam.setFullView(videoViewActionEvent.getFullView());
                viewParam.setUserId(videoViewActionEvent.getUserId());
                viewParam.setVideoId(videoViewActionEvent.getVideoId());
                viewParam.setViewTime(videoViewActionEvent.getViewTime());

                videoViewConsume(viewParam);
                break;
            case VIDEO_SHARE:
                VideoShareActionEvent shareActionEvent = (VideoShareActionEvent) event;
                VideoShareParam shareParam = new VideoShareParam();
                shareParam.setUserId(shareActionEvent.getUserId());
                shareParam.setVideoId(shareActionEvent.getTargetId());
                shareParam.setType(shareActionEvent.getType());

                videoShareConsume(shareParam);
            default:
                break;
        }
    }

    @Override
    public void videoBlackConsume(VideoBlackParam videoBlackParam) {
        if (null != videoBlackParam) {
            VideoBlack videoBlack = new VideoBlack();
            BeanUtils.copyProperties(videoBlackParam, videoBlack);
            videoBlack.setId(nextSequence());
            videoBlack.setAddTime(new Date());
            videoBlackMapper.insertSelective(videoBlack);
        }
    }

    @Override
    public void videoShareConsume(VideoShareParam videoShareParam) {
        if (null != videoShareParam) {
            //更新新闻分享数量
            Video videoUp = new Video();
            videoUp.setId(videoShareParam.getVideoId());
            videoUp.setShareCount((long) 1);
            videoMapper.updateStatisticByPrimaryKeySelective(videoUp);
        }
    }

    @Override
    public void videoViewConsume(VideoViewParam videoViewParam) {
        if (null != videoViewParam) {
            VideoView videoView = new VideoView();
            BeanUtils.copyProperties(videoViewParam, videoView);
            videoView.setId(nextSequence());
            videoViewMapper.insertSelective(videoView);
            //更新新闻点击播放数
            Video videoUp = new Video();
            videoUp.setId(videoView.getVideoId());
            videoUp.setClickCount((long) 1);
            videoMapper.updateStatisticByPrimaryKeySelective(videoUp);

        }
    }

    @Override
    public void videoCommentsConsume(Long userId, Long videoId) {
        Video videoUp = new Video();
        videoUp.setId(videoId);
        videoUp.setCommentCount((long) 1);
        videoMapper.updateStatisticByPrimaryKeySelective(videoUp);

    }
}
