package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.news.event.VideoViewActionEvent;
import com.bxm.localnews.news.param.VideoViewParam;
import com.bxm.localnews.news.service.VideoViewService;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.google.common.eventbus.EventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VideoViewServiceImpl extends BaseService implements VideoViewService {

    @Autowired
    private EventBus userActionEventBus;

    @Override
    public Message produceVideoView(VideoViewParam videoViewParam) {

        userActionEventBus.post(VideoViewActionEvent.of()
                .setFullView(videoViewParam.getFullView())
                .setVideoId(videoViewParam.getVideoId())
                .setViewTime(videoViewParam.getViewTime())
                .setUserId(videoViewParam.getUserId()));
        return Message.build(true);
    }

}
