package com.bxm.localnews.news.task;

import com.bxm.localnews.news.service.ShareRankService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 定期刷新分享排行榜信息
 * @author liujia
 * @date 2020/05/13 20:15
 */
@Component
public class AutoRefreshShareRankTask extends AbstractCronTask<String> {

    @Autowired
    private ShareRankService shareRankService;

    @Override
    protected ReturnT<String> service(String s) {
        shareRankService.refreshCache();
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return AutoRefreshShareRankTask.class.getSimpleName();
    }

    @Override
    public String cron() {
        return "0 0/10 * * * ? ";
    }

    @Override
    public String description() {
        return "定期刷新分享内容排行榜";
    }
}
