package com.bxm.localnews.news.task;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.service.ForumPostFacadeService;
import com.bxm.localnews.news.vo.ForumPostClickCountVo;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

/**
 * 创建即发布的周期定时任务【推荐库】
 * 为了模拟推荐库中文章【帖子、新闻】的阅读数，丽雅后来说推荐库的阅读数要额外多一些，具体逻辑和帖子阅读数差不多
 */
@Component
@Slf4j
public class CalcRecommendPostClickCountTask extends AbstractCronTask<String> {
    private static final Integer BATCH_SIZE = 50;

    @Resource
    private ForumPostFacadeService forumPostFacadeService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info(".....................................帖子阅读数相关计算【推荐库】 begin...................................");
        List<ForumPostClickCountVo> recommendForumPostClickCountVoList = forumPostFacadeService.getRecentRecommendPosts(3000);

        if (CollectionUtils.isNotEmpty(recommendForumPostClickCountVoList)) {
            log.debug("获取到需要计算的帖子列表【推荐库】：" + JSON.toJSONString(recommendForumPostClickCountVoList));
            addRecommendPostClickCount(recommendForumPostClickCountVoList.stream().map(ForumPostClickCountVo::getId).collect(Collectors.toList()));
        }

        log.info(".....................................帖子阅读数相关计算【推荐库】 end...................................");
        return ReturnT.SUCCESS;
    }

    private void addRecommendPostClickCount(List<Long> newForumPosts) {
        List<ForumPostClickCountVo> forumPostClickList = new ArrayList<>();

        //小于3000的在600-1000范围内增加
        if (CollectionUtils.isNotEmpty(newForumPosts)) {
            newForumPosts.forEach(e -> {
                ForumPostClickCountVo forumPostClickCountVo = new ForumPostClickCountVo();
                forumPostClickCountVo.setId(e);
                forumPostClickCountVo.setClickCount(600 + new Random().nextInt(400));
                forumPostClickList.add(forumPostClickCountVo);
            });
        }

        if (CollectionUtils.isNotEmpty(forumPostClickList)) {
            int i = 0;
            while (i + BATCH_SIZE < forumPostClickList.size()) {
                forumPostFacadeService.batchAddClick(forumPostClickList.subList(i, i + BATCH_SIZE));
                i += BATCH_SIZE;
            }
            forumPostFacadeService.batchAddClick(forumPostClickList.subList(i, forumPostClickList.size()));

        }
    }

    @Override
    public String taskName() {
        return "calcRecommendPostClickCountTask";
    }

    @Override
    public String cron() {
        return "30 * * * * ?";
    }

    @Override
    public String description() {
        return "定时增加帖子阅读数任务【推荐库】";
    }

}
