package com.bxm.localnews.news.task;

import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 创建即发布的周期定时任务
 * 计算话题参与人数，显示在话题上
 */
@Component
@Slf4j
public class ForumCalcTask extends AbstractCronTask<String> {

    @Resource
    private ForumPostStatisticService forumPostStatisticService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info(".....................................社区相关计算 begin...................................");
        forumPostStatisticService.calcParticipantsNum();
        log.info(".....................................社区相关计算 end.....................................");
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "forumCalcTask";
    }

    @Override
    public String cron() {
        return "0 0/10 * * * ? *";
    }

    @Override
    public String description() {
        return "社区相关计算";
    }

}
