package com.bxm.localnews.news.task;

import com.bxm.localnews.news.service.NewsQuartzService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;


/**
 * 创建即发布的周期定时任务
 * 将redis中的新闻频道列表同步至数据库中，现在没有用了
 */
@Component
@Slf4j
@Deprecated
public class NewsKindConsumer extends AbstractCronTask<String> {

    @Resource
    private NewsQuartzService newsQuartzService;

    @Override
    protected ReturnT<String> service(String param) {
        newsQuartzService.syncMykindToData();
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "newsKindConsumer";
    }

    @Override
    public String cron() {
        return "0 0/5 * * * ?";
    }

    @Override
    public String description() {
        return "用户新闻频道同步";
    }

}
