package com.bxm.localnews.news.task;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.localnews.news.domain.NewsMonitorMapper;
import com.bxm.localnews.news.service.NewsQuartzService;
import com.bxm.localnews.news.vo.MonitorTaskBuildParam;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;

/**
 * 新闻模块
 * 根据新闻配置的监控策略定时运行，判断到底时间点后新闻是否达到了指定的数量
 */
@Component
@Slf4j
public class NewsMonitorTask extends AbstractTaskCallback<MonitorTaskBuildParam> {

    @Resource
    private NewsMonitorMapper newsMonitorMapper;

    @Resource
    private MessageSender messageSender;

    @Resource
    private NewsQuartzService newsQuartzService;

    @Override
    protected ReturnT<String> service(MonitorTaskBuildParam param) {
        if (null == param || null == param.getIndexId() || null == param.getMonitorId() || param.getNum() == null) {
            return ReturnT.FAIL;
        }

        log.warn("新闻监控执行参数：{}", JSONObject.toJSONString(param));

        //根据触发时间来调用新闻数据汇总
        Date startTime = new Date();
        startTime = DateUtils.clearTimePart(startTime);

        Date endTime = DateUtils.addField(startTime, Calendar.HOUR_OF_DAY, NumberUtils.parseToInt(param.getFireTime()));

        param.setStartTime(DateUtils.formatDateTime(startTime));
        param.setEndTime(DateUtils.formatDateTime(endTime));
        if (0 == param.getKindId()) {
            param.setKindId(null);
        }
        if (StringUtils.isNotBlank(param.getAreaCodes())) {
            String[] areaArray = StringUtils.split(param.getAreaCodes(), ",");
            for (String areaCode : areaArray) {
                param.setAreaCode(areaCode);
                log.warn("新闻监控执行参数[增加时间区间]：{}", JSONObject.toJSONString(param));
                sendMsg(param, areaCode);
            }
        } else {
            sendMsg(param, null);
        }

        return ReturnT.SUCCESS;
    }

    private void sendMsg(MonitorTaskBuildParam param, String areaCode) {
        int total = newsQuartzService.countNews(param);
        if (total < param.getNum()) {
            String content = "监控指标[" + param.getName() + "]异常，要求新闻数量:[" + param.getNum() + "],实际数量:[" + total + "]";
            if (areaCode != null) {
                content += "，监控区域：[" + newsMonitorMapper.getAreaName(areaCode) + "]";
            }

            messageSender.sendDingtalk(DingtalkMessage.builder()
                    .content(content)
                    .scene("news")
                    .build());

            newsQuartzService.updateMonitorStatus(param.getMonitorId(), 1, content);
        } else {
            newsQuartzService.updateMonitorStatus(param.getMonitorId(), 0, null);
        }
    }

    public static String generateTaskName(Long indexId) {
        return "newsMonitorTask_" + indexId;
    }

}
